/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.project;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.netbeans.api.java.platform.Specification;
import org.openide.awt.Mnemonics;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public final class FixProjectSourceLevel
extends JPanel {
    private final SpecificationVersion platformVersion;
    private final SpecificationVersion minVersion;
    private ButtonGroup buttonGroup1;
    private JRadioButton downgradeLevel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JButton managePlatforms;
    private JComboBox platforms;
    private JRadioButton useOtherPlatform;

    public FixProjectSourceLevel(@NonNull String type, @NonNull SpecificationVersion minVersion, @NonNull SpecificationVersion platformVersion) {
        Parameters.notNull((CharSequence)"type", (Object)type);
        Parameters.notNull((CharSequence)"minVersion", (Object)minVersion);
        this.platformVersion = platformVersion;
        this.minVersion = minVersion;
        this.initComponents();
        this.postInit(type, minVersion);
    }

    boolean isDowngradeLevel() {
        return this.downgradeLevel.isSelected();
    }

    final JavaPlatform getSelectedPlatform() {
        if (!this.useOtherPlatform.isSelected()) {
            throw new IllegalStateException();
        }
        return (JavaPlatform)this.platforms.getSelectedItem();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.downgradeLevel = new JRadioButton();
        this.useOtherPlatform = new JRadioButton();
        this.jLabel1 = new JLabel();
        this.platforms = new JComboBox();
        this.managePlatforms = new JButton();
        this.jLabel2 = new JLabel();
        this.buttonGroup1.add(this.downgradeLevel);
        Mnemonics.setLocalizedText((AbstractButton)this.downgradeLevel, (String)NbBundle.getMessage(FixProjectSourceLevel.class, (String)"FixProjectSourceLevel.downgradeLevel.text", (Object)this.platformVersion));
        this.buttonGroup1.add(this.useOtherPlatform);
        Mnemonics.setLocalizedText((AbstractButton)this.useOtherPlatform, (String)NbBundle.getMessage(FixProjectSourceLevel.class, (String)"FixProjectSourceLevel.useOtherPlatform.text"));
        this.jLabel1.setLabelFor(this.platforms);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(FixProjectSourceLevel.class, (String)"FixProjectSourceLevel.jLabel1.text"));
        this.platforms.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        Mnemonics.setLocalizedText((AbstractButton)this.managePlatforms, (String)NbBundle.getMessage(FixProjectSourceLevel.class, (String)"FixProjectSourceLevel.managePlatforms.text"));
        this.managePlatforms.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FixProjectSourceLevel.this.managePlatforms(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(FixProjectSourceLevel.class, (String)"FixProjectSourceLevel.jLabel2.text", (Object)this.minVersion));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(29, 29, 29).add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.platforms, 0, 148, Short.MAX_VALUE).add(18, 18, 18).add((Component)this.managePlatforms)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.downgradeLevel).add((Component)this.useOtherPlatform).add((Component)this.jLabel2)).add(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.useOtherPlatform).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.platforms, -2, -1, -2).add((Component)this.managePlatforms)).addPreferredGap(0).add((Component)this.downgradeLevel).addContainerGap(29, Short.MAX_VALUE)));
    }

    private void managePlatforms(ActionEvent evt) {
        PlatformsCustomizer.showCustomizer(null);
        ((PlatformModel)this.platforms.getModel()).refresh();
    }

    private void postInit(@NonNull String type, @NonNull SpecificationVersion minVersion) {
        this.useOtherPlatform.setSelected(true);
        this.platforms.setModel(new PlatformModel(type, minVersion));
        this.platforms.setRenderer(new PlatformRenderer());
    }

    private static class PlatformRenderer
    extends DefaultListCellRenderer {
        private PlatformRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof JavaPlatform) {
                value = ((JavaPlatform)value).getDisplayName();
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }

    private static final class PlatformModel
    extends DefaultComboBoxModel {
        private final String type;
        private final SpecificationVersion minVersion;

        PlatformModel(@NonNull String type, @NonNull SpecificationVersion minVersion) {
            this.type = type;
            this.minVersion = minVersion;
            this.refresh();
        }

        void refresh() {
            JavaPlatform[] platforms;
            this.removeAllElements();
            for (JavaPlatform jp : platforms = JavaPlatformManager.getDefault().getPlatforms(null, new Specification(this.type, null))) {
                if (this.minVersion.compareTo((Object)jp.getSpecification().getVersion()) > 0) continue;
                this.addElement(jp);
            }
        }
    }
}

