/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.logging.Logger;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.ApplyWorkspaceEditResponse;
import org.eclipse.lsp4j.WorkspaceEditCapabilities;
import org.netbeans.api.lsp.ResourceModificationException;
import org.netbeans.api.lsp.ResourceOperation;
import org.netbeans.api.lsp.TextDocumentEdit;
import org.netbeans.api.lsp.WorkspaceEdit;
import org.netbeans.modules.java.lsp.server.LspServerUtils;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.java.lsp.server.protocol.SaveDocumentRequestParams;
import org.netbeans.spi.lsp.ApplyEditsImplementation;
import org.openide.util.Lookup;
import org.openide.util.Union2;

public class AbstractApplyEditsImplementation
implements ApplyEditsImplementation {
    private static final Logger LOG = Logger.getLogger(AbstractApplyEditsImplementation.class.getName());

    public CompletableFuture<List<String>> applyChanges(List<WorkspaceEdit> edits, boolean saveResources) {
        NbCodeLanguageClient client = LspServerUtils.findLspClient(Lookup.getDefault());
        if (client == null) {
            return null;
        }
        Worker wk = new Worker(client, edits, saveResources);
        return wk.execute().thenApply(v -> wk.getProcessedResources());
    }

    static final class Worker {
        final NbCodeLanguageClient client;
        final boolean doSave;
        final List<WorkspaceEdit> edits;
        final List<WorkspaceEdit> completed = new ArrayList<WorkspaceEdit>();
        final Set<String> saved = new LinkedHashSet<String>();
        final Set<String> processed = new LinkedHashSet<String>();
        final boolean transactionalFailure;
        boolean failed;
        WorkspaceEdit currentEdit;

        public Worker(NbCodeLanguageClient client, List<WorkspaceEdit> edits, boolean doSave) {
            this.client = client;
            this.edits = edits;
            this.doSave = doSave;
            WorkspaceEditCapabilities caps = client.getNbCodeCapabilities().getClientCapabilities().getWorkspace().getWorkspaceEdit();
            if (caps != null) {
                String failures;
                switch (failures = caps.getFailureHandling()) {
                    case "transactional": 
                    case "undo": {
                        this.transactionalFailure = true;
                        break;
                    }
                    default: {
                        this.transactionalFailure = false;
                        break;
                    }
                }
            } else {
                this.transactionalFailure = false;
            }
        }

        public List<String> getProcessedResources() {
            return new ArrayList<String>(this.processed);
        }

        CompletableFuture<Void> handleClientResponse(WorkspaceEdit edit, ApplyWorkspaceEditResponse response) {
            int index = 0;
            int limit = response.getFailedChange() == null ? (response.isApplied() ? edit.getDocumentChanges().size() : 0) : response.getFailedChange();
            for (Union2 item : edit.getDocumentChanges()) {
                if (index >= limit) break;
                if (item.hasFirst()) {
                    this.processed.add(((TextDocumentEdit)item.first()).getDocument());
                    continue;
                }
                if (!(item.second() instanceof ResourceOperation.CreateFile)) continue;
                this.processed.add(((ResourceOperation.CreateFile)item.second()).getNewFile());
            }
            if (response.isApplied()) {
                return CompletableFuture.completedFuture(null);
            }
            this.failed = true;
            IOException ex = new IOException(response.getFailureReason());
            Integer failedChange = response.getFailedChange();
            if (failedChange == null || this.transactionalFailure) {
                CompletableFuture<Void> failed = new CompletableFuture<Void>();
                failed.completeExceptionally((Throwable)new ResourceModificationException(this.completed, this.currentEdit, -2, -2, this.saved, response.getFailureReason(), (Throwable)ex));
                return failed;
            }
            CompletableFuture<Void> failed = new CompletableFuture<Void>();
            failed.completeExceptionally((Throwable)new ResourceModificationException(this.completed, this.currentEdit, failedChange.intValue(), -2, this.saved, response.getFailureReason(), (Throwable)ex));
            return failed;
        }

        public CompletableFuture<Void> execute() {
            CompletionStage response = null;
            if (this.edits.isEmpty()) {
                return CompletableFuture.completedFuture(null);
            }
            Iterator<WorkspaceEdit> iterator = this.edits.iterator();
            while (iterator.hasNext()) {
                WorkspaceEdit e;
                this.currentEdit = e = iterator.next();
                CompletionStage next = response == null ? this.client.applyEdit(new ApplyWorkspaceEditParams(Utils.workspaceEditFromApi(e, null, this.client))) : response.thenCompose(v -> this.client.applyEdit(new ApplyWorkspaceEditParams(Utils.workspaceEditFromApi(e, null, this.client))));
                response = ((CompletableFuture)next).thenCompose(r -> this.handleClientResponse(e, (ApplyWorkspaceEditResponse)r));
            }
            if (this.doSave) {
                return ((CompletableFuture)response.thenCompose(v -> this.client.requestDocumentSave(new SaveDocumentRequestParams(new ArrayList<String>(this.processed))))).thenApply(success -> {
                    this.saved.addAll(this.processed);
                    return null;
                });
            }
            return response;
        }
    }
}

