/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.input;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.services.JsonSegment;
import org.netbeans.modules.java.lsp.server.input.InputBoxStep;
import org.netbeans.modules.java.lsp.server.input.InputCallbackParams;
import org.netbeans.modules.java.lsp.server.input.InputService;
import org.netbeans.modules.java.lsp.server.input.QuickPickStep;

@JsonSegment(value="input")
public class LspInputServiceImpl
implements InputService {
    private final RegistryImpl registry = new RegistryImpl();

    @Override
    public CompletableFuture<Either<QuickPickStep, InputBoxStep>> step(InputCallbackParams params) {
        InputService.Callback callback = this.registry.callbacks.get(params.getInputId());
        if (callback == null) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<Either<QuickPickStep, InputBoxStep>> future = new CompletableFuture<Either<QuickPickStep, InputBoxStep>>();
        callback.step(params).handle((step, ex) -> {
            if (ex != null) {
                this.registry.callbacks.remove(params.getInputId());
                future.completeExceptionally((Throwable)ex);
            } else {
                if (step == null) {
                    this.registry.callbacks.remove(params.getInputId());
                }
                future.complete((Either<QuickPickStep, InputBoxStep>)step);
            }
            return null;
        });
        return future;
    }

    @Override
    public CompletableFuture<String> validate(InputCallbackParams params) {
        InputService.Callback callback = this.registry.callbacks.get(params.getInputId());
        return callback != null ? callback.validate(params) : CompletableFuture.completedFuture(null);
    }

    public InputService.Registry getRegistry() {
        return this.registry;
    }

    private static class RegistryImpl
    implements InputService.Registry {
        private final Map<String, InputService.Callback> callbacks = new ConcurrentHashMap<String, InputService.Callback>();
        private final AtomicInteger cnt = new AtomicInteger();

        private RegistryImpl() {
        }

        @Override
        public String registerInput(InputService.Callback callback) {
            String id = "ID:" + this.cnt.incrementAndGet();
            this.callbacks.put(id, callback);
            return id;
        }
    }
}

