/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.modules.Places;
import org.openide.util.Exceptions;

public final class URITranslator {
    private static final URITranslator INSTANCE = new URITranslator();
    private final Map<String, String> uriFromCacheMap = new LRUCacheMap();

    public static URITranslator getDefault() {
        return INSTANCE;
    }

    public synchronized String uriToLSP(String lspUri) {
        return this.uriFromCacheMap.computeIfAbsent(lspUri, uri -> {
            FileObject file;
            URL url;
            URI uriUri = URI.create((String)uri);
            try {
                url = uriUri.toURL();
            }
            catch (MalformedURLException ex) {
                return uri;
            }
            if (FileUtil.isArchiveArtifact((URL)url)) {
                file = URLMapper.findFileObject((URL)url);
                if (file == null) {
                    return uri;
                }
                try {
                    return URLMapper.findURL((FileObject)file, (int)1).toURI().toString();
                }
                catch (URISyntaxException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if (uriUri.getScheme().equals("nbfs")) {
                file = URLMapper.findFileObject((URL)url);
                if (file == null) {
                    return uri;
                }
                try {
                    String txt = file.asText("UTF-8");
                    try (OutputStream os = file.getOutputStream();){
                        os.write(txt.getBytes(StandardCharsets.UTF_8));
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                try {
                    uri = URLMapper.findURL((FileObject)file, (int)1).toURI().toString();
                }
                catch (URISyntaxException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if ("file".equals(uriUri.getScheme()) && !((String)uri).startsWith("file:///") && (((String)uri).length() <= 7 || ((String)uri).charAt(7) != ':')) {
                uri = "file://" + ((String)uri).substring(5);
            }
            return uri;
        });
    }

    public String uriFromLSP(String nbUri) {
        int indexOfInnerScheme;
        int slash = nbUri.indexOf(47);
        if (slash != -1 && (indexOfInnerScheme = nbUri.substring(0, slash).indexOf("%3A")) > 0 && indexOfInnerScheme < slash) {
            int n = indexOfInnerScheme + 3;
            StringBuilder sb = new StringBuilder();
            sb.append(nbUri, 0, indexOfInnerScheme);
            sb.append(':');
            int mangledExclamation = nbUri.indexOf("%21/");
            if (mangledExclamation > 0) {
                sb.append(nbUri, n, mangledExclamation);
                sb.append('!');
                n = mangledExclamation + 3;
            }
            sb.append(nbUri, n, nbUri.length());
            return sb.toString();
        }
        return nbUri;
    }

    public static File getCacheDir() {
        return Places.getCacheSubfile((String)"java-server");
    }

    private static class LRUCacheMap
    extends LinkedHashMap<String, String> {
        private static final int MAX_SIZE = 2048;

        LRUCacheMap() {
            super(32, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
            return this.size() > 2048;
        }
    }
}

