/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.debugging;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Future;
import org.eclipse.lsp4j.debug.launch.DSPLauncher;
import org.eclipse.lsp4j.debug.services.IDebugProtocolClient;
import org.eclipse.lsp4j.debug.services.IDebugProtocolServer;
import org.eclipse.lsp4j.jsonrpc.JsonRpcException;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.MessageIssueException;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.netbeans.modules.java.lsp.server.LspSession;
import org.netbeans.modules.java.lsp.server.debugging.DebugAdapterContext;
import org.netbeans.modules.java.lsp.server.debugging.NbProtocolServer;
import org.netbeans.modules.java.lsp.server.progress.OperationContext;
import org.openide.util.Lookup;
import org.openide.util.Pair;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class Debugger {
    private Debugger() {
    }

    public static NbProtocolServer startDebugger(Pair<InputStream, OutputStream> io, LspSession session) {
        DebugAdapterContext context = new DebugAdapterContext(session);
        NbProtocolServer server = new NbProtocolServer(context);
        Launcher serverLauncher = DSPLauncher.createServerLauncher((IDebugProtocolServer)server, (InputStream)((InputStream)io.first()), (OutputStream)((OutputStream)io.second()), null, d -> new ConsumeWithLookup((MessageConsumer)d, session));
        context.setClient((IDebugProtocolClient)serverLauncher.getRemoteProxy());
        Future runningServer = serverLauncher.startListening();
        server.setRunningFuture(runningServer);
        return server;
    }

    private static class ConsumeWithLookup
    implements MessageConsumer {
        private final MessageConsumer delegate;
        private final LspSession lspSession;
        private OperationContext topContext;
        private Lookup debugSessionLookup;

        public ConsumeWithLookup(MessageConsumer delegate, LspSession session) {
            this.delegate = delegate;
            this.lspSession = session;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void consume(Message message) throws MessageIssueException, JsonRpcException {
            OperationContext ctx;
            InstanceContent ic = new InstanceContent();
            Lookup ll = this.debugSessionLookup;
            if (ll == null) {
                ll = new ProxyLookup(new Lookup[]{new AbstractLookup((AbstractLookup.Content)ic), this.lspSession.getLookup()});
                ConsumeWithLookup consumeWithLookup = this;
                synchronized (consumeWithLookup) {
                    if (this.debugSessionLookup == null) {
                        this.debugSessionLookup = ll;
                    }
                }
            }
            if (this.topContext == null) {
                this.topContext = OperationContext.find(this.lspSession.getLookup());
            }
            if (this.topContext != null) {
                ctx = this.topContext.operationContext();
                ctx.disableCancels();
                ic.add((Object)ctx);
            } else {
                ctx = null;
            }
            Lookups.executeWith((Lookup)ll, () -> {
                try {
                    this.delegate.consume(message);
                }
                finally {
                    if (ctx != null) {
                        ctx.stop();
                    }
                }
            });
        }
    }
}

