/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.sun.source.util.TreePath;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.ShowDocumentParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.gsf.testrunner.api.TestCreatorProvider;
import org.netbeans.modules.gsf.testrunner.plugin.CommonTestUtilProvider;
import org.netbeans.modules.gsf.testrunner.plugin.GuiUtilsProvider;
import org.netbeans.modules.java.lsp.server.URITranslator;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.input.InputBoxStep;
import org.netbeans.modules.java.lsp.server.input.InputService;
import org.netbeans.modules.java.lsp.server.input.QuickPickItem;
import org.netbeans.modules.java.lsp.server.input.QuickPickStep;
import org.netbeans.modules.java.lsp.server.input.ShowMutliStepInputParams;
import org.netbeans.modules.java.lsp.server.protocol.Bundle;
import org.netbeans.modules.java.lsp.server.protocol.CodeActionsProvider;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.BaseUtilities;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public final class TestClassGenerator
extends CodeActionsProvider {
    private static final String GENERATE_TEST_CLASS_COMMAND = "nbls.java.generate.testClass";
    private static final String FRAMEWORKS = "frameworks";
    private static final String CLASS_NAME = "className";
    private final Gson gson = new Gson();

    @Override
    public List<CodeAction> getCodeActions(NbCodeLanguageClient client, ResultIterator resultIterator, CodeActionParams params) throws Exception {
        CompilationController info;
        List only = params.getContext().getOnly();
        if (only == null || !only.contains("source")) {
            return Collections.emptyList();
        }
        CompilationController compilationController = info = resultIterator.getParserResult() != null ? CompilationController.get((Parser.Result)resultIterator.getParserResult()) : null;
        if (info == null) {
            return Collections.emptyList();
        }
        info.toPhase(JavaSource.Phase.RESOLVED);
        int offset = TestClassGenerator.getOffset((CompilationInfo)info, params.getRange().getStart());
        TreePath tp = info.getTreeUtilities().pathFor(offset);
        if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tp.getLeaf().getKind())) {
            return Collections.emptyList();
        }
        ClassPath cp = info.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE);
        FileObject fileObject = info.getFileObject();
        if (!fileObject.isValid()) {
            return Collections.emptyList();
        }
        FileObject root = cp.findOwnerRoot(fileObject);
        if (root == null) {
            return Collections.emptyList();
        }
        Map<Object, List<String>> validCombinations = TestClassGenerator.getValidCombinations((CompilationInfo)info);
        if (validCombinations == null || validCombinations.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CodeAction> result = new ArrayList<CodeAction>();
        for (Map.Entry<Object, List<String>> entrySet : validCombinations.entrySet()) {
            Object location = entrySet.getKey();
            List testingFrameworks = entrySet.getValue().stream().map(framework -> new QuickPickItem((String)framework)).collect(Collectors.toList());
            result.add(this.createCodeAction(client, Bundle.DN_GenerateTestClass(), "source", null, GENERATE_TEST_CLASS_COMMAND, Utils.toUri(fileObject), TestClassGenerator.getTargetFolderUri(location), testingFrameworks));
        }
        return result;
    }

    @Override
    public Set<String> getCommands() {
        return Collections.singleton(GENERATE_TEST_CLASS_COMMAND);
    }

    @Override
    public CompletableFuture<Object> processCommand(NbCodeLanguageClient client, String command, List<Object> arguments) {
        CompletableFuture<Object> future;
        block6: {
            future = new CompletableFuture<Object>();
            try {
                if (arguments.size() > 2) {
                    String uri = ((JsonPrimitive)arguments.get(0)).getAsString();
                    FileObject fileObject = Utils.fromUri(uri);
                    if (fileObject == null) {
                        throw new IllegalArgumentException(String.format("Cannot resolve source file from uri: %s", uri));
                    }
                    String targetUri = ((JsonPrimitive)arguments.get(1)).getAsString();
                    FileObject targetFolder = TestClassGenerator.getTargetFolder(targetUri);
                    if (targetFolder == null) {
                        throw new IllegalArgumentException(String.format("Cannot resolve target folder from uri: %s", targetUri));
                    }
                    List<QuickPickItem> testingFrameworks = Arrays.asList((QuickPickItem[])this.gson.fromJson((JsonElement)((JsonArray)arguments.get(2)), QuickPickItem[].class));
                    InputService.Registry inputServiceRegistry = (InputService.Registry)Lookup.getDefault().lookup(InputService.Registry.class);
                    if (inputServiceRegistry != null) {
                        int totalSteps = testingFrameworks.size() > 1 ? 2 : 1;
                        String inputId = inputServiceRegistry.registerInput(params -> {
                            CompletableFuture<Either> f = new CompletableFuture<Either>();
                            if (params.getStep() < totalSteps) {
                                Either<List<QuickPickItem>, String> frameworkData = params.getData().get(FRAMEWORKS);
                                if (frameworkData != null) {
                                    List selectedFrameworks = (List)frameworkData.getLeft();
                                    for (QuickPickItem testingFramework : testingFrameworks) {
                                        testingFramework.setPicked(selectedFrameworks.contains(testingFramework));
                                    }
                                }
                                f.complete(Either.forLeft((Object)new QuickPickStep(totalSteps, FRAMEWORKS, Bundle.DN_SelectFramework(), testingFrameworks)));
                            } else if (params.getStep() == totalSteps) {
                                Either<List<QuickPickItem>, String> frameworkData = params.getData().get(FRAMEWORKS);
                                QuickPickItem selectedFramework = (QuickPickItem)(frameworkData != null ? (List)frameworkData.getLeft() : testingFrameworks).get(0);
                                f.complete(Either.forRight((Object)new InputBoxStep(totalSteps, CLASS_NAME, Bundle.DN_ProvideClassName(), TestClassGenerator.getPreffiledName(fileObject, selectedFramework.getLabel()))));
                            } else {
                                f.complete(null);
                            }
                            return f;
                        });
                        client.showMultiStepInput(new ShowMutliStepInputParams(inputId, Bundle.DN_GenerateDelegateMethod())).thenAccept(result -> {
                            Either frameworkData = (Either)result.get(FRAMEWORKS);
                            QuickPickItem selectedFramework = (QuickPickItem)(frameworkData != null ? (List)frameworkData.getLeft() : testingFrameworks).get(0);
                            Either classNameData = (Either)result.get(CLASS_NAME);
                            String className = classNameData != null ? (String)classNameData.getRight() : null;
                            future.complete(selectedFramework != null && className != null ? Boolean.valueOf(this.generate(client, fileObject, targetFolder, className, selectedFramework.getLabel())) : null);
                        });
                    }
                    break block6;
                }
                throw new IllegalArgumentException(String.format("Illegal number of arguments received for command: %s", command));
            }
            catch (JsonSyntaxException | IllegalArgumentException | MalformedURLException ex) {
                future.completeExceptionally(ex);
            }
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean generate(final NbCodeLanguageClient client, FileObject fileObject, final FileObject targetFolder, String className, String testingFramework) {
        Collection providers = Lookup.getDefault().lookupResult(TestCreatorProvider.class).allItems();
        for (Lookup.Item provider : providers) {
            if (!provider.getDisplayName().equals(testingFramework)) continue;
            TestCreatorProvider.Context context = new TestCreatorProvider.Context(new FileObject[]{fileObject});
            context.setSingleClass(true);
            context.setTargetFolder(targetFolder);
            context.setTestClassName(className);
            final AtomicReference<1> fcl = new AtomicReference<1>();
            fcl.set(new FileChangeAdapter(){

                public void fileDataCreated(FileEvent fe) {
                    RequestProcessor.getDefault().post(() -> client.showDocument(new ShowDocumentParams(Utils.toUri(fe.getFile()))), 1000);
                    FileChangeListener l = fcl.getAndSet(null);
                    if (l != null) {
                        targetFolder.removeRecursiveListener(l);
                    }
                }
            });
            targetFolder.addRecursiveListener((FileChangeListener)fcl.get());
            try {
                ((TestCreatorProvider)provider.getInstance()).createTests(context);
            }
            finally {
                RequestProcessor.getDefault().post(() -> {
                    FileChangeListener l = fcl.getAndSet(null);
                    if (l != null) {
                        targetFolder.removeRecursiveListener(l);
                    }
                }, 10000);
            }
            return true;
        }
        return false;
    }

    private static Map<Object, List<String>> getValidCombinations(CompilationInfo info) {
        List<String> testingFrameworks = TestClassGenerator.getTestingFrameworks(info.getFileObject());
        if (testingFrameworks.isEmpty()) {
            return null;
        }
        HashMap<Object, List<String>> validCombinations = new HashMap<Object, List<String>>();
        for (Object location : TestClassGenerator.getLocations(info.getFileObject())) {
            String targetFolderPath = TestClassGenerator.getTargetFolderPath(location);
            ArrayList<String> framework2Add = new ArrayList<String>();
            for (String framework : testingFrameworks) {
                String preffiledName = TestClassGenerator.getPreffiledName(info.getFileObject(), framework);
                preffiledName = preffiledName.replace('.', File.separatorChar).concat(".java");
                String path = targetFolderPath.concat(File.separator).concat(preffiledName);
                File f = new File(path);
                FileObject fo = FileUtil.toFileObject((File)f);
                if (fo != null) continue;
                framework2Add.add(framework);
            }
            if (framework2Add.isEmpty()) continue;
            validCombinations.put(location, framework2Add);
        }
        return validCombinations;
    }

    private static List<String> getTestingFrameworks(FileObject fileObject) {
        ArrayList<String> testingFrameworks = new ArrayList<String>();
        Collection testCreatorProviders = Lookup.getDefault().lookupResult(TestCreatorProvider.class).allItems();
        for (Lookup.Item provider : testCreatorProviders) {
            if (!((TestCreatorProvider)provider.getInstance()).enable(new FileObject[]{fileObject})) continue;
            testingFrameworks.add(provider.getDisplayName());
        }
        return testingFrameworks;
    }

    private static Object[] getLocations(FileObject activeFO) {
        SourceGroup sourceGroupOwner;
        Object[] locations = null;
        Collection testUtilProviders = Lookup.getDefault().lookupAll(CommonTestUtilProvider.class);
        Iterator iterator = testUtilProviders.iterator();
        if (iterator.hasNext()) {
            CommonTestUtilProvider provider = (CommonTestUtilProvider)iterator.next();
            locations = provider.getTestTargets(activeFO);
        }
        if (locations != null && locations.length == 0 && (sourceGroupOwner = TestClassGenerator.findSourceGroupOwner(activeFO)) != null) {
            locations = UnitTestForSourceQuery.findUnitTests((FileObject)sourceGroupOwner.getRootFolder());
        }
        return locations != null ? locations : new Object[]{};
    }

    private static String getPreffiledName(FileObject fileObj, String selectedFramework) {
        ClassPath cp = ClassPath.getClassPath((FileObject)fileObj, (String)"classpath/source");
        String className = cp.getResourceName(fileObj, '.', false);
        return className + TestClassGenerator.getTestingFrameworkSuffix(selectedFramework) + "Test";
    }

    private static String getTestingFrameworkSuffix(String selectedFramework) {
        if (selectedFramework == null) {
            return "";
        }
        String testngFramework = "";
        Collection providers = Lookup.getDefault().lookupAll(GuiUtilsProvider.class);
        Iterator iterator = providers.iterator();
        if (iterator.hasNext()) {
            GuiUtilsProvider provider = (GuiUtilsProvider)iterator.next();
            testngFramework = provider.getTestngFramework();
        }
        return selectedFramework.equals(testngFramework) ? "NG" : "";
    }

    private static String getTargetFolderUri(Object selectedLocation) throws URISyntaxException {
        if (selectedLocation == null) {
            return null;
        }
        if (selectedLocation instanceof SourceGroup) {
            return Utils.toUri(((SourceGroup)selectedLocation).getRootFolder());
        }
        if (selectedLocation instanceof URL) {
            return URITranslator.getDefault().uriToLSP(((URL)selectedLocation).toURI().toString());
        }
        assert (selectedLocation instanceof FileObject);
        return Utils.toUri((FileObject)selectedLocation);
    }

    private static FileObject getTargetFolder(String uri) throws MalformedURLException {
        FileObject targetFolder = Utils.fromUri(uri);
        if (targetFolder == null) {
            File file = BaseUtilities.toFile((URI)URI.create(uri));
            if (file != null && !file.exists()) {
                file.mkdirs();
            }
            targetFolder = Utils.fromUri(uri);
        }
        return targetFolder != null && targetFolder.isFolder() ? targetFolder : null;
    }

    private static String getTargetFolderPath(Object selectedLocation) {
        if (selectedLocation == null) {
            return null;
        }
        if (selectedLocation instanceof SourceGroup) {
            return ((SourceGroup)selectedLocation).getRootFolder().getPath();
        }
        if (selectedLocation instanceof URL) {
            return ((URL)selectedLocation).getPath();
        }
        assert (selectedLocation instanceof FileObject);
        return ((FileObject)selectedLocation).getPath();
    }

    private static SourceGroup findSourceGroupOwner(FileObject file) {
        Project project = FileOwnerQuery.getOwner((FileObject)file);
        if (project != null) {
            SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
            for (int i = 0; i < sourceGroups.length; ++i) {
                SourceGroup srcGroup = sourceGroups[i];
                FileObject root = srcGroup.getRootFolder();
                if (file != root && !FileUtil.isParentOf((FileObject)root, (FileObject)file) || !srcGroup.contains(file)) continue;
                return srcGroup;
            }
        }
        return null;
    }
}

