/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.editor.codegen.GeneratorUtils;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.input.InputService;
import org.netbeans.modules.java.lsp.server.input.QuickPickItem;
import org.netbeans.modules.java.lsp.server.input.QuickPickStep;
import org.netbeans.modules.java.lsp.server.input.ShowMutliStepInputParams;
import org.netbeans.modules.java.lsp.server.protocol.Bundle;
import org.netbeans.modules.java.lsp.server.protocol.CodeActionsProvider;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.java.lsp.server.protocol.TextDocumentServiceImpl;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public final class ConstructorGenerator
extends CodeActionsProvider {
    private static final String URI = "uri";
    private static final String OFFSET = "offset";
    private static final String CONSTRUCTORS = "constructors";
    private static final String FIELDS = "fields";
    private final Gson gson = new Gson();

    /*
     * WARNING - void declaration
     */
    @Override
    public List<CodeAction> getCodeActions(ResultIterator resultIterator, CodeActionParams params) throws Exception {
        void var13_22;
        List<Object> constructors;
        CompilationController info = CompilationController.get((Parser.Result)resultIterator.getParserResult());
        if (info == null) {
            return Collections.emptyList();
        }
        info.toPhase(JavaSource.Phase.RESOLVED);
        List only = params.getContext().getOnly();
        boolean isSource = only != null && only.contains("source");
        int startOffset = ConstructorGenerator.getOffset((CompilationInfo)info, params.getRange().getStart());
        TreePath tp = info.getTreeUtilities().pathFor(startOffset);
        tp = info.getTreeUtilities().getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, tp);
        if (tp == null) {
            return Collections.emptyList();
        }
        TypeElement typeElement = (TypeElement)info.getTrees().getElement(tp);
        if (typeElement == null || !typeElement.getKind().isClass() || NestingKind.ANONYMOUS == typeElement.getNestingKind()) {
            return Collections.emptyList();
        }
        Set uninitializedFields = info.getTreeUtilities().getUninitializedFields(tp);
        if (!isSource) {
            HashSet<VariableElement> selectedFields = new HashSet<VariableElement>();
            int endOffset = ConstructorGenerator.getOffset((CompilationInfo)info, params.getRange().getEnd());
            for (Tree tree : ((ClassTree)tp.getLeaf()).getMembers()) {
                VariableElement var;
                if (tree.getKind() != Tree.Kind.VARIABLE) continue;
                int start = (int)info.getTrees().getSourcePositions().getStartPosition(tp.getCompilationUnit(), tree);
                int end = (int)info.getTrees().getSourcePositions().getEndPosition(tp.getCompilationUnit(), tree);
                if (startOffset > end || endOffset < start || !uninitializedFields.contains(var = (VariableElement)info.getTrees().getElement(new TreePath(tp, tree)))) continue;
                selectedFields.add(var);
            }
            if (selectedFields.isEmpty()) {
                return Collections.emptyList();
            }
        }
        ArrayList<ExecutableElement> inheritedConstructors = new ArrayList<ExecutableElement>();
        TypeMirror superClassType = typeElement.getSuperclass();
        if (superClassType.getKind() == TypeKind.DECLARED) {
            TypeElement superClass = (TypeElement)((DeclaredType)superClassType).asElement();
            Elements elements = info.getElements();
            for (ExecutableElement executableElement : ElementFilter.constructorsIn(superClass.getEnclosedElements())) {
                PackageElement currentPackage = elements.getPackageOf(typeElement);
                PackageElement ctorPackage = elements.getPackageOf(executableElement);
                Set<Modifier> ctorMods = executableElement.getModifiers();
                if (currentPackage != ctorPackage && !ctorMods.contains((Object)Modifier.PUBLIC) && !ctorMods.contains((Object)Modifier.PROTECTED) || ctorMods.contains((Object)Modifier.PRIVATE)) continue;
                inheritedConstructors.add(executableElement);
            }
        }
        if (typeElement.getKind() != ElementKind.ENUM && inheritedConstructors.size() == 1) {
            if (uninitializedFields.isEmpty() && ((ExecutableElement)inheritedConstructors.get(0)).getParameters().isEmpty() && ElementFilter.constructorsIn(typeElement.getEnclosedElements()).stream().filter(ctor -> ctor.getParameters().isEmpty() && !info.getElementUtilities().isSynthetic((Element)ctor)).count() > 0L) {
                constructors = Collections.emptyList();
            } else {
                QuickPickItem quickPickItem = new QuickPickItem(ConstructorGenerator.createLabel((CompilationInfo)info, (ExecutableElement)inheritedConstructors.get(0)));
                quickPickItem.setUserData(new CodeActionsProvider.ElementData((Element)inheritedConstructors.get(0)));
                constructors = Collections.singletonList(quickPickItem);
            }
        } else if (inheritedConstructors.size() > 1) {
            constructors = new ArrayList(inheritedConstructors.size());
            for (ExecutableElement constructorElement : inheritedConstructors) {
                QuickPickItem item = new QuickPickItem(ConstructorGenerator.createLabel((CompilationInfo)info, constructorElement));
                item.setUserData(new CodeActionsProvider.ElementData(constructorElement));
                constructors.add(item);
            }
        } else {
            constructors = Collections.emptyList();
        }
        if (uninitializedFields.isEmpty()) {
            List list = Collections.emptyList();
        } else {
            ArrayList<QuickPickItem> arrayList = new ArrayList<QuickPickItem>();
            for (VariableElement variableElement : uninitializedFields) {
                QuickPickItem item = new QuickPickItem(ConstructorGenerator.createLabel((CompilationInfo)info, variableElement));
                item.setUserData(new CodeActionsProvider.ElementData(variableElement));
                item.setPicked(variableElement.getModifiers().contains((Object)Modifier.FINAL));
                arrayList.add(item);
            }
        }
        if (constructors.isEmpty() && var13_22.isEmpty()) {
            return Collections.emptyList();
        }
        var13_22.sort((f1, f2) -> f1.getLabel().compareTo(f2.getLabel()));
        constructors.sort((c1, c2) -> c1.getLabel().compareTo(c2.getLabel()));
        String uri = Utils.toUri(info.getFileObject());
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(URI, uri);
        data.put(OFFSET, startOffset);
        data.put(CONSTRUCTORS, constructors);
        data.put(FIELDS, var13_22);
        return Collections.singletonList(this.createCodeAction(Bundle.DN_GenerateConstructor(), isSource ? "source.generate" : "quickfix", data, "workbench.action.focusActiveEditorGroup", new Object[0]));
    }

    @Override
    public CompletableFuture<CodeAction> resolve(NbCodeLanguageClient client, CodeAction codeAction, Object data) {
        CompletableFuture<CodeAction> future = new CompletableFuture<CodeAction>();
        try {
            String uri = ((JsonObject)data).getAsJsonPrimitive(URI).getAsString();
            int offset = ((JsonObject)data).getAsJsonPrimitive(OFFSET).getAsInt();
            List<QuickPickItem> constructors = Arrays.asList((QuickPickItem[])this.gson.fromJson(((JsonObject)data).get(CONSTRUCTORS), QuickPickItem[].class));
            List<QuickPickItem> fields = Arrays.asList((QuickPickItem[])this.gson.fromJson(((JsonObject)data).get(FIELDS), QuickPickItem[].class));
            if (constructors.size() < 2 && fields.isEmpty()) {
                WorkspaceEdit edit = this.generate(client, uri, offset, constructors, fields);
                if (edit != null) {
                    codeAction.setEdit(edit);
                }
                future.complete(codeAction);
            } else {
                InputService.Registry inputServiceRegistry = (InputService.Registry)Lookup.getDefault().lookup(InputService.Registry.class);
                if (inputServiceRegistry != null) {
                    int totalSteps = constructors.size() > 1 ? 2 : 1;
                    String inputId = inputServiceRegistry.registerInput(params -> {
                        if (params.getStep() < totalSteps) {
                            Either<List<QuickPickItem>, String> constructorData = params.getData().get(CONSTRUCTORS);
                            if (constructorData != null) {
                                List selectedConstructors = (List)constructorData.getLeft();
                                for (QuickPickItem constructor : constructors) {
                                    constructor.setPicked(selectedConstructors.contains(constructor));
                                }
                            }
                            return CompletableFuture.completedFuture(Either.forLeft((Object)new QuickPickStep(totalSteps, CONSTRUCTORS, null, Bundle.DN_SelectSuperConstructor(), true, constructors)));
                        }
                        if (params.getStep() == totalSteps) {
                            Either<List<QuickPickItem>, String> fieldData = params.getData().get(FIELDS);
                            if (fieldData != null) {
                                List selectedFields = (List)fieldData.getLeft();
                                for (QuickPickItem field : fields) {
                                    field.setPicked(selectedFields.contains(field));
                                }
                            }
                            return CompletableFuture.completedFuture(Either.forLeft((Object)new QuickPickStep(totalSteps, FIELDS, null, Bundle.DN_SelectConstructorFields(), true, fields)));
                        }
                        return CompletableFuture.completedFuture(null);
                    });
                    client.showMultiStepInput(new ShowMutliStepInputParams(inputId, Bundle.DN_GenerateConstructor())).thenAccept(result -> {
                        Either selectedConstructors = (Either)result.get(CONSTRUCTORS);
                        Either selectedFields = (Either)result.get(FIELDS);
                        if (selectedFields != null) {
                            try {
                                WorkspaceEdit edit = this.generate(client, uri, offset, selectedConstructors != null ? (List)selectedConstructors.getLeft() : constructors, (List)selectedFields.getLeft());
                                if (edit != null) {
                                    codeAction.setEdit(edit);
                                }
                                future.complete(codeAction);
                            }
                            catch (IOException | IllegalArgumentException ex) {
                                future.completeExceptionally(ex);
                            }
                        } else {
                            future.complete(codeAction);
                        }
                    });
                }
            }
        }
        catch (JsonSyntaxException | IOException | IllegalArgumentException ex) {
            future.completeExceptionally(ex);
        }
        return future;
    }

    private WorkspaceEdit generate(NbCodeLanguageClient client, String uri, int offset, List<QuickPickItem> constructors, List<QuickPickItem> fields) throws IOException, IllegalArgumentException {
        try {
            FileObject file = Utils.fromUri(uri);
            JavaSource js = JavaSource.forFileObject((FileObject)file);
            if (js == null) {
                throw new IOException("Cannot get JavaSource for: " + uri);
            }
            List<TextEdit> edits = TextDocumentServiceImpl.modify2TextEdits(js, (Task<WorkingCopy>)((Task)wc -> {
                wc.toPhase(JavaSource.Phase.RESOLVED);
                TreePath tp = wc.getTreeUtilities().pathFor(offset);
                tp = wc.getTreeUtilities().getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, tp);
                if (tp != null) {
                    List selectedConstructors = constructors.stream().map(item -> {
                        CodeActionsProvider.ElementData data = (CodeActionsProvider.ElementData)this.gson.fromJson(this.gson.toJson(item.getUserData()), CodeActionsProvider.ElementData.class);
                        return (ExecutableElement)data.resolve((CompilationInfo)wc);
                    }).collect(Collectors.toList());
                    List selectedFields = fields.stream().map(item -> {
                        CodeActionsProvider.ElementData data = (CodeActionsProvider.ElementData)this.gson.fromJson(this.gson.toJson(item.getUserData()), CodeActionsProvider.ElementData.class);
                        return (VariableElement)data.resolve((CompilationInfo)wc);
                    }).collect(Collectors.toList());
                    GeneratorUtils.generateConstructors((WorkingCopy)wc, (TreePath)tp, selectedFields, selectedConstructors, (int)-1);
                }
            }));
            return edits.isEmpty() ? null : new WorkspaceEdit(Collections.singletonMap(uri, edits));
        }
        catch (GeneratorUtils.DuplicateMemberException dme) {
            client.showMessage(new MessageParams(MessageType.Info, Bundle.DN_ConstructorAlreadyExists()));
            return null;
        }
    }
}

