/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.explorer;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.swing.Action;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.netbeans.modules.java.lsp.server.explorer.TreeNodeRegistry;
import org.netbeans.modules.java.lsp.server.explorer.TreeViewProvider;
import org.netbeans.modules.java.lsp.server.protocol.CodeActionsProvider;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.java.lsp.server.ui.AbstractGlobalActionContext;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.openide.awt.Actions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class NodeActionsProvider
extends CodeActionsProvider {
    private static final String ATTRIBUTE_ACTION_PREFIX = "action:";
    private static final String NBLS_ACTION_PREFIX = "nbls:";
    private static final String CATEGORY_SEPARATOR = ":";
    private final Set<String> commands;
    private final Gson gson = new Gson();

    NodeActionsProvider(Set<String> commands) {
        this.commands = commands;
    }

    @Override
    public Set<String> getCommands() {
        return this.commands;
    }

    public static NodeActionsProvider forFile(FileObject f) {
        HashSet<String> commandNames = new HashSet<String>();
        Enumeration att = f.getAttributes();
        while (att.hasMoreElements()) {
            String a = (String)att.nextElement();
            if (!a.startsWith(ATTRIBUTE_ACTION_PREFIX)) continue;
            String id = a.substring(ATTRIBUTE_ACTION_PREFIX.length());
            String category = f.getAttribute(a).toString();
            String cmd = NBLS_ACTION_PREFIX + category + CATEGORY_SEPARATOR + id;
            commandNames.add(cmd);
        }
        return new NodeActionsProvider(commandNames);
    }

    @Override
    public List<CodeAction> getCodeActions(ResultIterator resultIterator, CodeActionParams params) throws Exception {
        return Collections.emptyList();
    }

    @Override
    public CompletableFuture<Object> processCommand(NbCodeLanguageClient client, String command, List<Object> arguments) {
        String category;
        String aid;
        String categoryAndId;
        int col;
        JsonElement nodeId;
        if (!command.startsWith(NBLS_ACTION_PREFIX)) {
            return CompletableFuture.completedFuture(false);
        }
        JsonElement el = null;
        if (arguments.size() > 0) {
            JsonObject item = (JsonObject)this.gson.fromJson(this.gson.toJson(arguments.get(0)), JsonObject.class);
            el = item.get("data");
        }
        int id = -1;
        if (el != null && (nodeId = el.getAsJsonObject().get("id")) != null && nodeId.isJsonPrimitive()) {
            id = nodeId.getAsJsonPrimitive().getAsInt();
        }
        if ((col = (categoryAndId = command.substring(NBLS_ACTION_PREFIX.length())).indexOf(CATEGORY_SEPARATOR)) != -1) {
            aid = categoryAndId.substring(col + 1);
            category = categoryAndId.substring(0, col);
        } else {
            category = null;
            aid = categoryAndId;
        }
        if (id == -1) {
            return this.invokeAction(client, category, aid, arguments);
        }
        TreeNodeRegistry srv = (TreeNodeRegistry)Lookup.getDefault().lookup(TreeNodeRegistry.class);
        Node target = srv.findNode(id);
        if (target == null) {
            return CompletableFuture.completedFuture(false);
        }
        TreeViewProvider provider = srv.providerOf(id);
        try {
            provider.getExplorerManager().setSelectedNodes(new Node[]{target});
        }
        catch (PropertyVetoException ex) {
            CompletableFuture<Object> f = new CompletableFuture<Object>();
            f.completeExceptionally(ex);
            return f;
        }
        ProxyLookup targetLookup = new ProxyLookup(new Lookup[]{target.getLookup(), provider.getLookup()});
        AbstractGlobalActionContext.withActionContext(provider.getLookup(), () -> NodeActionsProvider.lambda$processCommand$0(category, aid, (Lookup)targetLookup, target));
        return CompletableFuture.completedFuture(true);
    }

    CompletableFuture<Object> invokeAction(NbCodeLanguageClient client, String category, String aid, List<Object> arguments) {
        String path = "Actions/" + category + "/" + aid.replace('.', '-') + ".instance";
        FileObject config = FileUtil.getConfigFile((String)path);
        String contextType = (String)config.getAttribute("type");
        try {
            if (contextType == null) {
                Action a = Actions.forID((String)category, (String)aid);
                a.actionPerformed(new ActionEvent(client, 0, aid));
                return CompletableFuture.completedFuture(false);
            }
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(contextType);
            Object context = this.gson.fromJson(this.gson.toJson(arguments.get(0)), clazz);
            if (context == null) {
                return CompletableFuture.completedFuture(false);
            }
            Lookup targetLookup = Lookups.singleton((Object)context);
            AbstractGlobalActionContext.withActionContext(targetLookup, () -> {
                Action a = Actions.forID((String)category, (String)aid);
                if (a == null) {
                    return CompletableFuture.completedFuture(false);
                }
                if (a instanceof ContextAwareAction) {
                    a = ((ContextAwareAction)a).createContextAwareInstance(targetLookup);
                }
                Action a2 = a;
                a2.actionPerformed(new ActionEvent(client, 0, aid));
                return null;
            });
        }
        catch (ClassNotFoundException ex) {
            return this.completeExceptionally(ex);
        }
        return CompletableFuture.completedFuture(true);
    }

    private CompletableFuture completeExceptionally(Throwable t) {
        CompletableFuture f = new CompletableFuture();
        f.completeExceptionally(t);
        return f;
    }

    private static /* synthetic */ CompletableFuture lambda$processCommand$0(String category, String aid, Lookup targetLookup, Node target) throws Exception {
        Action a = Actions.forID((String)category, (String)aid);
        if (a == null) {
            return CompletableFuture.completedFuture(false);
        }
        if (a instanceof ContextAwareAction) {
            a = ((ContextAwareAction)a).createContextAwareInstance(targetLookup);
        }
        Action a2 = a;
        a2.actionPerformed(new ActionEvent(target, 0, aid));
        return null;
    }
}

