/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.sun.source.tree.Scope;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.protocol.Bundle;
import org.netbeans.modules.java.lsp.server.protocol.CodeActionsProvider;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.java.lsp.server.protocol.QuickPickItem;
import org.netbeans.modules.java.lsp.server.protocol.ShowQuickPickParams;
import org.netbeans.modules.java.lsp.server.protocol.TextDocumentServiceImpl;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.filesystems.FileObject;

public final class DelegateMethodGenerator
extends CodeActionsProvider {
    private static final String URI = "uri";
    private static final String OFFSET = "offset";
    private static final String TYPE = "type";
    private static final String FIELDS = "fields";
    private final Gson gson = new Gson();

    @Override
    public List<CodeAction> getCodeActions(ResultIterator resultIterator, CodeActionParams params) throws Exception {
        TypeElement cls;
        List only = params.getContext().getOnly();
        if (only == null || !only.contains("source")) {
            return Collections.emptyList();
        }
        CompilationController info = CompilationController.get((Parser.Result)resultIterator.getParserResult());
        if (info == null) {
            return Collections.emptyList();
        }
        info.toPhase(JavaSource.Phase.RESOLVED);
        int offset = DelegateMethodGenerator.getOffset((CompilationInfo)info, params.getRange().getStart());
        TreePath tp = info.getTreeUtilities().pathFor(offset);
        tp = info.getTreeUtilities().getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, tp);
        if (tp == null) {
            return Collections.emptyList();
        }
        TypeElement typeElement = (TypeElement)info.getTrees().getElement(tp);
        if (typeElement == null || !typeElement.getKind().isClass()) {
            return Collections.emptyList();
        }
        Elements elements = info.getElements();
        Trees trees = info.getTrees();
        ArrayList<QuickPickItem> fields = new ArrayList<QuickPickItem>();
        for (Scope scope = trees.getScope(tp); scope != null && (cls = scope.getEnclosingClass()) != null; scope = scope.getEnclosingScope()) {
            DeclaredType type = (DeclaredType)cls.asType();
            for (VariableElement field : ElementFilter.fieldsIn(elements.getAllMembers(cls))) {
                TypeMirror fieldType = field.asType();
                if ("<error>".contentEquals(field.getSimpleName()) || fieldType.getKind().isPrimitive() || fieldType.getKind() == TypeKind.ARRAY || fieldType.getKind() == TypeKind.DECLARED && ((DeclaredType)fieldType).asElement() == cls || !trees.isAccessible(scope, field, type)) continue;
                QuickPickItem item = new QuickPickItem(DelegateMethodGenerator.createLabel((CompilationInfo)info, field));
                item.setUserData(new CodeActionsProvider.ElementData(field));
                fields.add(item);
            }
        }
        if (fields.isEmpty()) {
            return Collections.emptyList();
        }
        String uri = Utils.toUri(info.getFileObject());
        QuickPickItem typeItem = new QuickPickItem(DelegateMethodGenerator.createLabel((CompilationInfo)info, typeElement));
        typeItem.setUserData(new CodeActionsProvider.ElementData(typeElement));
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(URI, uri);
        data.put(OFFSET, offset);
        data.put(TYPE, typeItem);
        data.put(FIELDS, fields);
        return Collections.singletonList(this.createCodeAction(Bundle.DN_GenerateDelegateMethod(), "source.generate", data, null, new Object[0]));
    }

    @Override
    public CompletableFuture<CodeAction> resolve(NbCodeLanguageClient client, CodeAction codeAction, Object data) {
        CompletableFuture<CodeAction> future = new CompletableFuture<CodeAction>();
        try {
            String uri = ((JsonObject)data).getAsJsonPrimitive(URI).getAsString();
            int offset = ((JsonObject)data).getAsJsonPrimitive(OFFSET).getAsInt();
            QuickPickItem type = (QuickPickItem)this.gson.fromJson(this.gson.toJson(((JsonObject)data).get(TYPE)), QuickPickItem.class);
            List<QuickPickItem> fields = Arrays.asList((QuickPickItem[])this.gson.fromJson(((JsonObject)data).get(FIELDS), QuickPickItem[].class));
            if (fields.size() == 1) {
                this.selectMethods(client, uri, offset, type, fields.get(0)).handle((edit, ex) -> {
                    if (ex != null) {
                        future.completeExceptionally((Throwable)ex);
                    } else {
                        if (edit != null) {
                            codeAction.setEdit(edit);
                        }
                        future.complete(codeAction);
                    }
                    return null;
                });
            } else {
                client.showQuickPick(new ShowQuickPickParams(Bundle.DN_SelectDelegateMethodField(), false, fields)).thenAccept(selected -> {
                    try {
                        if (selected != null && !selected.isEmpty()) {
                            this.selectMethods(client, uri, offset, type, (QuickPickItem)selected.get(0)).handle((edit, ex) -> {
                                if (ex != null) {
                                    future.completeExceptionally((Throwable)ex);
                                } else {
                                    if (edit != null) {
                                        codeAction.setEdit(edit);
                                    }
                                    future.complete(codeAction);
                                }
                                return null;
                            });
                        } else {
                            future.complete(codeAction);
                        }
                    }
                    catch (IOException | IllegalArgumentException ex2) {
                        future.completeExceptionally(ex2);
                    }
                });
            }
        }
        catch (JsonSyntaxException | IOException | IllegalArgumentException ex2) {
            future.completeExceptionally(ex2);
        }
        return future;
    }

    private CompletableFuture<WorkspaceEdit> selectMethods(NbCodeLanguageClient client, String uri, int offset, QuickPickItem type, QuickPickItem selectedField) throws IOException, IllegalArgumentException {
        CompletableFuture<WorkspaceEdit> future = new CompletableFuture<WorkspaceEdit>();
        FileObject file = Utils.fromUri(uri);
        JavaSource js = JavaSource.forFileObject((FileObject)file);
        if (js == null) {
            throw new IOException("Cannot get JavaSource for: " + uri);
        }
        js.runUserActionTask(info -> {
            info.toPhase(JavaSource.Phase.RESOLVED);
            final TypeElement origin = (TypeElement)((CodeActionsProvider.ElementData)this.gson.fromJson(this.gson.toJson(type.getUserData()), CodeActionsProvider.ElementData.class)).resolve((CompilationInfo)info);
            VariableElement field = (VariableElement)((CodeActionsProvider.ElementData)this.gson.fromJson(this.gson.toJson(selectedField.getUserData()), CodeActionsProvider.ElementData.class)).resolve((CompilationInfo)info);
            if (origin != null && field != null) {
                final ElementUtilities eu = info.getElementUtilities();
                final Trees trees = info.getTrees();
                final Scope scope = info.getTreeUtilities().scopeFor(offset);
                ElementUtilities.ElementAcceptor acceptor = new ElementUtilities.ElementAcceptor(){

                    public boolean accept(Element e, TypeMirror type) {
                        if (e.getKind() == ElementKind.METHOD && trees.isAccessible(scope, e, (DeclaredType)type)) {
                            Element impl = eu.getImplementationOf((ExecutableElement)e, origin);
                            return impl == null || !impl.getModifiers().contains((Object)Modifier.FINAL) && impl.getEnclosingElement() != origin;
                        }
                        return false;
                    }
                };
                ArrayList<QuickPickItem> methods = new ArrayList<QuickPickItem>();
                for (ExecutableElement method : ElementFilter.methodsIn(eu.getMembers(field.asType(), acceptor))) {
                    QuickPickItem item = new QuickPickItem(String.format("%s.%s", field.getSimpleName().toString(), DelegateMethodGenerator.createLabel((CompilationInfo)info, method)));
                    item.setUserData(new CodeActionsProvider.ElementData(method));
                    methods.add(item);
                }
                client.showQuickPick(new ShowQuickPickParams(Bundle.DN_SelectDelegateMethods(), true, methods)).thenAccept(selected -> {
                    try {
                        if (selected != null && !selected.isEmpty()) {
                            future.complete(this.generate(uri, offset, selectedField, (List<QuickPickItem>)selected));
                        } else {
                            future.complete(null);
                        }
                    }
                    catch (IOException | IllegalArgumentException ex) {
                        future.completeExceptionally(ex);
                    }
                });
            } else {
                future.complete(null);
            }
        }, true);
        return future;
    }

    private WorkspaceEdit generate(String uri, int offset, QuickPickItem selectedField, List<QuickPickItem> selectedMethods) throws IOException, IllegalArgumentException {
        FileObject file = Utils.fromUri(uri);
        JavaSource js = JavaSource.forFileObject((FileObject)file);
        if (js == null) {
            throw new IOException("Cannot get JavaSource for: " + uri);
        }
        List<TextEdit> edits = TextDocumentServiceImpl.modify2TextEdits(js, (Task<WorkingCopy>)((Task)wc -> {
            wc.toPhase(JavaSource.Phase.RESOLVED);
            TreePath tp = wc.getTreeUtilities().pathFor(offset);
            tp = wc.getTreeUtilities().getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, tp);
            if (tp != null) {
                VariableElement field = (VariableElement)((CodeActionsProvider.ElementData)this.gson.fromJson(this.gson.toJson(selectedField.getUserData()), CodeActionsProvider.ElementData.class)).resolve((CompilationInfo)wc);
                List methods = selectedMethods.stream().map(item -> {
                    CodeActionsProvider.ElementData data = (CodeActionsProvider.ElementData)this.gson.fromJson(this.gson.toJson(item.getUserData()), CodeActionsProvider.ElementData.class);
                    return (ExecutableElement)data.resolve((CompilationInfo)wc);
                }).collect(Collectors.toList());
                org.netbeans.modules.java.editor.codegen.DelegateMethodGenerator.generateDelegatingMethods((WorkingCopy)wc, (TreePath)tp, (VariableElement)field, methods, (int)-1);
            }
        }));
        return edits.isEmpty() ? null : new WorkspaceEdit(Collections.singletonMap(uri, edits));
    }
}

