/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.explorer;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.beans.PropertyVetoException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ActionMap;
import org.netbeans.modules.java.lsp.server.explorer.TreeNodeRegistry;
import org.netbeans.modules.java.lsp.server.explorer.TreeViewProvider;
import org.netbeans.modules.java.lsp.server.explorer.api.ExplorerManagerFactory;
import org.netbeans.modules.java.lsp.server.explorer.api.NodeChangedParams;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class TreeNodeRegistryImpl
implements TreeNodeRegistry {
    private static final Logger LOG = Logger.getLogger(TreeNodeRegistryImpl.class.getName());
    private static final String NODE_ATTR_LSP_ID = "lspId";
    private final Lookup sessionLookup;
    private final Map<String, TreeViewProvider> providers = new HashMap<String, TreeViewProvider>();
    private final Map<Integer, TreeViewProvider> node2Provider = new HashMap<Integer, TreeViewProvider>();
    private final Map<Image, TreeNodeRegistry.ImageDataOrIndex> images = new WeakHashMap<Image, TreeNodeRegistry.ImageDataOrIndex>();
    private int nodeCounter = 1;
    private int imageCounter = 1;
    private NbCodeLanguageClient langClient;

    public TreeNodeRegistryImpl(Lookup sessionLookup) {
        this.sessionLookup = sessionLookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterNode(int nodeId, Node n) {
        LOG.log(Level.FINEST, "Discarding node #{0}", nodeId);
        TreeNodeRegistryImpl treeNodeRegistryImpl = this;
        synchronized (treeNodeRegistryImpl) {
            this.node2Provider.remove(nodeId);
        }
    }

    @Override
    public synchronized int registerNode(Node n, TreeViewProvider tvp) {
        int id = ++this.nodeCounter;
        LOG.log(Level.FINEST, "Registered node #{0}, {1}", new Object[]{id, n});
        this.node2Provider.put(id, tvp);
        return id;
    }

    @Override
    public Node findNode(int id) {
        return this.providerOf(id).findNode(id);
    }

    @Override
    public synchronized TreeViewProvider providerOf(int id) {
        TreeViewProvider p = this.node2Provider.get(id);
        return p != null ? p : TreeViewProvider.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<TreeViewProvider> createProvider(String id) {
        LOG.log(Level.FINER, "Asked for {0}", id);
        TreeNodeRegistryImpl treeNodeRegistryImpl = this;
        synchronized (treeNodeRegistryImpl) {
            TreeViewProvider p = this.providers.get(id);
            if (p != null) {
                return CompletableFuture.completedFuture(p);
            }
        }
        ProxyLookup ctxLookup = new ProxyLookup(new Lookup[]{Lookups.forPath((String)("Explorers/" + id)), Lookups.forPath((String)"Explorers/_all")});
        FileObject conf = FileUtil.getConfigFile((String)("Explorers/" + id));
        boolean confirmDelete = conf != null && conf.getAttribute("explorerConfirmsDelete") == Boolean.TRUE;
        for (ExplorerManagerFactory f : ctxLookup.lookupAll(ExplorerManagerFactory.class)) {
            CompletionStage<ExplorerManager> em = f.createManager(id, (Lookup)ctxLookup);
            if (em == null) continue;
            LOG.log(Level.FINER, "Creating provider from factory {0}", f);
            return em.thenApply(arg_0 -> this.lambda$createProvider$0(id, (Lookup)ctxLookup, confirmDelete, arg_0));
        }
        CompletableFuture<TreeViewProvider> f = new CompletableFuture<TreeViewProvider>();
        f.completeExceptionally(new IllegalArgumentException("View " + id + " is not supported."));
        return f;
    }

    protected void notifyItemChanged(NodeChangedParams itemId) {
    }

    private synchronized TreeViewProvider registerManager(final ExplorerManager em, String id, Lookup ctxLookup, boolean confirmDelete) {
        TreeViewProvider p = this.providers.get(id);
        if (p != null) {
            return p;
        }
        em.addVetoableChangeListener(e -> {
            if ("rootContext".equals(e.getPropertyName())) {
                throw new PropertyVetoException("Root change not allowed", e);
            }
        });
        ActionMap map = new ActionMap();
        map.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)em));
        map.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)em));
        map.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)em));
        map.put("delete", ExplorerUtils.actionDelete((ExplorerManager)em, (boolean)confirmDelete));
        Lookup expLookup = ExplorerUtils.createLookup((ExplorerManager)em, (ActionMap)map);
        TreeViewProvider tvp = new TreeViewProvider(id, em, this, (Lookup)new ProxyLookup(new Lookup[]{expLookup, ctxLookup})){

            @Override
            protected void onDidChangeTreeData(Node n, int id) {
                int rootId = this.findId(em.getRootContext());
                if (n == null) {
                    TreeNodeRegistryImpl.this.notifyItemChanged(new NodeChangedParams(rootId));
                } else {
                    TreeNodeRegistryImpl.this.notifyItemChanged(new NodeChangedParams(rootId, id));
                }
            }
        };
        this.providers.put(id, tvp);
        return tvp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TreeNodeRegistry.ImageDataOrIndex imageOrIndex(Image i) {
        TreeNodeRegistry.ImageDataOrIndex res;
        TreeNodeRegistryImpl treeNodeRegistryImpl = this;
        synchronized (treeNodeRegistryImpl) {
            res = this.images.get(i);
            if (res != null) {
                return res.imageIndex == -1 ? null : new TreeNodeRegistry.ImageDataOrIndex(res.imageIndex);
            }
        }
        URI imageURI = null;
        try {
            BufferedImage bi;
            if (i instanceof BufferedImage) {
                bi = (BufferedImage)i;
            } else {
                class IO
                implements ImageObserver {
                    int bits;
                    CountDownLatch cdl = new CountDownLatch(1);
                    int height = -1;
                    int width = -1;

                    IO() {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                        this.bits |= 3 & infoflags;
                        IO iO = this;
                        synchronized (iO) {
                            if ((infoflags & 1) > 0) {
                                this.height = height;
                            }
                            if ((infoflags & 2) > 0) {
                                this.width = width;
                            }
                        }
                        if ((infoflags & 0xC0) > 0) {
                            this.cdl.countDown();
                            return false;
                        }
                        if ((infoflags & 0x20) > 0) {
                            this.cdl.countDown();
                            return false;
                        }
                        return true;
                    }
                }
                IO observer = new IO();
                int h = i.getHeight(observer);
                int w = i.getWidth(observer);
                if (h == -1 || w == -1) {
                    try {
                        observer.cdl.await();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    IO iO = observer;
                    synchronized (iO) {
                        h = observer.height;
                        w = observer.width;
                        if (h == -1 || w == -1) {
                            LOG.log(Level.WARNING, "Could not realize image to get its size: {0}", i);
                            return null;
                        }
                    }
                }
                bi = new BufferedImage(w, h, 2);
                Graphics2D bGr = bi.createGraphics();
                bGr.drawImage(i, 0, 0, null);
                bGr.dispose();
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bi, "png", baos);
            baos.flush();
            String base64Content = Base64.getEncoder().encodeToString(baos.toByteArray()).replace("\\n", "");
            imageURI = new URI("data:image/png;base64," + base64Content);
        }
        catch (IOException | URISyntaxException ex) {
            res = new TreeNodeRegistry.ImageDataOrIndex(null, -1);
        }
        TreeNodeRegistryImpl treeNodeRegistryImpl2 = this;
        synchronized (treeNodeRegistryImpl2) {
            if (res == null) {
                res = new TreeNodeRegistry.ImageDataOrIndex(imageURI, this.imageCounter++).baseURL(TreeNodeRegistryImpl.findImageURI(i));
            }
            this.images.put(i, res);
        }
        return res;
    }

    public static URI findImageURI(Image i) {
        URL u = ImageUtilities.findImageBaseURL((Image)i);
        if (u == null) {
            return null;
        }
        String s = u.toString();
        try {
            if (s.contains(":")) {
                return new URI(s);
            }
            return new URI("nbres:/" + s);
        }
        catch (URISyntaxException ex) {
            LOG.log(Level.WARNING, "Unable to interpret image ID: {0}", s);
            return null;
        }
    }

    private /* synthetic */ TreeViewProvider lambda$createProvider$0(String id, Lookup ctxLookup, boolean confirmDelete, ExplorerManager em2) {
        return this.registerManager(em2, id, ctxLookup, confirmDelete);
    }
}

