/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import com.google.gson.Gson;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.editor.codegen.GeneratorUtils;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.protocol.Bundle;
import org.netbeans.modules.java.lsp.server.protocol.CodeActionsProvider;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.java.lsp.server.protocol.QuickPickItem;
import org.netbeans.modules.java.lsp.server.protocol.ShowQuickPickParams;
import org.netbeans.modules.java.lsp.server.protocol.TextDocumentServiceImpl;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.filesystems.FileObject;

public final class ImplementOverrideMethodGenerator
extends CodeActionsProvider {
    public static final String GENERATE_IMPLEMENT_METHOD = "java.generate.implementMethod";
    public static final String GENERATE_OVERRIDE_METHOD = "java.generate.overrideMethod";
    private final Set<String> commands = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("java.generate.implementMethod", "java.generate.overrideMethod")));
    private final Gson gson = new Gson();

    @Override
    public List<CodeAction> getCodeActions(ResultIterator resultIterator, CodeActionParams params) throws Exception {
        List only = params.getContext().getOnly();
        if (only == null || !only.contains("source")) {
            return Collections.emptyList();
        }
        CompilationController info = CompilationController.get((Parser.Result)resultIterator.getParserResult());
        if (info == null) {
            return Collections.emptyList();
        }
        info.toPhase(JavaSource.Phase.RESOLVED);
        int offset = ImplementOverrideMethodGenerator.getOffset((CompilationInfo)info, params.getRange().getStart());
        TreePath tp = info.getTreeUtilities().pathFor(offset);
        tp = info.getTreeUtilities().getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, tp);
        if (tp == null) {
            return Collections.emptyList();
        }
        TypeElement typeElement = (TypeElement)info.getTrees().getElement(tp);
        if (typeElement == null || typeElement.getKind() == ElementKind.ANNOTATION_TYPE) {
            return Collections.emptyList();
        }
        ArrayList<CodeAction> result = new ArrayList<CodeAction>();
        String uri = Utils.toUri(info.getFileObject());
        ElementUtilities eu = info.getElementUtilities();
        if (typeElement.getKind().isClass() || typeElement.getKind().isInterface() && SourceVersion.RELEASE_8.compareTo(info.getSourceVersion()) <= 0) {
            ArrayList<QuickPickItem> implementMethods = new ArrayList<QuickPickItem>();
            for (ExecutableElement method : eu.findUnimplementedMethods(typeElement, true)) {
                boolean mustImplement = !method.getModifiers().contains((Object)Modifier.DEFAULT);
                Element enclosingElement = method.getEnclosingElement();
                String enclosingTypeName = enclosingElement.getKind().isClass() || enclosingElement.getKind().isInterface() ? Bundle.DN_From(((TypeElement)enclosingElement).getQualifiedName().toString()) : null;
                implementMethods.add(new QuickPickItem(ImplementOverrideMethodGenerator.createLabel((CompilationInfo)info, method), enclosingTypeName, null, mustImplement, new CodeActionsProvider.ElementData(method)));
            }
            if (!implementMethods.isEmpty()) {
                result.add(ImplementOverrideMethodGenerator.createCodeAction(Bundle.DN_GenerateImplementMethod(), "source.generate", GENERATE_IMPLEMENT_METHOD, uri, offset, implementMethods));
            }
        }
        if (typeElement.getKind().isClass() || typeElement.getKind().isInterface()) {
            ArrayList<QuickPickItem> overrideMethods = new ArrayList<QuickPickItem>();
            for (ExecutableElement method : eu.findOverridableMethods(typeElement)) {
                Element enclosingElement = method.getEnclosingElement();
                String enclosingTypeName = enclosingElement.getKind().isClass() || enclosingElement.getKind().isInterface() ? Bundle.DN_From(((TypeElement)enclosingElement).getQualifiedName().toString()) : null;
                QuickPickItem item = new QuickPickItem(ImplementOverrideMethodGenerator.createLabel((CompilationInfo)info, method));
                if (enclosingTypeName != null) {
                    item.setDescription(enclosingTypeName);
                }
                item.setUserData(new CodeActionsProvider.ElementData(method));
                overrideMethods.add(item);
            }
            if (!overrideMethods.isEmpty()) {
                result.add(ImplementOverrideMethodGenerator.createCodeAction(Bundle.DN_GenerateOverrideMethod(), "source.generate", GENERATE_OVERRIDE_METHOD, uri, offset, overrideMethods));
            }
        }
        return result;
    }

    @Override
    public Set<String> getCommands() {
        return this.commands;
    }

    @Override
    public CompletableFuture<Object> processCommand(NbCodeLanguageClient client, String command, List<Object> arguments) {
        if (arguments.size() > 2) {
            String uri = (String)this.gson.fromJson(this.gson.toJson(arguments.get(0)), String.class);
            int offset = (Integer)this.gson.fromJson(this.gson.toJson(arguments.get(1)), Integer.class);
            List<QuickPickItem> methods = Arrays.asList((QuickPickItem[])this.gson.fromJson(this.gson.toJson(arguments.get(2)), QuickPickItem[].class));
            String text = command == GENERATE_IMPLEMENT_METHOD ? Bundle.DN_SelectImplementMethod() : Bundle.DN_SelectOverrideMethod();
            boolean isImplement = command == GENERATE_IMPLEMENT_METHOD;
            client.showQuickPick(new ShowQuickPickParams(text, true, methods)).thenAccept(selected -> {
                if (selected != null && !selected.isEmpty()) {
                    this.generate(client, uri, offset, isImplement, (List<QuickPickItem>)selected);
                }
            });
        } else {
            client.logMessage(new MessageParams(MessageType.Error, String.format("Illegal number of arguments received for command: %s", command)));
        }
        return CompletableFuture.completedFuture(true);
    }

    private void generate(NbCodeLanguageClient client, String uri, int offset, boolean isImplement, List<QuickPickItem> methods) {
        try {
            FileObject file = Utils.fromUri(uri);
            JavaSource js = JavaSource.forFileObject((FileObject)file);
            if (js == null) {
                throw new IOException("Cannot get JavaSource for: " + uri);
            }
            List<TextEdit> edits = TextDocumentServiceImpl.modify2TextEdits(js, (Task<WorkingCopy>)((Task)wc -> {
                wc.toPhase(JavaSource.Phase.RESOLVED);
                TreePath tp = wc.getTreeUtilities().pathFor(offset);
                tp = wc.getTreeUtilities().getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, tp);
                if (tp != null) {
                    List selectedMethods = methods.stream().map(item -> {
                        CodeActionsProvider.ElementData data = (CodeActionsProvider.ElementData)this.gson.fromJson(this.gson.toJson(item.getUserData()), CodeActionsProvider.ElementData.class);
                        return (ExecutableElement)data.resolve((CompilationInfo)wc);
                    }).collect(Collectors.toList());
                    if (isImplement) {
                        GeneratorUtils.generateAbstractMethodImplementations((WorkingCopy)wc, (TreePath)tp, selectedMethods, (int)-1);
                    } else {
                        GeneratorUtils.generateMethodOverrides((WorkingCopy)wc, (TreePath)tp, selectedMethods, (int)-1);
                    }
                }
            }));
            client.applyEdit(new ApplyWorkspaceEditParams(new WorkspaceEdit(Collections.singletonMap(uri, edits))));
        }
        catch (IOException | IllegalArgumentException ex) {
            client.logMessage(new MessageParams(MessageType.Error, ex.getLocalizedMessage()));
        }
    }
}

