/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import com.google.gson.Gson;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.protocol.Bundle;
import org.netbeans.modules.java.lsp.server.protocol.CodeGenerator;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.java.lsp.server.protocol.QuickPickItem;
import org.netbeans.modules.java.lsp.server.protocol.ShowQuickPickParams;
import org.netbeans.modules.java.lsp.server.protocol.TextDocumentServiceImpl;
import org.openide.filesystems.FileObject;

public final class EqualsHashCodeGenerator
extends CodeGenerator {
    public static final String GENERATE_EQUALS = "java.generate.equals";
    public static final String GENERATE_HASH_CODE = "java.generate.hashCode";
    public static final String GENERATE_EQUALS_HASH_CODE = "java.generate.equals.hashCode";
    private final Set<String> commands = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("java.generate.equals.hashCode", "java.generate.equals", "java.generate.hashCode")));
    private final Gson gson = new Gson();

    @Override
    public List<CodeAction> getCodeActions(CompilationInfo info, CodeActionParams params) {
        List only = params.getContext().getOnly();
        if (only == null || !only.contains("source")) {
            return Collections.emptyList();
        }
        int offset = EqualsHashCodeGenerator.getOffset(info, params.getRange().getStart());
        TreePath tp = info.getTreeUtilities().pathFor(offset);
        tp = info.getTreeUtilities().getPathElementOfKind(Tree.Kind.CLASS, tp);
        if (tp == null) {
            return Collections.emptyList();
        }
        TypeElement type = (TypeElement)info.getTrees().getElement(tp);
        if (type == null || type.getKind() != ElementKind.CLASS) {
            return Collections.emptyList();
        }
        ExecutableElement[] equalsHashCode = org.netbeans.modules.java.editor.codegen.EqualsHashCodeGenerator.overridesHashCodeAndEquals((CompilationInfo)info, (Element)type, null);
        if (equalsHashCode[0] != null && equalsHashCode[1] != null) {
            return Collections.emptyList();
        }
        ArrayList<QuickPickItem> fields = new ArrayList<QuickPickItem>();
        for (VariableElement variableElement : ElementFilter.fieldsIn(type.getEnclosedElements())) {
            if ("<error>".contentEquals(variableElement.getSimpleName()) || variableElement.getModifiers().contains((Object)Modifier.STATIC)) continue;
            QuickPickItem item = new QuickPickItem(EqualsHashCodeGenerator.createLabel(info, variableElement));
            item.setUserData(new CodeGenerator.ElementData(variableElement));
            fields.add(item);
        }
        if (fields.isEmpty()) {
            return Collections.emptyList();
        }
        String uri = Utils.toUri(info.getFileObject());
        if (equalsHashCode[0] == null) {
            if (equalsHashCode[1] == null) {
                return Collections.singletonList(EqualsHashCodeGenerator.createCodeAction(Bundle.DN_GenerateEqualsHashCode(), "source.generate", GENERATE_EQUALS_HASH_CODE, uri, offset, fields));
            }
            return Collections.singletonList(EqualsHashCodeGenerator.createCodeAction(Bundle.DN_GenerateEquals(), "source.generate", GENERATE_EQUALS, uri, offset, fields));
        }
        return Collections.singletonList(EqualsHashCodeGenerator.createCodeAction(Bundle.DN_GenerateHashCode(), "source.generate", GENERATE_HASH_CODE, uri, offset, fields));
    }

    @Override
    public Set<String> getCommands() {
        return this.commands;
    }

    @Override
    public CompletableFuture<Object> processCommand(NbCodeLanguageClient client, String command, List<Object> arguments) {
        if (arguments.size() > 2) {
            String text;
            String uri = (String)this.gson.fromJson(this.gson.toJson(arguments.get(0)), String.class);
            int offset = (Integer)this.gson.fromJson(this.gson.toJson(arguments.get(1)), Integer.class);
            List<Object> fields = Arrays.asList((Object[])this.gson.fromJson(this.gson.toJson(arguments.get(2)), QuickPickItem[].class));
            boolean generateEquals = !GENERATE_HASH_CODE.equals(command);
            boolean generateHashCode = !GENERATE_EQUALS.equals(command);
            switch (command) {
                case "java.generate.equals": {
                    text = Bundle.DN_SelectEquals();
                    break;
                }
                case "java.generate.hashCode": {
                    text = Bundle.DN_SelectHashCode();
                    break;
                }
                default: {
                    text = Bundle.DN_SelectEqualsHashCode();
                }
            }
            client.showQuickPick(new ShowQuickPickParams(text, true, fields)).thenAccept(selected -> {
                if (selected != null) {
                    try {
                        FileObject file = Utils.fromUri(uri);
                        JavaSource js = JavaSource.forFileObject((FileObject)file);
                        if (js == null) {
                            throw new IOException("Cannot get JavaSource for: " + uri);
                        }
                        List<TextEdit> edits = TextDocumentServiceImpl.modify2TextEdits(js, (Task<WorkingCopy>)((Task)wc -> {
                            wc.toPhase(JavaSource.Phase.RESOLVED);
                            TreePath tp = wc.getTreeUtilities().pathFor(offset);
                            tp = wc.getTreeUtilities().getPathElementOfKind(Tree.Kind.CLASS, tp);
                            if (tp != null) {
                                List selectedFields = selected.stream().map(item -> {
                                    CodeGenerator.ElementData data = (CodeGenerator.ElementData)this.gson.fromJson(this.gson.toJson(item.getUserData()), CodeGenerator.ElementData.class);
                                    return (VariableElement)data.resolve((CompilationInfo)wc);
                                }).collect(Collectors.toList());
                                org.netbeans.modules.java.editor.codegen.EqualsHashCodeGenerator.generateEqualsAndHashCode((WorkingCopy)wc, (TreePath)tp, generateEquals ? selectedFields : null, generateHashCode ? selectedFields : null, (int)-1);
                            }
                        }));
                        client.applyEdit(new ApplyWorkspaceEditParams(new WorkspaceEdit(Collections.singletonMap(uri, edits))));
                    }
                    catch (IOException | IllegalArgumentException ex) {
                        client.logMessage(new MessageParams(MessageType.Error, ex.getLocalizedMessage()));
                    }
                }
            });
        } else {
            client.logMessage(new MessageParams(MessageType.Error, String.format("Illegal number of arguments received for command: %s", command)));
        }
        return CompletableFuture.completedFuture(true);
    }
}

