/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.test;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import junit.framework.TestCase;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MultiFileSystem;
import org.openide.filesystems.Repository;
import org.openide.filesystems.URLMapper;
import org.openide.util.BaseUtilities;

public class BootClassPathUtil {
    private static final String PROTOCOL = "nbjrt";
    private static ClassPath moduleBootOnJDK8;

    public static ClassPath getBootClassPath() {
        String cp = System.getProperty("sun.boot.class.path");
        if (cp != null) {
            String[] paths;
            ArrayList<URL> urls = new ArrayList<URL>();
            for (String path : paths = cp.split(Pattern.quote(System.getProperty("path.separator")))) {
                File f = new File(path);
                if (!f.canRead()) continue;
                org.openide.filesystems.FileObject fo = FileUtil.toFileObject((File)f);
                if (FileUtil.isArchiveFile((org.openide.filesystems.FileObject)fo)) {
                    fo = FileUtil.getArchiveRoot((org.openide.filesystems.FileObject)fo);
                }
                if (fo == null) continue;
                urls.add(fo.toURL());
            }
            return ClassPathSupport.createClassPath((URL[])urls.toArray(new URL[0]));
        }
        try {
            Class.forName("org.netbeans.ProxyURLStreamHandlerFactory").getMethod("register", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new IllegalStateException(ex);
        }
        ArrayList<PathResourceImplementation> modules = new ArrayList<PathResourceImplementation>();
        File installDir = new File(System.getProperty("java.home"));
        URI imageURI = BootClassPathUtil.getImageURI(installDir);
        try {
            org.openide.filesystems.FileObject jrtRoot = URLMapper.findFileObject((URL)imageURI.toURL());
            org.openide.filesystems.FileObject root = BootClassPathUtil.getModulesRoot(jrtRoot);
            for (org.openide.filesystems.FileObject module : root.getChildren()) {
                modules.add(ClassPathSupport.createResource((URL)module.toURL()));
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
        TestCase.assertFalse((boolean)modules.isEmpty());
        return ClassPathSupport.createClassPath(modules);
    }

    public static ClassPath getModuleBootPath() {
        if (System.getProperty("sun.boot.class.path") != null) {
            try {
                return BootClassPathUtil.getModuleBootOnJDK8();
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
        return BootClassPathUtil.getBootClassPath();
    }

    private static URI getImageURI(@NonNull File jdkHome) {
        try {
            return new URI(String.format("%s:%s!/%s", PROTOCOL, BaseUtilities.toURI((File)jdkHome).toString(), ""));
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException();
        }
    }

    @NonNull
    private static org.openide.filesystems.FileObject getModulesRoot(@NonNull org.openide.filesystems.FileObject jrtRoot) {
        org.openide.filesystems.FileObject modules = jrtRoot.getFileObject("modules");
        return modules == null ? jrtRoot : modules;
    }

    private static ClassPath getModuleBootOnJDK8() throws Exception {
        if (moduleBootOnJDK8 == null) {
            ArrayList<FileSystem> roots = new ArrayList<FileSystem>();
            FileSystem output = FileUtil.createMemoryFileSystem();
            org.openide.filesystems.FileObject sink = output.getRoot();
            roots.add(output);
            HashSet<String> packages = new HashSet<String>();
            for (org.openide.filesystems.FileObject r : BootClassPathUtil.getBootClassPath().getRoots()) {
                org.openide.filesystems.FileObject javaDir = r.getFileObject("java");
                if (javaDir == null) continue;
                roots.add(r.getFileSystem());
                Enumeration c = javaDir.getChildren(true);
                while (c.hasMoreElements()) {
                    org.openide.filesystems.FileObject current = (org.openide.filesystems.FileObject)c.nextElement();
                    if (!current.isData() || !current.hasExt("class")) continue;
                    String rel = FileUtil.getRelativePath((org.openide.filesystems.FileObject)r, (org.openide.filesystems.FileObject)current.getParent());
                    packages.add(rel.replace('/', '.'));
                }
            }
            MultiFileSystem outS = new MultiFileSystem(roots.toArray(new FileSystem[0])){
                {
                    this.setSystemName("module-boot");
                }
            };
            Repository.getDefault().addFileSystem((FileSystem)outS);
            final StringBuilder moduleInfo = new StringBuilder();
            moduleInfo.append("module java.base {\n");
            for (String pack : packages) {
                moduleInfo.append("    exports " + pack + ";\n");
            }
            moduleInfo.append("}\n");
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            org.openide.filesystems.FileObject javaBase = outS.getRoot();
            try (StandardJavaFileManager fm = compiler.getStandardFileManager(null, null, null);
                 JFMImpl fmImpl = new JFMImpl(fm, javaBase, sink);){
                compiler.getTask(null, fmImpl, null, Arrays.asList("-proc:none"), null, Arrays.asList(new SimpleJavaFileObject(new URI("mem:///module-info.java"), JavaFileObject.Kind.SOURCE){

                    @Override
                    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
                        return moduleInfo.toString();
                    }
                })).call();
            }
            javaBase.refresh();
            moduleBootOnJDK8 = ClassPathSupport.createClassPath((org.openide.filesystems.FileObject[])new org.openide.filesystems.FileObject[]{javaBase});
        }
        return moduleBootOnJDK8;
    }

    private static class JFMImpl
    extends ForwardingJavaFileManager<JavaFileManager> {
        private final org.openide.filesystems.FileObject output;
        private final org.openide.filesystems.FileObject sink;

        public JFMImpl(JavaFileManager fileManager, org.openide.filesystems.FileObject output, org.openide.filesystems.FileObject sink) {
            super(fileManager);
            this.output = output;
            this.sink = sink;
        }

        @Override
        public Iterable<Set<JavaFileManager.Location>> listLocationsForModules(JavaFileManager.Location location) throws IOException {
            return Collections.emptyList();
        }

        @Override
        public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
            if (location == StandardLocation.CLASS_OUTPUT) {
                ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>();
                org.openide.filesystems.FileObject pack = this.output.getFileObject(packageName.replace('.', '/'));
                if (pack != null) {
                    Enumeration c = pack.getChildren(recurse);
                    while (c.hasMoreElements()) {
                        org.openide.filesystems.FileObject file = (org.openide.filesystems.FileObject)c.nextElement();
                        if (!file.hasExt("class")) continue;
                        result.add(new InferableJavaFileObject(file, JavaFileObject.Kind.CLASS));
                    }
                }
                return result;
            }
            return super.list(location, packageName, kinds, recurse);
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
            if (location == StandardLocation.CLASS_OUTPUT) {
                final String relPath = className.replace('.', '/') + ".class";
                try {
                    return new SimpleJavaFileObject(new URI("mem://" + relPath), kind){

                        @Override
                        public OutputStream openOutputStream() throws IOException {
                            return new ByteArrayOutputStream(){

                                @Override
                                public void close() throws IOException {
                                    super.close();
                                    org.openide.filesystems.FileObject target = FileUtil.createData((org.openide.filesystems.FileObject)sink, (String)relPath);
                                    try (OutputStream out = target.getOutputStream();){
                                        out.write(this.toByteArray());
                                    }
                                }
                            };
                        }
                    };
                }
                catch (URISyntaxException ex) {
                    throw new IOException(ex);
                }
            }
            return super.getJavaFileForOutput(location, className, kind, sibling);
        }

        @Override
        public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
            if (file instanceof InferableJavaFileObject) {
                return ((InferableJavaFileObject)file).className;
            }
            return super.inferBinaryName(location, file);
        }

        private class InferableJavaFileObject
        extends SimpleJavaFileObject {
            private final String className;

            public InferableJavaFileObject(org.openide.filesystems.FileObject file, JavaFileObject.Kind kind) {
                super(file.toURI(), kind);
                String relPath = FileUtil.getRelativePath((org.openide.filesystems.FileObject)JFMImpl.this.output, (org.openide.filesystems.FileObject)file);
                this.className = relPath.substring(0, relPath.length() - ".class".length()).replace('/', '.');
            }
        }
    }
}

