/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.core.api.multiview.MultiViews;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.StatusDecorator;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.windows.CloneableOpenSupport;

public class GradleDataObject
extends MultiDataObject {
    public static final String MIME_TYPE = "text/x-gradle+x-groovy";
    public static final String KOTLIN_MIME_TYPE = "text/x-gradle+x-kotlin";

    public GradleDataObject(FileObject pf, MultiFileLoader loader) throws DataObjectExistsException, IOException {
        super(pf, loader);
        this.getCookieSet().add((Node.Cookie)new GradleDataEditor());
    }

    protected int associateLookup() {
        return 1;
    }

    static String getFileOrProjectName(FileObject primaryFile) {
        String ret = primaryFile.getNameExt();
        if ("build.gradle".equals(ret) || "build.gradle.kts".equals(ret)) {
            try {
                Project prj = ProjectManager.getDefault().findProject(primaryFile.getParent());
                if (prj != null) {
                    ret = ProjectUtils.getInformation((Project)prj).getName();
                }
            }
            catch (IOException | IllegalArgumentException ex) {
                Logger.getLogger(GradleDataObject.class.getName()).log(Level.INFO, "Could not determine project and its name", ex);
            }
        }
        return ret;
    }

    private class GradleDataEditor
    extends DataEditorSupport
    implements EditorCookie.Observable,
    OpenCookie,
    EditCookie,
    PrintCookie,
    CloseCookie {
        private final SaveCookie save;

        GradleDataEditor() {
            super((DataObject)GradleDataObject.this, null, (CloneableEditorSupport.Env)new GradleEnv(GradleDataObject.this));
            this.save = new SaveCookie(){

                public void save() throws IOException {
                    GradleDataEditor.this.saveDocument();
                }

                public String toString() {
                    return GradleDataObject.this.getPrimaryFile().getNameExt();
                }
            };
        }

        protected CloneableEditorSupport.Pane createPane() {
            String mime = "kts".equals(GradleDataObject.this.getPrimaryFile().getExt()) ? GradleDataObject.KOTLIN_MIME_TYPE : GradleDataObject.MIME_TYPE;
            return (CloneableEditorSupport.Pane)MultiViews.createCloneableMultiView((String)mime, (Serializable)this.getDataObject());
        }

        protected boolean notifyModified() {
            if (!super.notifyModified()) {
                return false;
            }
            if (GradleDataObject.this.getLookup().lookup(SaveCookie.class) == null) {
                GradleDataObject.this.getCookieSet().add((Node.Cookie)this.save);
                GradleDataObject.this.setModified(true);
            }
            return true;
        }

        protected void notifyUnmodified() {
            super.notifyUnmodified();
            if (GradleDataObject.this.getLookup().lookup(SaveCookie.class) == this.save) {
                GradleDataObject.this.getCookieSet().remove((Node.Cookie)this.save);
                GradleDataObject.this.setModified(false);
            }
        }

        protected String messageName() {
            String title = GradleDataObject.getFileOrProjectName(GradleDataObject.this.getPrimaryFile());
            try {
                StatusDecorator decorator = GradleDataObject.this.getPrimaryFile().getFileSystem().getDecorator();
                title = decorator.annotateName(title, Collections.singleton(GradleDataObject.this.getPrimaryFile()));
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
            return GradleDataEditor.annotateName((String)title, (boolean)false, (boolean)this.isModified(), (!GradleDataObject.this.getPrimaryFile().canWrite() ? 1 : 0) != 0);
        }

        protected String messageHtmlName() {
            String title = GradleDataObject.getFileOrProjectName(GradleDataObject.this.getPrimaryFile());
            try {
                StatusDecorator decorator = GradleDataObject.this.getPrimaryFile().getFileSystem().getDecorator();
                String annotateNameHtml = decorator.annotateNameHtml(title, Collections.singleton(GradleDataObject.this.getPrimaryFile()));
                if (annotateNameHtml != null && !title.equals(annotateNameHtml)) {
                    title = annotateNameHtml;
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
            return GradleDataEditor.annotateName((String)title, (boolean)true, (boolean)this.isModified(), (!GradleDataObject.this.getPrimaryFile().canWrite() ? 1 : 0) != 0);
        }

        protected boolean asynchronousOpen() {
            return true;
        }
    }

    private static class GradleEnv
    extends DataEditorSupport.Env {
        private static final long serialVersionUID = 1L;

        GradleEnv(MultiDataObject d) {
            super((DataObject)d);
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return ((MultiDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (CloneableOpenSupport)this.getDataObject().getLookup().lookup(GradleDataEditor.class);
        }
    }
}

