/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.options;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.gradle.api.execute.GradleDistributionManager;
import org.netbeans.modules.gradle.options.Bundle;
import org.netbeans.modules.gradle.options.GradleExperimentalSettings;
import org.netbeans.modules.gradle.options.NetworkProxySettings;
import org.netbeans.modules.gradle.spi.GradleSettings;
import org.openide.LifecycleManager;
import org.openide.awt.Mnemonics;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class SettingsPanel
extends JPanel {
    private static final String RESTART_ICON = "org/netbeans/modules/gradle/resources/restart.png";
    private static final String[] CARDS = new String[]{"Execution", "Appearance", "Dependencies", "Maven", "Experimental"};
    private GradleDistributionManager gdm = GradleDistributionManager.get();
    private ButtonGroup bgUsedDistribution;
    private JButton btDefaultHome;
    private JButton btGradleUserHome;
    private JButton btUseCustomGradle;
    private JComboBox<GradleSettings.GradleExecutionRule> cbAllowExecution;
    private JCheckBox cbAlwaysShowOutput;
    private JCheckBox cbBundledLoading;
    private JCheckBox cbConfigureOnDemand;
    private JCheckBox cbDisplayDescription;
    private JComboBox<GradleSettings.DownloadMiscRule> cbDownloadJavadoc;
    private JComboBox<GradleSettings.DownloadLibsRule> cbDownloadLibs;
    private JComboBox<GradleSettings.DownloadMiscRule> cbDownloadSources;
    private JCheckBox cbEnableCache;
    private JComboBox<GradleDistributionManager.GradleDistribution> cbGradleVersion;
    private JCheckBox cbHideEmptyConfig;
    private JComboBox<NetworkProxySettings> cbNetworkProxy;
    private JCheckBox cbNoRebuild;
    private JCheckBox cbOffline;
    private JCheckBox cbOpenLazy;
    private JCheckBox cbPreferMaven;
    private JCheckBox cbPreferWrapper;
    private JCheckBox cbReuseEditorOnStackTrace;
    private JCheckBox cbReuseOutputTabs;
    private JCheckBox cbSilentInstall;
    private JCheckBox cbSkipCheck;
    private JCheckBox cbSkipTest;
    private JCheckBox cbStartDaemonOnStart;
    private JCheckBox cbUseConfigCache;
    private JLabel lbAllowExecution;
    private JLabel lbDownloadJavadoc;
    private JLabel lbDownloadLibs;
    private JLabel lbDownloadSources;
    private JLabel lbNetworkProxy;
    private JLabel lbVersionInfo;
    private JLabel lblCategories;
    private JLabel lblGradleDistribution;
    private JLabel lblGradleUserHome;
    private JList<String> lstCategories;
    private JPanel pnlAppearance;
    private JPanel pnlCards;
    private JPanel pnlCategories;
    private JPanel pnlDependencies;
    private JPanel pnlExecution;
    private JPanel pnlExperimental;
    private JPanel pnlMaven;
    private JRadioButton rbUseCustomGradle;
    private JRadioButton rbUseStandardGradle;
    private JTextField tfGradleUserHome;
    private JTextField tfUseCustomGradle;

    public SettingsPanel() {
        this.initComponents();
        this.cbGradleVersion.setRenderer(new VersionCellRenderer(this.cbGradleVersion.getRenderer()));
        this.lstCategories.setSelectedIndex(0);
        this.cbDownloadLibs.setModel(new DefaultComboBoxModel<GradleSettings.DownloadLibsRule>(GradleSettings.DownloadLibsRule.values()));
        this.cbDownloadSources.setModel(new DefaultComboBoxModel<GradleSettings.DownloadMiscRule>(GradleSettings.DownloadMiscRule.values()));
        this.cbDownloadJavadoc.setModel(new DefaultComboBoxModel<GradleSettings.DownloadMiscRule>(GradleSettings.DownloadMiscRule.values()));
        this.cbAllowExecution.setModel(new DefaultComboBoxModel<GradleSettings.GradleExecutionRule>(GradleSettings.GradleExecutionRule.values()));
        DefaultComboBoxModel<NetworkProxySettings> mdl = new DefaultComboBoxModel<NetworkProxySettings>(NetworkProxySettings.values());
        if (!NetworkProxySettings.allowProxyOverride()) {
            mdl.removeElement((Object)NetworkProxySettings.OVERRIDE);
        }
        this.cbNetworkProxy.setModel(mdl);
    }

    private void initComponents() {
        this.bgUsedDistribution = new ButtonGroup();
        this.pnlCategories = new JPanel();
        this.lblCategories = new JLabel();
        this.lstCategories = new JList();
        this.pnlCards = new JPanel();
        this.pnlExecution = new JPanel();
        JPanel jPanel1 = new JPanel();
        this.lblGradleUserHome = new JLabel();
        this.tfGradleUserHome = new JTextField();
        this.btGradleUserHome = new JButton();
        this.lblGradleDistribution = new JLabel();
        this.cbGradleVersion = new JComboBox();
        this.rbUseStandardGradle = new JRadioButton();
        this.rbUseCustomGradle = new JRadioButton();
        this.tfUseCustomGradle = new JTextField();
        this.btUseCustomGradle = new JButton();
        this.cbStartDaemonOnStart = new JCheckBox();
        this.cbPreferWrapper = new JCheckBox();
        this.lbVersionInfo = new JLabel();
        this.cbSilentInstall = new JCheckBox();
        this.btDefaultHome = new JButton();
        JPanel jPanel2 = new JPanel();
        this.cbOffline = new JCheckBox();
        this.cbSkipTest = new JCheckBox();
        this.cbSkipCheck = new JCheckBox();
        this.cbUseConfigCache = new JCheckBox();
        this.cbConfigureOnDemand = new JCheckBox();
        this.cbNoRebuild = new JCheckBox();
        this.lbAllowExecution = new JLabel();
        this.cbAllowExecution = new JComboBox();
        this.lbNetworkProxy = new JLabel();
        this.cbNetworkProxy = new JComboBox();
        this.pnlAppearance = new JPanel();
        JPanel jPanel4 = new JPanel();
        this.cbDisplayDescription = new JCheckBox();
        this.cbHideEmptyConfig = new JCheckBox();
        JPanel jPanel5 = new JPanel();
        this.cbAlwaysShowOutput = new JCheckBox();
        this.cbReuseOutputTabs = new JCheckBox();
        this.cbReuseEditorOnStackTrace = new JCheckBox();
        this.pnlDependencies = new JPanel();
        JPanel jPanel8 = new JPanel();
        this.cbDownloadJavadoc = new JComboBox();
        this.cbDownloadSources = new JComboBox();
        this.cbDownloadLibs = new JComboBox();
        this.lbDownloadLibs = new JLabel();
        this.lbDownloadSources = new JLabel();
        this.lbDownloadJavadoc = new JLabel();
        this.pnlMaven = new JPanel();
        JPanel jPanel3 = new JPanel();
        this.cbPreferMaven = new JCheckBox();
        this.pnlExperimental = new JPanel();
        JPanel jPanel7 = new JPanel();
        this.cbEnableCache = new JCheckBox();
        this.cbOpenLazy = new JCheckBox();
        this.cbBundledLoading = new JCheckBox();
        this.setPreferredSize(new Dimension(723, 417));
        this.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this.lblCategories, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.lblCategories.text"));
        this.lstCategories.setModel((ListModel<String>)new AbstractListModel<String>(){
            String[] strings = new String[]{"Execution", "Appearance", "Dependencies", "Maven", "Experimental"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public String getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.lstCategories.setSelectionMode(0);
        this.lstCategories.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                SettingsPanel.this.lstCategoriesValueChanged(evt);
            }
        });
        GroupLayout pnlCategoriesLayout = new GroupLayout(this.pnlCategories);
        this.pnlCategories.setLayout(pnlCategoriesLayout);
        pnlCategoriesLayout.setHorizontalGroup(pnlCategoriesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlCategoriesLayout.createSequentialGroup().addContainerGap().addGroup(pnlCategoriesLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lstCategories, -1, -1, Short.MAX_VALUE).addComponent(this.lblCategories, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        pnlCategoriesLayout.setVerticalGroup(pnlCategoriesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlCategoriesLayout.createSequentialGroup().addContainerGap().addComponent(this.lblCategories).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lstCategories, -1, 382, Short.MAX_VALUE).addContainerGap()));
        this.add((Component)this.pnlCategories, "West");
        this.pnlCards.setPreferredSize(new Dimension(800, 415));
        this.pnlCards.setLayout(new CardLayout());
        this.pnlExecution.setPreferredSize(new Dimension(800, 415));
        jPanel1.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.jPanel1.border.title")));
        Mnemonics.setLocalizedText((JLabel)this.lblGradleUserHome, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.lblGradleUserHome.text"));
        this.tfGradleUserHome.setEditable(false);
        Mnemonics.setLocalizedText((AbstractButton)this.btGradleUserHome, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.btGradleUserHome.text"));
        this.btGradleUserHome.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsPanel.this.btGradleUserHomeActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lblGradleDistribution, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.lblGradleDistribution.text"));
        this.cbGradleVersion.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SettingsPanel.this.cbGradleVersionItemStateChanged(evt);
            }
        });
        this.bgUsedDistribution.add(this.rbUseStandardGradle);
        Mnemonics.setLocalizedText((AbstractButton)this.rbUseStandardGradle, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.rbUseStandardGradle.text"));
        this.rbUseStandardGradle.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SettingsPanel.this.rbUseStandardGradleStateChanged(evt);
            }
        });
        this.bgUsedDistribution.add(this.rbUseCustomGradle);
        Mnemonics.setLocalizedText((AbstractButton)this.rbUseCustomGradle, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.rbUseCustomGradle.text"));
        this.rbUseCustomGradle.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SettingsPanel.this.rbUseCustomGradleStateChanged(evt);
            }
        });
        this.tfUseCustomGradle.setEditable(false);
        this.tfUseCustomGradle.setText(NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.tfUseCustomGradle.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btUseCustomGradle, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.btUseCustomGradle.text"));
        this.btUseCustomGradle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsPanel.this.btUseCustomGradleActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbStartDaemonOnStart, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.cbStartDaemonOnStart.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbPreferWrapper, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.cbPreferWrapper.text"));
        Mnemonics.setLocalizedText((JLabel)this.lbVersionInfo, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.lbVersionInfo.text"));
        this.lbVersionInfo.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.cbSilentInstall, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.cbSilentInstall.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btDefaultHome, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.btDefaultHome.text"));
        this.btDefaultHome.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsPanel.this.btDefaultHomeActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.lblGradleDistribution).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.rbUseStandardGradle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbGradleVersion, 0, 107, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.rbUseCustomGradle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfUseCustomGradle))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btUseCustomGradle, -1, 102, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbSilentInstall).addComponent(this.cbStartDaemonOnStart).addComponent(this.cbPreferWrapper)).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.lblGradleUserHome).addGap(9, 9, 9).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.lbVersionInfo, -1, -1, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.tfGradleUserHome).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btGradleUserHome, -2, 105, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btDefaultHome, -2, 105, -2))))).addGap(2, 2, 2)));
        jPanel1Layout.linkSize(0, this.btGradleUserHome, this.btUseCustomGradle);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblGradleUserHome).addComponent(this.tfGradleUserHome, -2, -1, -2).addComponent(this.btGradleUserHome).addComponent(this.btDefaultHome)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lbVersionInfo, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblGradleDistribution).addComponent(this.cbGradleVersion, -2, -1, -2).addComponent(this.rbUseStandardGradle)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.rbUseCustomGradle).addComponent(this.tfUseCustomGradle, -2, -1, -2).addComponent(this.btUseCustomGradle)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cbPreferWrapper).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbStartDaemonOnStart).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbSilentInstall)));
        jPanel2.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.jPanel2.border.title")));
        Mnemonics.setLocalizedText((AbstractButton)this.cbOffline, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.cbOffline.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbSkipTest, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.cbSkipTest.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbSkipCheck, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.cbSkipCheck.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbUseConfigCache, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.cbUseConfigCache.text"));
        this.cbUseConfigCache.setToolTipText(NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.cbUseConfigCache.toolTipText"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbConfigureOnDemand, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.cbConfigureOnDemand.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbNoRebuild, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.cbNoRebuild.text"));
        this.cbNoRebuild.setToolTipText(NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.cbNoRebuild.toolTipText"));
        this.lbAllowExecution.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.lbAllowExecution, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.lbAllowExecution.text"));
        Mnemonics.setLocalizedText((JLabel)this.lbNetworkProxy, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.lbNetworkProxy.text"));
        GroupLayout jPanel2Layout = new GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbOffline).addComponent(this.cbConfigureOnDemand).addComponent(this.cbNoRebuild, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbUseConfigCache).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.cbSkipCheck, -1, -1, Short.MAX_VALUE).addComponent(this.cbSkipTest, -1, -1, Short.MAX_VALUE)))).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lbAllowExecution, -1, -1, Short.MAX_VALUE).addComponent(this.lbNetworkProxy, -2, 142, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.cbNetworkProxy, 0, -1, Short.MAX_VALUE).addComponent(this.cbAllowExecution, -2, 280, -2)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbOffline).addComponent(this.cbSkipCheck)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbSkipTest).addComponent(this.cbNoRebuild, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbConfigureOnDemand).addComponent(this.cbUseConfigCache)).addGap(18, 18, 18).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbAllowExecution, -2, -1, -2).addComponent(this.lbAllowExecution)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbNetworkProxy, -2, -1, -2).addComponent(this.lbNetworkProxy)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout pnlExecutionLayout = new GroupLayout(this.pnlExecution);
        this.pnlExecution.setLayout(pnlExecutionLayout);
        pnlExecutionLayout.setHorizontalGroup(pnlExecutionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pnlExecutionLayout.createSequentialGroup().addContainerGap().addGroup(pnlExecutionLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jPanel1, -1, -1, Short.MAX_VALUE).addComponent(jPanel2, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        pnlExecutionLayout.setVerticalGroup(pnlExecutionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlExecutionLayout.createSequentialGroup().addContainerGap().addComponent(jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel2, -2, -1, -2).addContainerGap(14, Short.MAX_VALUE)));
        this.pnlCards.add((Component)this.pnlExecution, "Execution");
        this.pnlAppearance.setPreferredSize(new Dimension(800, 415));
        jPanel4.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.jPanel4.border.title")));
        this.cbDisplayDescription.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cbDisplayDescription, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.cbDisplayDescription.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbHideEmptyConfig, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.cbHideEmptyConfig.text"));
        GroupLayout jPanel4Layout = new GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbDisplayDescription, -1, -1, Short.MAX_VALUE).addComponent(this.cbHideEmptyConfig, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.cbDisplayDescription).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbHideEmptyConfig).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel5.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.jPanel5.border.title")));
        Mnemonics.setLocalizedText((AbstractButton)this.cbAlwaysShowOutput, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.cbAlwaysShowOutput.text"));
        this.cbReuseOutputTabs.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cbReuseOutputTabs, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.cbReuseOutputTabs.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbReuseEditorOnStackTrace, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.cbReuseEditorOnStackTrace.text"));
        GroupLayout jPanel5Layout = new GroupLayout(jPanel5);
        jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbReuseEditorOnStackTrace, -1, 541, Short.MAX_VALUE).addComponent(this.cbReuseOutputTabs, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.cbAlwaysShowOutput, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.cbAlwaysShowOutput).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbReuseOutputTabs).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbReuseEditorOnStackTrace).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout pnlAppearanceLayout = new GroupLayout(this.pnlAppearance);
        this.pnlAppearance.setLayout(pnlAppearanceLayout);
        pnlAppearanceLayout.setHorizontalGroup(pnlAppearanceLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pnlAppearanceLayout.createSequentialGroup().addContainerGap().addGroup(pnlAppearanceLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jPanel5, -1, -1, Short.MAX_VALUE).addComponent(jPanel4, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        pnlAppearanceLayout.setVerticalGroup(pnlAppearanceLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlAppearanceLayout.createSequentialGroup().addContainerGap().addComponent(jPanel4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel5, -2, -1, -2).addContainerGap(216, Short.MAX_VALUE)));
        this.pnlCards.add((Component)this.pnlAppearance, "Appearance");
        this.pnlDependencies.setPreferredSize(new Dimension(800, 415));
        jPanel8.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.jPanel8.border.title")));
        this.cbDownloadJavadoc.setToolTipText(NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.cbDownloadJavadoc.toolTipText"));
        this.cbDownloadJavadoc.setEnabled(false);
        this.cbDownloadSources.setToolTipText(NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.cbDownloadSources.toolTipText"));
        this.cbDownloadSources.setEnabled(false);
        this.lbDownloadLibs.setLabelFor(this.cbDownloadLibs);
        Mnemonics.setLocalizedText((JLabel)this.lbDownloadLibs, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.lbDownloadLibs.text"));
        this.lbDownloadSources.setLabelFor(this.cbDownloadSources);
        Mnemonics.setLocalizedText((JLabel)this.lbDownloadSources, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.lbDownloadSources.text"));
        this.lbDownloadJavadoc.setLabelFor(this.cbDownloadJavadoc);
        Mnemonics.setLocalizedText((JLabel)this.lbDownloadJavadoc, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.lbDownloadJavadoc.text"));
        GroupLayout jPanel8Layout = new GroupLayout(jPanel8);
        jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addContainerGap().addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.lbDownloadSources, -1, -1, Short.MAX_VALUE).addComponent(this.lbDownloadJavadoc, -1, -1, Short.MAX_VALUE).addComponent(this.lbDownloadLibs, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbDownloadSources, 0, 238, Short.MAX_VALUE).addComponent(this.cbDownloadLibs, 0, -1, Short.MAX_VALUE).addComponent(this.cbDownloadJavadoc, 0, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel8Layout.setVerticalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addContainerGap().addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbDownloadLibs).addComponent(this.cbDownloadLibs, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbDownloadSources).addComponent(this.cbDownloadSources, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbDownloadJavadoc).addComponent(this.cbDownloadJavadoc, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout pnlDependenciesLayout = new GroupLayout(this.pnlDependencies);
        this.pnlDependencies.setLayout(pnlDependenciesLayout);
        pnlDependenciesLayout.setHorizontalGroup(pnlDependenciesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlDependenciesLayout.createSequentialGroup().addContainerGap().addComponent(jPanel8, -1, -1, Short.MAX_VALUE).addContainerGap()));
        pnlDependenciesLayout.setVerticalGroup(pnlDependenciesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlDependenciesLayout.createSequentialGroup().addContainerGap().addComponent(jPanel8, -2, -1, -2).addContainerGap(294, Short.MAX_VALUE)));
        this.pnlCards.add((Component)this.pnlDependencies, "Dependencies");
        jPanel3.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.jPanel3.border.title")));
        Mnemonics.setLocalizedText((AbstractButton)this.cbPreferMaven, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.cbPreferMaven.text"));
        GroupLayout jPanel3Layout = new GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.cbPreferMaven).addContainerGap(231, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.cbPreferMaven).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout pnlMavenLayout = new GroupLayout(this.pnlMaven);
        this.pnlMaven.setLayout(pnlMavenLayout);
        pnlMavenLayout.setHorizontalGroup(pnlMavenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pnlMavenLayout.createSequentialGroup().addContainerGap().addComponent(jPanel3, -1, -1, Short.MAX_VALUE).addContainerGap()));
        pnlMavenLayout.setVerticalGroup(pnlMavenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlMavenLayout.createSequentialGroup().addContainerGap().addComponent(jPanel3, -2, -1, -2).addContainerGap(354, Short.MAX_VALUE)));
        this.pnlCards.add((Component)this.pnlMaven, "Maven");
        jPanel7.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.jPanel7.border.title")));
        Mnemonics.setLocalizedText((AbstractButton)this.cbEnableCache, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.cbEnableCache.text"));
        this.cbEnableCache.setToolTipText(NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.cbEnableCache.toolTipText"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbOpenLazy, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.cbOpenLazy.text"));
        this.cbOpenLazy.setToolTipText(NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.cbOpenLazy.toolTipText"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbBundledLoading, (String)NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.cbBundledLoading.text"));
        this.cbBundledLoading.setToolTipText(NbBundle.getMessage(SettingsPanel.class, (String)"SettingsPanel.cbBundledLoading.toolTipText"));
        GroupLayout jPanel7Layout = new GroupLayout(jPanel7);
        jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbOpenLazy).addComponent(this.cbEnableCache).addComponent(this.cbBundledLoading)).addContainerGap(289, Short.MAX_VALUE)));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addComponent(this.cbEnableCache).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbOpenLazy).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbBundledLoading).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout pnlExperimentalLayout = new GroupLayout(this.pnlExperimental);
        this.pnlExperimental.setLayout(pnlExperimentalLayout);
        pnlExperimentalLayout.setHorizontalGroup(pnlExperimentalLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlExperimentalLayout.createSequentialGroup().addContainerGap().addComponent(jPanel7, -1, -1, Short.MAX_VALUE).addContainerGap()));
        pnlExperimentalLayout.setVerticalGroup(pnlExperimentalLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlExperimentalLayout.createSequentialGroup().addContainerGap().addComponent(jPanel7, -2, -1, -2).addContainerGap(300, Short.MAX_VALUE)));
        this.pnlCards.add((Component)this.pnlExperimental, "Experimental");
        this.add((Component)this.pnlCards, "Center");
    }

    private void btUseCustomGradleActionPerformed(ActionEvent evt) {
        File f;
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(Bundle.TIT_CustomGradle());
        chooser.setFileSelectionMode(1);
        chooser.setFileHidingEnabled(false);
        String path = this.tfUseCustomGradle.getText();
        if (path == null || path.trim().length() == 0) {
            path = GradleSettings.getDefault().getGradleUserHome().getAbsolutePath();
        }
        if (path.length() > 0 && (f = new File(path)).exists()) {
            chooser.setSelectedFile(f);
        }
        if (0 == chooser.showOpenDialog(this)) {
            File distDir = chooser.getSelectedFile();
            this.tfUseCustomGradle.setText(distDir.getAbsolutePath());
        }
    }

    private void lstCategoriesValueChanged(ListSelectionEvent evt) {
        int idx = this.lstCategories.getSelectedIndex();
        CardLayout cardLayout = (CardLayout)this.pnlCards.getLayout();
        if (idx >= 0 && idx < CARDS.length) {
            cardLayout.show(this.pnlCards, CARDS[idx]);
        }
    }

    private void cbGradleVersionItemStateChanged(ItemEvent evt) {
        GradleDistributionManager.GradleDistribution v;
        if (evt.getItem() instanceof GradleDistributionManager.GradleDistribution && (v = (GradleDistributionManager.GradleDistribution)evt.getItem()) != null && evt.getStateChange() == 1) {
            if (v.isBlackListed()) {
                this.lbVersionInfo.setText(Bundle.LBL_IncompatibleGradle());
            } else {
                this.lbVersionInfo.setText(null);
            }
        }
    }

    private void rbUseStandardGradleStateChanged(ChangeEvent evt) {
        boolean selected = this.rbUseStandardGradle.isSelected();
        this.cbGradleVersion.setEnabled(selected);
    }

    private void rbUseCustomGradleStateChanged(ChangeEvent evt) {
        boolean selected = this.rbUseCustomGradle.isSelected();
        this.tfUseCustomGradle.setEnabled(selected);
        this.btUseCustomGradle.setEnabled(selected);
    }

    private void btGradleUserHomeActionPerformed(ActionEvent evt) {
        File f;
        GradleSettings settings = GradleSettings.getDefault();
        settings.getGradleUserHome();
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(Bundle.TIT_GradleUserHome());
        chooser.setFileSelectionMode(1);
        chooser.setFileHidingEnabled(false);
        String path = this.tfGradleUserHome.getText();
        if (path.length() > 0 && (f = new File(path)).exists()) {
            chooser.setSelectedFile(f);
        }
        if (0 == chooser.showOpenDialog(this)) {
            File home = chooser.getSelectedFile();
            this.tfGradleUserHome.setText(home.getAbsolutePath());
            this.gdm = GradleDistributionManager.get(home);
            this.cbGradleVersion.repaint();
        }
    }

    private void btDefaultHomeActionPerformed(ActionEvent evt) {
        this.tfGradleUserHome.setText(SettingsPanel.getDefaultGradleUserHome());
    }

    public void setValues() {
        final GradleSettings settings = GradleSettings.getDefault();
        GradleExperimentalSettings experimental = GradleExperimentalSettings.getDefault();
        this.tfGradleUserHome.setText(settings.getGradleUserHome().getAbsolutePath());
        this.tfUseCustomGradle.setText(settings.getDistributionHome());
        this.cbPreferWrapper.setSelected(settings.isWrapperPreferred());
        ButtonModel bm = settings.useCustomGradle() ? this.rbUseCustomGradle.getModel() : this.rbUseStandardGradle.getModel();
        this.bgUsedDistribution.setSelected(bm, true);
        this.cbStartDaemonOnStart.setSelected(settings.isStartDaemonOnStart());
        this.cbSilentInstall.setSelected(settings.isSilentInstall());
        this.cbOffline.setSelected(settings.isOffline());
        this.cbNoRebuild.setSelected(settings.getNoRebuild());
        this.cbConfigureOnDemand.setSelected(settings.isConfigureOnDemand());
        this.cbUseConfigCache.setSelected(settings.getUseConfigCache());
        this.cbSkipCheck.setSelected(settings.skipCheck());
        this.cbSkipTest.setSelected(settings.skipTest());
        this.cbHideEmptyConfig.setSelected(settings.isHideEmptyConfigurations());
        this.cbAlwaysShowOutput.setSelected(settings.isAlwaysShowOutput());
        this.cbReuseOutputTabs.setSelected(settings.isReuseOutputTabs());
        this.cbDisplayDescription.setSelected(settings.isDisplayDesctiption());
        this.cbReuseEditorOnStackTrace.setSelected(settings.isReuseEditorOnStackTace());
        this.cbEnableCache.setSelected(!experimental.isCacheDisabled());
        this.cbOpenLazy.setSelected(experimental.isOpenLazy());
        this.cbBundledLoading.setSelected(experimental.isBundledLoading());
        this.cbPreferMaven.setSelected(settings.isPreferMaven());
        this.cbDownloadLibs.setSelectedItem((Object)settings.getDownloadLibs());
        this.cbDownloadSources.setSelectedItem((Object)settings.getDownloadSources());
        this.cbDownloadJavadoc.setSelectedItem((Object)settings.getDownloadJavadoc());
        this.cbAllowExecution.setSelectedItem((Object)settings.getGradleExecutionRule());
        this.cbNetworkProxy.setSelectedItem((Object)experimental.getNetworkProxy());
        new SwingWorker<List<GradleDistributionManager.GradleDistribution>, Void>(){

            @Override
            protected List<GradleDistributionManager.GradleDistribution> doInBackground() throws Exception {
                try {
                    return SettingsPanel.this.gdm.availableDistributions(true);
                }
                catch (IOException ex) {
                    return SettingsPanel.this.gdm.availableLocalDistributions();
                }
            }

            @Override
            protected void done() {
                GradleDistributionManager.GradleDistribution[] items = new GradleDistributionManager.GradleDistribution[]{};
                try {
                    items = ((List)this.get()).toArray(new GradleDistributionManager.GradleDistribution[0]);
                }
                catch (InterruptedException | ExecutionException exception) {
                    // empty catch block
                }
                DefaultComboBoxModel<GradleDistributionManager.GradleDistribution> model = new DefaultComboBoxModel<GradleDistributionManager.GradleDistribution>(items);
                SettingsPanel.this.cbGradleVersion.setModel(model);
                model.setSelectedItem(SettingsPanel.this.gdm.distributionFromVersion(settings.getGradleVersion()));
            }
        }.execute();
    }

    public void applyValues() {
        GradleSettings settings = GradleSettings.getDefault();
        GradleExperimentalSettings experimental = GradleExperimentalSettings.getDefault();
        if (SettingsPanel.getDefaultGradleUserHome().equals(this.tfGradleUserHome.getText())) {
            settings.setGradleUserHome(null);
        } else {
            settings.setGradleUserHome(new File(this.tfGradleUserHome.getText()));
        }
        GradleDistributionManager.GradleDistribution distVersion = (GradleDistributionManager.GradleDistribution)this.cbGradleVersion.getSelectedItem();
        if (distVersion != null) {
            settings.setGradleVersion(distVersion.getVersion());
        }
        settings.setDistributionHome(this.tfUseCustomGradle.getText());
        settings.setWrapperPreferred(this.cbPreferWrapper.isSelected());
        boolean useCustomGradle = this.bgUsedDistribution.getSelection() == this.rbUseCustomGradle.getModel();
        settings.setUseCustomGradle(useCustomGradle);
        settings.setStartDaemonOnStart(this.cbStartDaemonOnStart.isSelected());
        settings.setSilentInstall(this.cbSilentInstall.isSelected());
        settings.setOffline(this.cbOffline.isSelected());
        settings.setNoRebuild(this.cbNoRebuild.isSelected());
        settings.setConfigureOnDemand(this.cbConfigureOnDemand.isSelected());
        settings.setUseConfigCache(this.cbUseConfigCache.isSelected());
        settings.setSkipCheck(this.cbSkipCheck.isSelected());
        settings.setSkipTest(this.cbSkipTest.isSelected());
        settings.setHideEmptyConfigurations(this.cbHideEmptyConfig.isSelected());
        settings.setAlwaysShowOutput(this.cbAlwaysShowOutput.isSelected());
        settings.setReuseOutputTabs(this.cbReuseOutputTabs.isSelected());
        settings.setDisplayDescription(this.cbDisplayDescription.isSelected());
        settings.setReuseEditorOnStackTrace(this.cbReuseEditorOnStackTrace.isSelected());
        experimental.setCacheDisabled(!this.cbEnableCache.isSelected());
        experimental.setOpenLazy(this.cbOpenLazy.isSelected());
        experimental.setBundledLoading(this.cbBundledLoading.isSelected());
        settings.setDownloadLibs((GradleSettings.DownloadLibsRule)((Object)this.cbDownloadLibs.getSelectedItem()));
        settings.setDownloadSources((GradleSettings.DownloadMiscRule)((Object)this.cbDownloadSources.getSelectedItem()));
        settings.setDownloadJavadoc((GradleSettings.DownloadMiscRule)((Object)this.cbDownloadJavadoc.getSelectedItem()));
        settings.setGradleExecutionRule((GradleSettings.GradleExecutionRule)((Object)this.cbAllowExecution.getSelectedItem()));
        if (settings.isPreferMaven() != this.cbPreferMaven.isSelected()) {
            settings.setPreferMaven(this.cbPreferMaven.isSelected());
            NotificationDisplayer.getDefault().notify(Bundle.TIT_RestartIDE(), (Icon)ImageUtilities.loadImageIcon((String)RESTART_ICON, (boolean)true), Bundle.HINT_RestartIDE(), e -> {
                LifecycleManager.getDefault().markForRestart();
                LifecycleManager.getDefault().exit();
            });
        }
        experimental.setNetworkProxy((NetworkProxySettings)((Object)this.cbNetworkProxy.getSelectedItem()));
    }

    public boolean hasChanges() {
        GradleSettings settings = GradleSettings.getDefault();
        GradleExperimentalSettings experimental = GradleExperimentalSettings.getDefault();
        boolean isChanged = !settings.getDistributionHome().equals(this.tfUseCustomGradle.getText());
        isChanged |= settings.isWrapperPreferred() != this.cbPreferWrapper.isSelected();
        isChanged |= !settings.getGradleVersion().equals(String.valueOf(this.cbGradleVersion.getSelectedItem()));
        boolean useCustomGradle = this.bgUsedDistribution.getSelection() == this.rbUseCustomGradle.getModel();
        isChanged |= settings.useCustomGradle() != useCustomGradle;
        isChanged |= settings.isStartDaemonOnStart() != this.cbStartDaemonOnStart.isSelected();
        isChanged |= settings.isSilentInstall() != this.cbSilentInstall.isSelected();
        isChanged |= settings.isOffline() != this.cbOffline.isSelected();
        isChanged |= settings.isConfigureOnDemand() != this.cbConfigureOnDemand.isSelected();
        isChanged |= settings.getUseConfigCache() != this.cbUseConfigCache.isSelected();
        isChanged |= settings.skipCheck() != this.cbSkipCheck.isSelected();
        isChanged |= settings.skipTest() != this.cbSkipTest.isSelected();
        isChanged |= settings.isDisplayDesctiption() != this.cbDisplayDescription.isSelected();
        isChanged |= settings.isHideEmptyConfigurations() != this.cbHideEmptyConfig.isSelected();
        isChanged |= settings.isAlwaysShowOutput() != this.cbAlwaysShowOutput.isSelected();
        isChanged |= settings.isReuseOutputTabs() != this.cbReuseOutputTabs.isSelected();
        isChanged |= settings.isReuseEditorOnStackTace() != this.cbReuseEditorOnStackTrace.isSelected();
        isChanged |= experimental.isCacheDisabled() == this.cbEnableCache.isSelected();
        isChanged |= experimental.isOpenLazy() != this.cbOpenLazy.isSelected();
        isChanged |= experimental.isBundledLoading() != this.cbBundledLoading.isSelected();
        isChanged |= settings.isPreferMaven() != this.cbPreferMaven.isSelected();
        isChanged |= settings.getDownloadLibs() != this.cbDownloadLibs.getSelectedItem();
        isChanged |= settings.getDownloadSources() != this.cbDownloadSources.getSelectedItem();
        isChanged |= settings.getDownloadJavadoc() != this.cbDownloadJavadoc.getSelectedItem();
        isChanged |= settings.getGradleExecutionRule() != this.cbAllowExecution.getSelectedItem();
        return isChanged |= experimental.getNetworkProxy() != this.cbNetworkProxy.getSelectedItem();
    }

    private static String getDefaultGradleUserHome() {
        String dir = System.getenv("GRADLE_USER_HOME");
        return dir != null ? dir : new File(System.getProperty("user.home"), ".gradle").getAbsolutePath();
    }

    private class VersionCellRenderer
    extends DefaultListCellRenderer {
        final Color blackListColor = UIManager.getColor("nb.errorForeground");
        final Color unavailableColor = UIManager.getColor("Label.disabledForeground");
        final ListCellRenderer delegate;

        public VersionCellRenderer(ListCellRenderer delegate) {
            this.delegate = delegate;
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component cmp = this.delegate.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (cmp instanceof JLabel) {
                JLabel label = (JLabel)cmp;
                label.setHorizontalAlignment(4);
                if (value instanceof GradleDistributionManager.GradleDistribution) {
                    GradleDistributionManager.GradleDistribution dist = (GradleDistributionManager.GradleDistribution)value;
                    label.setText(dist.getVersion());
                    if (!dist.isAvailable()) {
                        label.setToolTipText(Bundle.NbGradleVersion_autoInstall_TXT());
                        label.setForeground(this.unavailableColor);
                    }
                    if (dist.isBlackListed()) {
                        label.setToolTipText(Bundle.NbGradleVersion_blacklist_TXT());
                        label.setForeground(this.blackListColor);
                    }
                }
            }
            return cmp;
        }
    }
}

