/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.api.execute;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.gradle.util.GradleVersion;
import org.gradle.wrapper.IDownload;
import org.gradle.wrapper.Install;
import org.gradle.wrapper.Logger;
import org.gradle.wrapper.PathAssembler;
import org.gradle.wrapper.WrapperConfiguration;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.api.execute.Bundle;
import org.netbeans.modules.gradle.spi.GradleSettings;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public final class GradleDistributionManager {
    private static final RequestProcessor RP = new RequestProcessor("Gradle Installer", 1);
    private static final String DOWNLOAD_URI = "https://services.gradle.org/distributions/gradle-%s-%s.zip";
    private static final Pattern DIST_VERSION_PATTERN = Pattern.compile(".*(gradle-(\\d+\\.\\d+.*))-(bin|all)\\.zip");
    private static final Set<String> VERSION_BLACKLIST = new HashSet<String>(Arrays.asList("2.3", "2.13"));
    private static final Map<File, GradleDistributionManager> CACHE = new WeakHashMap<File, GradleDistributionManager>();
    private static final GradleVersion MINIMUM_SUPPORTED_VERSION = GradleVersion.version((String)"2.0");
    private static final GradleVersion[] JDK_COMPAT = new GradleVersion[]{GradleVersion.version((String)"4.2.1"), GradleVersion.version((String)"4.7"), GradleVersion.version((String)"4.10.2"), GradleVersion.version((String)"5.4"), GradleVersion.version((String)"6.0"), GradleVersion.version((String)"6.3"), GradleVersion.version((String)"6.7"), GradleVersion.version((String)"7.0"), GradleVersion.version((String)"7.3"), GradleVersion.version((String)"7.5")};
    private static final int JAVA_VERSION;
    final File gradleUserHome;

    private GradleDistributionManager(File gradleUserHome) {
        this.gradleUserHome = gradleUserHome;
    }

    public static GradleDistributionManager get(File gradleUserHome) {
        File home = gradleUserHome != null ? gradleUserHome : GradleSettings.getDefault().getGradleUserHome();
        GradleDistributionManager ret = CACHE.get(home);
        if (ret == null) {
            ret = new GradleDistributionManager(home);
            CACHE.put(home, ret);
        }
        return ret;
    }

    public static GradleDistributionManager get() {
        return GradleDistributionManager.get(null);
    }

    public GradleDistribution distributionFromDir(File distDir) throws IOException {
        File lib = new File(distDir, "lib");
        File[] gradleLauncher = lib.listFiles((dir, name) -> name.startsWith("gradle-launcher-") && name.endsWith(".jar"));
        if (gradleLauncher == null || gradleLauncher.length != 1) {
            throw new FileNotFoundException(lib.getAbsolutePath() + "lib/gradle-launcher-xxxx.jar not found or ambigous!");
        }
        JarFile launcherJar = new JarFile(gradleLauncher[0]);
        String version = launcherJar.getManifest().getMainAttributes().getValue("Implementation-Version");
        return new GradleDistribution(distDir, null, version);
    }

    public GradleDistribution distributionFromVersion(String version, boolean withSources) {
        try {
            URI uri = new URI(String.format(DOWNLOAD_URI, version, withSources ? "all" : "bin"));
            return new GradleDistribution(this.distributionBaseDir(uri, version), uri, version);
        }
        catch (URISyntaxException ex) {
            return null;
        }
    }

    public GradleDistribution distributionFromVersion(String version) {
        return this.distributionFromVersion(version, false);
    }

    public GradleDistribution distributionFromWrapper(File gradleProjectRoot) throws IOException, URISyntaxException {
        URI uri = GradleDistributionManager.getWrapperDistributionURI(gradleProjectRoot);
        Matcher m = DIST_VERSION_PATTERN.matcher(uri.getPath());
        if (m.matches()) {
            String version = m.group(2);
            return new GradleDistribution(this.distributionBaseDir(uri, version), uri, version);
        }
        throw new URISyntaxException(uri.getPath(), "Cannot get the Gradle distribution version from the URI");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static URI getWrapperDistributionURI(File rootDir) throws IOException, URISyntaxException {
        File wrapperProps = new File(rootDir, "gradle/wrapper/gradle-wrapper.properties");
        if (!wrapperProps.isFile()) throw new FileNotFoundException("Gradle Wrapper properties not found at: " + wrapperProps.getAbsolutePath());
        if (!wrapperProps.canRead()) throw new FileNotFoundException("Gradle Wrapper properties not found at: " + wrapperProps.getAbsolutePath());
        Properties wrapper = new Properties();
        try (FileInputStream is = new FileInputStream(wrapperProps);){
            wrapper.load(is);
        }
        String distUrlProp = wrapper.getProperty("distributionUrl");
        if (distUrlProp == null) throw new URISyntaxException("", "No distributionUrl property found in: " + wrapperProps.getAbsolutePath());
        URI ret = new URI(distUrlProp);
        if (ret.getScheme() != null) return ret;
        return wrapperProps.getParentFile().toPath().resolve(distUrlProp).normalize().toUri();
    }

    public GradleDistribution defaultDistribution() {
        return this.distributionFromVersion(GradleVersion.current().getVersion());
    }

    public List<GradleDistribution> availableDistributions(boolean releaseOnly) throws IOException {
        ArrayList<GradleDistribution> ret = new ArrayList<GradleDistribution>();
        JSONParser parser = new JSONParser();
        try {
            URL allVersions = new URL("https://services.gradle.org/versions/all");
            try (InputStreamReader is2 = new InputStreamReader(allVersions.openStream(), StandardCharsets.UTF_8);){
                JSONArray versions = (JSONArray)parser.parse((Reader)is2);
                for (Object o : versions) {
                    JSONObject v = (JSONObject)o;
                    URI downloadURL = new URI((String)v.get((Object)"downloadUrl"));
                    boolean snapshot = (Boolean)v.get((Object)"snapshot");
                    boolean nightly = (Boolean)v.get((Object)"nightly");
                    boolean broken = (Boolean)v.get((Object)"broken");
                    String version = (String)v.get((Object)"version");
                    String rcFor = (String)v.get((Object)"rcFor");
                    if (nightly || broken || snapshot || !rcFor.isEmpty() && releaseOnly || GradleVersion.version((String)version).compareTo(MINIMUM_SUPPORTED_VERSION) < 0) continue;
                    ret.add(new GradleDistribution(this.distributionBaseDir(downloadURL, version), downloadURL, version));
                }
            }
            catch (URISyntaxException | ParseException is2) {
            }
            catch (IOException iex) {
                throw iex;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return ret;
    }

    public List<GradleDistribution> availableLocalDistributions() {
        final ArrayList<GradleDistribution> ret = new ArrayList<GradleDistribution>();
        Path dists = this.gradleUserHome.toPath().resolve("wrapper").resolve("dists");
        if (Files.isDirectory(dists, new LinkOption[0])) {
            try {
                Files.walkFileTree(dists, EnumSet.noneOf(FileVisitOption.class), 2, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path f, BasicFileAttributes attrs) throws IOException {
                        Path dist;
                        String fname = f.getFileName().toString();
                        Matcher m = DIST_VERSION_PATTERN.matcher(fname);
                        if (m.matches() && Files.isDirectory(dist = f.resolveSibling(m.group(1)), new LinkOption[0])) {
                            try {
                                GradleDistribution d = GradleDistributionManager.this.distributionFromDir(dist.toFile());
                                if (GradleVersion.version((String)d.getVersion()).compareTo(MINIMUM_SUPPORTED_VERSION) >= 0) {
                                    ret.add(d);
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return ret;
    }

    File distributionBaseDir(URI downloadLocation, String version) {
        WrapperConfiguration conf = new WrapperConfiguration();
        conf.setDistribution(downloadLocation);
        PathAssembler pa = new PathAssembler(this.gradleUserHome, null);
        PathAssembler.LocalDistribution dist = pa.getDistribution(conf);
        return new File(dist.getDistributionDir(), "gradle-" + version);
    }

    static {
        int ver = 8;
        String version = System.getProperty("java.specification.version", System.getProperty("java.version"));
        try {
            int dot = version.indexOf(46);
            int n = ver = dot > 0 ? Integer.parseInt(version.substring(0, dot)) : Integer.parseInt(version);
            if (ver == 1) {
                ver = (dot = (version = version.substring(dot + 1)).indexOf(46)) > 0 ? Integer.parseInt(version.substring(0, dot)) : Integer.parseInt(version);
            }
        }
        catch (NumberFormatException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        JAVA_VERSION = ver;
    }

    private class DownloadTask
    implements Callable<Void>,
    IDownload {
        private final GradleDistribution dist;
        private final ProgressHandle handle;
        private final Notification notification;

        public DownloadTask(GradleDistribution dist) {
            this.dist = dist;
            this.handle = ProgressHandle.createSystemHandle((String)Bundle.TIT_Download_Gradle(dist.getVersion()), null);
            this.notification = NotificationDisplayer.getDefault().notify(Bundle.TIT_Download_Gradle(dist.getVersion()), (Icon)NbGradleProject.getIcon(), Bundle.MSG_Download_Gradle(dist.getVersion()), null, NotificationDisplayer.Priority.NORMAL, NotificationDisplayer.Category.INFO);
        }

        @Override
        public Void call() throws Exception {
            try {
                WrapperConfiguration conf = new WrapperConfiguration();
                conf.setDistribution(this.dist.getDistributionURI());
                PathAssembler pa = new PathAssembler(GradleDistributionManager.this.gradleUserHome, null);
                Install install = new Install(new Logger(true), (IDownload)this, pa);
                install.createDist(conf);
            }
            catch (Exception ex) {
                NotificationDisplayer.getDefault().notify(Bundle.TIT_Install_Gradle_Failed(this.dist.getVersion()), NbGradleProject.getWarningIcon(), ex.getLocalizedMessage(), null, NotificationDisplayer.Priority.HIGH, NotificationDisplayer.Category.WARNING);
                throw ex;
            }
            finally {
                this.handle.finish();
                this.notification.clear();
            }
            return null;
        }

        public void download(URI uri, File file) throws Exception {
            URL url = uri.toURL();
            URLConnection conn = url.openConnection();
            byte[] buf = new byte[8192];
            try (FileOutputStream os = new FileOutputStream(file);){
                int read;
                conn.connect();
                int size = conn.getContentLength();
                if (size > 0) {
                    this.handle.start(size);
                } else {
                    this.handle.start();
                }
                int allRead = 0;
                InputStream is = url.openStream();
                while ((read = is.read(buf)) > 0) {
                    os.write(buf, 0, read);
                    allRead += read;
                    if (size <= 0) continue;
                    this.handle.progress(allRead);
                }
            }
        }
    }

    public final class GradleDistribution
    implements Comparable<GradleDistribution> {
        final File distributionDir;
        final URI distributionURI;
        final GradleVersion version;

        private GradleDistribution(File distributionDir, URI distributionURL, String version) {
            this.distributionDir = distributionDir;
            this.distributionURI = distributionURL;
            this.version = GradleVersion.version((String)version);
        }

        public File getGradleUserHome() {
            return GradleDistributionManager.this.gradleUserHome;
        }

        public File getDistributionDir() {
            return this.distributionDir;
        }

        public URI getDistributionURI() {
            return this.distributionURI;
        }

        public String getVersion() {
            return this.version.getVersion();
        }

        public boolean isCompatibleWithJava(int jdkMajorVersion) {
            return jdkMajorVersion <= this.lastSupportedJava();
        }

        public int lastSupportedJava() {
            int i;
            for (i = JDK_COMPAT.length - 1; i >= 0 && this.version.compareTo(JDK_COMPAT[i]) < 0; --i) {
            }
            return i + 9;
        }

        public boolean isCompatibleWithSystemJava() {
            return this.isCompatibleWithJava(JAVA_VERSION);
        }

        public boolean isAvailable() {
            return this.distributionDir.isDirectory();
        }

        public boolean isBlackListed() {
            return VERSION_BLACKLIST.contains(this.version.getVersion());
        }

        public Future<Void> install() {
            return this.isAvailable() ? null : RP.schedule((Callable)new DownloadTask(this), 500L, TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(GradleDistribution o) {
            return this.version.compareTo(o.version);
        }

        public int hashCode() {
            int hash = 7;
            hash = 97 * hash + Objects.hashCode(this.distributionDir);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GradleDistribution other = (GradleDistribution)obj;
            return Objects.equals(this.distributionDir, other.distributionDir);
        }

        public String toString() {
            return "GradleDistribution{gradleUserHome=" + GradleDistributionManager.this.gradleUserHome + ", distributionDir=" + this.distributionDir + ", distributionURI=" + this.distributionURI + ", version=" + this.version + '}';
        }
    }

    static final class GradleVersionRange {
        public final GradleVersion lowerBound;
        public final GradleVersion upperBound;
        public static final GradleVersionRange UNBOUNDED = new GradleVersionRange(null, null);

        GradleVersionRange(GradleVersion lowerBound, GradleVersion upperBound) {
            if (lowerBound != null && upperBound != null && lowerBound.compareTo(upperBound) >= 0) {
                throw new IllegalArgumentException("Invalid version range: [" + lowerBound + ", " + upperBound + ")");
            }
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
        }

        public boolean contains(GradleVersion ver) {
            return !(this.lowerBound != null && this.lowerBound.compareTo(ver) > 0 || this.upperBound != null && this.upperBound.compareTo(ver) <= 0);
        }

        public boolean contains(String ver) {
            return this.contains(GradleVersion.version((String)ver));
        }

        public static GradleVersionRange from(GradleVersion lowerBound) {
            return new GradleVersionRange(lowerBound, null);
        }

        public static GradleVersionRange from(String lowerBound) {
            return GradleVersionRange.from(GradleVersion.version((String)lowerBound));
        }

        public static GradleVersionRange until(GradleVersion upperBound) {
            return new GradleVersionRange(null, upperBound);
        }

        public static GradleVersionRange until(String upperBound) {
            return GradleVersionRange.until(GradleVersion.version((String)upperBound));
        }

        public static GradleVersionRange range(GradleVersion lowerRange, GradleVersion upperRange) {
            return new GradleVersionRange(lowerRange, upperRange);
        }

        public static GradleVersionRange range(GradleVersion lowerRange, String upperRange) {
            return GradleVersionRange.range(lowerRange, GradleVersion.version((String)upperRange));
        }

        public static GradleVersionRange range(String lowerRange, GradleVersion upperRange) {
            return new GradleVersionRange(GradleVersion.version((String)lowerRange), upperRange);
        }

        public static GradleVersionRange range(String lowerRange, String upperRange) {
            return new GradleVersionRange(GradleVersion.version((String)lowerRange), GradleVersion.version((String)upperRange));
        }
    }
}

