/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.text.Document;
import org.netbeans.api.editor.document.EditorDocumentUtils;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.lsp.Diagnostic;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.GradleReport;
import org.netbeans.modules.gradle.editor.GradleHintsProvider;
import org.netbeans.spi.lsp.ErrorProvider;
import org.openide.filesystems.FileObject;

public class LspErrorProvider
implements ErrorProvider {
    public List<? extends Diagnostic> computeErrors(ErrorProvider.Context context) {
        FileObject fo = context.file();
        if (fo == null || !fo.getMIMEType(new String[]{"text/x-gradle+x-groovy"}).equals("text/x-gradle+x-groovy")) {
            return Collections.emptyList();
        }
        Project p = FileOwnerQuery.getOwner((FileObject)fo);
        if (p == null) {
            return Collections.emptyList();
        }
        GradleHintsProvider hintProv = (GradleHintsProvider)p.getLookup().lookup(GradleHintsProvider.class);
        if (hintProv == null) {
            return Collections.emptyList();
        }
        Map<LineDocument, List<GradleReport>> documentReports = hintProv.openReportDocuments(true);
        if (hintProv == null) {
            return Collections.emptyList();
        }
        ArrayList diags = new ArrayList();
        for (LineDocument doc : documentReports.keySet()) {
            FileObject f = EditorDocumentUtils.getFileObject((Document)doc);
            int[] idx = new int[]{1};
            doc.render(() -> {
                for (GradleReport r : (List)documentReports.get(doc)) {
                    int l = r.getLine();
                    if (l < 1) {
                        l = 1;
                    }
                    int start = LineDocumentUtils.getLineStartFromIndex((LineDocument)doc, (int)(l - 1));
                    int end = LineDocumentUtils.getLineStartFromIndex((LineDocument)doc, (int)l);
                    if (end < 0) {
                        end = doc.getLength() - 1;
                    }
                    int fEnd = end;
                    Diagnostic.Builder b = Diagnostic.Builder.create(() -> start, () -> fEnd, (String)r.formatReportForHintOrProblem(false, null));
                    int n = idx[0];
                    idx[0] = n + 1;
                    String id = "errors:" + n;
                    b.setCode(id);
                    b.setSeverity(Diagnostic.Severity.Error);
                    diags.add(b.build());
                }
            });
        }
        return diags;
    }
}

