/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.cache;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.gradle.tooling.model.GradleProject;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.gradle.GradleProjectStructure;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.cache.AbstractDiskCache;
import org.netbeans.modules.gradle.spi.GradleFiles;

public final class SubProjectDiskCache
extends AbstractDiskCache<File, SubProjectInfo> {
    private static final String SUBPROJECT_CACHE_FILE_NAME = ".gradle/nb-cache/subprojects.ser";
    private static final int COMPATIBLE_CACHE_VERSION = 2;
    private static final Map<File, SubProjectDiskCache> DISK_CACHES = new WeakHashMap<File, SubProjectDiskCache>();

    protected SubProjectDiskCache() {
    }

    private SubProjectDiskCache(File key) {
        super(key);
    }

    @Override
    protected int cacheVersion() {
        return 2;
    }

    @Override
    protected File cacheFile() {
        return new File((File)this.key, SUBPROJECT_CACHE_FILE_NAME);
    }

    @Override
    protected Set<File> cacheInvalidators() {
        return Collections.singleton(new GradleFiles((File)this.key).getSettingsScript());
    }

    public static SubProjectDiskCache get(File key) {
        SubProjectDiskCache ret = DISK_CACHES.get(key);
        if (ret == null) {
            ret = new SubProjectDiskCache(key);
            DISK_CACHES.put(key, ret);
        }
        return ret;
    }

    @Override
    protected boolean doStoreEntry(AbstractDiskCache.CacheEntry<SubProjectInfo> entry) {
        boolean ret = super.doStoreEntry(entry);
        ProjectManager.getDefault().clearNonProjectCache();
        return ret;
    }

    public static final class SubProjectInfo
    implements GradleProjectStructure,
    Serializable {
        public static final String ROOT_PATH = ":";
        private Map<String, String> path2Name;
        private Map<File, String> file2Path;
        private Map<String, File> path2File;
        private Map<String, String> path2Description;

        protected SubProjectInfo() {
        }

        public SubProjectInfo(GradleProject prj) {
            assert (prj.getParent() == null) : "This shall be called only on a root project!";
            if (prj.getChildren().isEmpty()) {
                this.path2Name = Collections.singletonMap(ROOT_PATH, prj.getName());
                this.file2Path = Collections.singletonMap(prj.getProjectDirectory(), ROOT_PATH);
                this.path2File = Collections.singletonMap(ROOT_PATH, prj.getProjectDirectory());
                this.path2Description = Collections.singletonMap(ROOT_PATH, prj.getDescription());
            } else {
                this.path2Name = new HashMap<String, String>();
                this.file2Path = new HashMap<File, String>();
                this.path2File = new HashMap<String, File>();
                this.path2Description = new HashMap<String, String>();
                this.path2Name.put(ROOT_PATH, prj.getName());
                this.file2Path.put(prj.getProjectDirectory(), ROOT_PATH);
                this.path2File.put(ROOT_PATH, prj.getProjectDirectory());
                if (prj.getDescription() != null) {
                    this.path2Description.put(ROOT_PATH, prj.getDescription());
                }
                for (GradleProject child : prj.getChildren()) {
                    this.processGradleProject(child);
                }
            }
        }

        private void processGradleProject(GradleProject prj) {
            String path = prj.getPath();
            this.path2Name.put(path, prj.getName());
            File dir = prj.getProjectDirectory();
            if (!dir.isAbsolute()) {
                dir = new File(prj.getProjectDirectory(), dir.toString());
            }
            this.file2Path.put(dir, path);
            this.path2File.put(path, dir);
            if (prj.getDescription() != null) {
                this.path2Description.put(path, prj.getDescription());
            }
            for (GradleProject child : prj.getChildren()) {
                this.processGradleProject(child);
            }
        }

        public SubProjectInfo(GradleBaseProject gbp) {
            assert (gbp.isRoot()) : "This shall be called only on a root project!";
            if (gbp.getSubProjects().isEmpty()) {
                this.path2Name = Collections.singletonMap(ROOT_PATH, gbp.getName());
                this.file2Path = Collections.singletonMap(gbp.getProjectDir(), ROOT_PATH);
                this.path2File = Collections.singletonMap(ROOT_PATH, gbp.getProjectDir());
                this.path2Description = Collections.singletonMap(ROOT_PATH, gbp.getDescription());
            } else {
                this.path2Name = new HashMap<String, String>();
                this.file2Path = new HashMap<File, String>();
                this.path2File = new HashMap<String, File>();
                this.path2Description = Collections.emptyMap();
                this.path2Name.put(ROOT_PATH, gbp.getName());
                this.file2Path.put(gbp.getProjectDir(), ROOT_PATH);
                this.path2File.put(ROOT_PATH, gbp.getProjectDir());
                for (Map.Entry<String, File> sprj : gbp.getSubProjects().entrySet()) {
                    this.file2Path.put(sprj.getValue(), sprj.getKey());
                    this.path2File.put(sprj.getKey(), sprj.getValue());
                    this.path2Name.put(sprj.getKey(), sprj.getKey());
                }
            }
        }

        public String getProjectName(String path) {
            return this.path2Name.get(path);
        }

        public String getProjectName(File dir) {
            String path = this.file2Path.get(dir);
            return path != null ? this.path2Name.get(path) : null;
        }

        public String getProjectDescription(String path) {
            return this.path2Description.get(path);
        }

        public String getProjectDescription(File dir) {
            String path = this.file2Path.get(dir);
            return path != null ? this.path2Description.get(path) : null;
        }

        public String getProjectPath(File dir) {
            return this.file2Path.get(dir);
        }

        public boolean isSubproject(File dir) {
            return this.file2Path.containsKey(dir);
        }

        @Override
        public Set<String> getProjectPaths() {
            return this.path2Name.keySet();
        }

        @Override
        public File getProjectDir(String path) {
            return this.path2File.get(path);
        }

        public String toString() {
            return "SubProjects of [" + this.path2Name.get(ROOT_PATH) + "]: " + this.file2Path.keySet();
        }
    }
}

