/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.execute.navigator;

import java.util.Collection;
import javax.swing.JComponent;
import org.netbeans.modules.gradle.execute.navigator.Bundle;
import org.netbeans.modules.gradle.execute.navigator.TasksPanel;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public class TasksNavigatorPanel
implements NavigatorPanel {
    private TasksPanel component;
    protected Lookup.Result<DataObject> selection;
    protected final LookupListener selectionListener = new LookupListener(){

        public void resultChanged(LookupEvent ev) {
            if (TasksNavigatorPanel.this.selection == null) {
                return;
            }
            TasksNavigatorPanel.this.navigate(TasksNavigatorPanel.this.selection.allInstances());
        }
    };

    public String getDisplayName() {
        return Bundle.TASKS_NAME();
    }

    public String getDisplayHint() {
        return Bundle.TASKS_HINT();
    }

    public JComponent getComponent() {
        return this.getNavigatorUI();
    }

    private TasksPanel getNavigatorUI() {
        if (this.component == null) {
            this.component = new TasksPanel();
        }
        return this.component;
    }

    public void panelActivated(Lookup context) {
        this.selection = context.lookupResult(DataObject.class);
        this.selection.addLookupListener(this.selectionListener);
        this.selectionListener.resultChanged(null);
    }

    public void panelDeactivated() {
        if (this.selection != null) {
            this.selection.removeLookupListener(this.selectionListener);
            this.selection = null;
        }
        this.getNavigatorUI().release();
    }

    public Lookup getLookup() {
        return null;
    }

    public void navigate(Collection<? extends DataObject> selectedFiles) {
        if (selectedFiles.size() == 1) {
            DataObject d = selectedFiles.iterator().next();
            this.getNavigatorUI().navigate(d);
        } else {
            this.getNavigatorUI().release();
        }
    }
}

