/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.cache;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.netbeans.modules.gradle.GradleProjectCache;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.api.NbProjectInfo;
import org.netbeans.modules.gradle.cache.AbstractDiskCache;
import org.netbeans.modules.gradle.spi.GradleFiles;

public final class ProjectInfoDiskCache
extends AbstractDiskCache<GradleFiles, QualifiedProjectInfo> {
    private static final int COMPATIBLE_CACHE_VERSION = 18;
    private static final String INFO_CACHE_FILE_NAME = "project-info.ser";

    public ProjectInfoDiskCache(GradleFiles gf) {
        super(gf);
    }

    @Override
    protected int cacheVersion() {
        return 18;
    }

    @Override
    protected File cacheFile() {
        return new File(GradleProjectCache.getCacheDir((GradleFiles)this.key), INFO_CACHE_FILE_NAME);
    }

    @Override
    protected Set<File> cacheInvalidators() {
        HashSet<File> ret = new HashSet<File>(((GradleFiles)this.key).getProjectFiles());
        if (((GradleFiles)this.key).hasWrapper()) {
            ret.add(((GradleFiles)this.key).getWrapperProperties());
        }
        return ret;
    }

    public static final class QualifiedProjectInfo
    implements NbProjectInfo {
        private final NbGradleProject.Quality quality;
        private final Map<String, Object> info;
        private final transient Map<String, Object> ext;
        private final Set<String> problems;
        private final String gradleException;

        public QualifiedProjectInfo(NbGradleProject.Quality quality, NbProjectInfo pinfo) {
            this.quality = quality;
            this.info = new TreeMap<String, Object>(pinfo.getInfo());
            this.ext = new TreeMap<String, Object>(pinfo.getExt());
            this.problems = new LinkedHashSet<String>(pinfo.getProblems());
            this.gradleException = pinfo.getGradleException();
        }

        public Map<String, Object> getInfo() {
            return this.info;
        }

        public Map<String, Object> getExt() {
            return this.ext != null ? this.ext : Collections.emptyMap();
        }

        public Set<String> getProblems() {
            return this.problems;
        }

        public String getGradleException() {
            return this.gradleException;
        }

        public boolean hasException() {
            return this.gradleException != null;
        }

        public boolean getMiscOnly() {
            return false;
        }

        public NbGradleProject.Quality getQuality() {
            return this.quality;
        }

        public String toString() {
            return "QualifiedProjectInfo{quality=" + (Object)((Object)this.quality) + '}';
        }
    }
}

