/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.Bundle;
import org.netbeans.modules.gradle.GradleProject;
import org.netbeans.modules.gradle.GradleProjectCache;
import org.netbeans.modules.gradle.NbGradleProjectImpl;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.api.execute.RunUtils;
import org.netbeans.spi.project.ui.ProjectProblemResolver;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.openide.util.RequestProcessor;

public class GradleProjectProblemProvider
implements ProjectProblemsProvider {
    static final RequestProcessor GRADLE_RESOLVER_RP = new RequestProcessor("gradle-project-resolver", 1);
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private final Project project;
    private PropertyChangeListener listener;
    private final ProjectProblemResolver resolver = new GradleProjectProblemResolver();

    public GradleProjectProblemProvider(Project project) {
        this.project = project;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends ProjectProblemsProvider.ProjectProblem> getProblems() {
        ArrayList<ProjectProblemsProvider.ProjectProblem> ret = new ArrayList<ProjectProblemsProvider.ProjectProblem>();
        GradleProjectProblemProvider gradleProjectProblemProvider = this;
        synchronized (gradleProjectProblemProvider) {
            if (this.listener == null) {
                this.listener = evt -> {
                    if ("ProjectInfo".equals(evt.getPropertyName())) {
                        this.support.firePropertyChange("problems", null, null);
                    }
                };
                NbGradleProject.addPropertyChangeListener(this.project, this.listener);
            }
        }
        GradleProject gp = ((NbGradleProjectImpl)this.project.getLookup().lookup(NbGradleProjectImpl.class)).getGradleProject();
        if (gp.getQuality().notBetterThan(NbGradleProject.Quality.EVALUATED)) {
            ret.add(ProjectProblemsProvider.ProjectProblem.createError((String)Bundle.LBL_PrimingRequired(), (String)Bundle.TXT_PrimingRequired(), (ProjectProblemResolver)this.resolver));
        }
        for (String problem : gp.getProblems()) {
            String[] lines = problem.split("\\n");
            ret.add(ProjectProblemsProvider.ProjectProblem.createWarning((String)lines[0], (String)problem.replaceAll("\\n", "<br/>"), (ProjectProblemResolver)this.resolver));
        }
        if (RunUtils.getActivePlatform(this.project) == null) {
            ret.add(ProjectProblemsProvider.ProjectProblem.createWarning((String)Bundle.LBL_BrokenPlatform(), (String)Bundle.LBL_BrokenPlatform()));
        }
        return ret;
    }

    private class GradleProjectProblemResolver
    implements ProjectProblemResolver,
    Callable<ProjectProblemsProvider.Result> {
        private GradleProjectProblemResolver() {
        }

        public Future<ProjectProblemsProvider.Result> resolve() {
            return GRADLE_RESOLVER_RP.submit((Callable)this);
        }

        @Override
        public ProjectProblemsProvider.Result call() throws Exception {
            NbGradleProjectImpl impl = (NbGradleProjectImpl)GradleProjectProblemProvider.this.project.getLookup().lookup(NbGradleProjectImpl.class);
            GradleProject gradleProject = GradleProjectCache.loadProject(impl, NbGradleProject.Quality.FULL_ONLINE, true, true, new String[0]);
            impl.fireProjectReload(false);
            NbGradleProject.Quality q = gradleProject.getQuality();
            ProjectProblemsProvider.Status st = q.worseThan(NbGradleProject.Quality.SIMPLE) ? ProjectProblemsProvider.Status.UNRESOLVED : (q.worseThan(NbGradleProject.Quality.FULL) ? ProjectProblemsProvider.Status.RESOLVED_WITH_WARNING : ProjectProblemsProvider.Status.RESOLVED);
            return ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)st);
        }
    }
}

