/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.java.api.GradleJavaProject;
import org.netbeans.modules.gradle.java.api.GradleJavaSourceSet;
import org.netbeans.spi.java.queries.SourceLevelQueryImplementation2;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.WeakListeners;

public class GradleSourceLevelImpl
implements SourceLevelQueryImplementation2 {
    final Project project;
    final Map<FileObject, SourceLevelQueryImplementation2.Result2> cache = new WeakHashMap<FileObject, SourceLevelQueryImplementation2.Result2>();

    public GradleSourceLevelImpl(Project project) {
        this.project = project;
    }

    SourceLevelQuery.Profile getSourceProfile(FileObject javaFile) {
        return SourceLevelQuery.Profile.DEFAULT;
    }

    String getSourceLevelString(FileObject javaFile) {
        String ret = null;
        GradleJavaProject gjp = GradleJavaProject.get(this.project);
        if (gjp != null) {
            GradleJavaSourceSet sourceSet = gjp.containingSourceSet(FileUtil.toFile((FileObject)javaFile));
            ret = sourceSet != null ? sourceSet.getSourcesCompatibility() : null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceLevelQueryImplementation2.Result getSourceLevel(FileObject javaFile) {
        Map<FileObject, SourceLevelQueryImplementation2.Result2> map = this.cache;
        synchronized (map) {
            SourceLevelQueryImplementation2.Result2 ret = this.cache.get(javaFile);
            if (ret == null) {
                ret = new ResultImpl(javaFile);
                this.cache.put(javaFile, ret);
            }
            return ret;
        }
    }

    private class ResultImpl
    implements SourceLevelQueryImplementation2.Result2,
    PropertyChangeListener {
        private final FileObject javaFile;
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private final PropertyChangeListener pcl;
        private String cachedLevel;
        private SourceLevelQuery.Profile cachedProfile;
        private final Object CACHE_LOCK;

        ResultImpl(FileObject javaFile) {
            this.pcl = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)NbGradleProject.get((Project)GradleSourceLevelImpl.this.project));
            this.cachedLevel = null;
            this.CACHE_LOCK = new Object();
            this.javaFile = javaFile;
            NbGradleProject.addPropertyChangeListener((Project)GradleSourceLevelImpl.this.project, (PropertyChangeListener)this.pcl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getSourceLevel() {
            Object object = this.CACHE_LOCK;
            synchronized (object) {
                if (this.cachedLevel == null) {
                    this.cachedLevel = GradleSourceLevelImpl.this.getSourceLevelString(this.javaFile);
                }
                return this.cachedLevel;
            }
        }

        public void addChangeListener(ChangeListener listener) {
            this.cs.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.cs.removeChangeListener(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("ProjectInfo".equals(evt.getPropertyName())) {
                Project p = (Project)evt.getSource();
                if (((NbGradleProject)p.getLookup().lookup(NbGradleProject.class)).isUnloadable()) {
                    return;
                }
                Object object = this.CACHE_LOCK;
                synchronized (object) {
                    this.cachedLevel = null;
                    this.cachedProfile = null;
                }
                this.cs.fireChange();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SourceLevelQuery.Profile getProfile() {
            Object object = this.CACHE_LOCK;
            synchronized (object) {
                if (this.cachedProfile == null) {
                    this.cachedProfile = GradleSourceLevelImpl.this.getSourceProfile(this.javaFile);
                }
                return this.cachedProfile;
            }
        }
    }
}

