/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.nodes;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.api.execute.RunUtils;
import org.netbeans.modules.gradle.java.api.ProjectSourcesClassPathProvider;
import org.netbeans.modules.gradle.java.nodes.Bundle;
import org.netbeans.modules.gradle.java.nodes.LibrariesSourceGroup;
import org.netbeans.modules.gradle.java.nodes.PathFinders;
import org.netbeans.modules.gradle.spi.nodes.AbstractGradleNodeList;
import org.netbeans.modules.gradle.spi.nodes.NodeUtils;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.PathFinder;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.xml.XMLUtil;

public class BootCPNodeFactory
implements NodeFactory {
    public static final String ENDORSED = "classpath/endorsed";
    private static final String LIBS_BADGE = "org/netbeans/modules/gradle/java/resources/libraries-badge.png";
    private static final String PLATFORM_ICON = "org/netbeans/modules/java/api/common/project/ui/resources/platform.gif";
    private static final String ARCHIVE_ICON = "org/netbeans/modules/java/api/common/project/ui/resources/jar.gif";
    private static final String MODULE_ICON = "org/netbeans/modules/java/api/common/project/ui/resources/module.png";

    public NodeList<?> createNodes(final Project p) {
        return new AbstractGradleNodeList<Void>(){

            public List<Void> keys() {
                return ProjectUtils.getSources((Project)p).getSourceGroups("java").length == 0 ? Collections.emptyList() : Collections.singletonList(null);
            }

            public Node node(Void key) {
                return new BootCPNode(new PlatformProvider(p, null));
            }
        };
    }

    private static Node jarNode(SourceGroup sg) {
        Node delegate = PackageView.createPackageView((SourceGroup)sg);
        PathFinder pathFinder = PathFinders.createDelegatingPathFinder((PathFinder)delegate.getLookup().lookup(PathFinder.class));
        ProxyLookup lkp = new ProxyLookup(new Lookup[]{Lookups.exclude((Lookup)delegate.getLookup(), (Class[])new Class[]{PathFinder.class}), Lookups.singleton((Object)pathFinder)});
        return new FilterNode(delegate, null, (Lookup)lkp){

            public Action[] getActions(boolean context) {
                return new Action[0];
            }
        };
    }

    private static final class PlatformProvider
    implements PropertyChangeListener,
    PreferenceChangeListener {
        private static final Pair<String, JavaPlatform> BUSY = Pair.of(null, null);
        private static final RequestProcessor RP = new RequestProcessor(PlatformProvider.class);
        private final Project project;
        private final ClassPath boot;
        private final AtomicReference<Pair<String, JavaPlatform>> platformCache = new AtomicReference();
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);

        public PlatformProvider(@NonNull Project project, @NonNull ClassPath boot) {
            this.project = project;
            this.boot = boot;
            JavaPlatformManager jps = JavaPlatformManager.getDefault();
            jps.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)jps));
            Preferences prefs = NbGradleProject.getPreferences((Project)project, (boolean)false);
            prefs.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this, (Object)prefs));
            NbGradleProject.addPropertyChangeListener((Project)project, (PropertyChangeListener)WeakListeners.propertyChange((PropertyChangeListener)this, (Object)project));
            if (this.boot != null) {
                this.boot.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.boot));
            }
        }

        @CheckForNull
        public Pair<String, JavaPlatform> getPlatform() {
            Pair<String, JavaPlatform> res;
            if (this.platformCache.compareAndSet(null, BUSY)) {
                RP.execute(new Runnable(){

                    @Override
                    public void run() {
                        platformCache.set(RunUtils.getActivePlatform((Project)project));
                        changeSupport.fireChange();
                    }
                });
            }
            return (res = this.platformCache.get()) == BUSY ? null : res;
        }

        @NonNull
        public FileObject[] getBootstrapLibraries() {
            Pair<String, JavaPlatform> jp = this.getPlatform();
            if (jp == null || jp.second() == null) {
                return new FileObject[0];
            }
            ClassPath cp = this.boot;
            if (cp == null) {
                cp = ((JavaPlatform)jp.second()).getBootstrapLibraries();
            }
            return cp.getRoots();
        }

        public void addChangeListener(ChangeListener l) {
            this.changeSupport.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.changeSupport.removeChangeListener(l);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if ("ProjectInfo".equals(propName) || "roots".equals(propName) || "installedPlatforms".equals(propName)) {
                this.platformCache.set(null);
                this.getPlatform();
            }
        }

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            String prefName = evt.getKey();
            if ("jdkPlatform".equals(prefName)) {
                this.platformCache.set(null);
                this.getPlatform();
            }
        }
    }

    private static class CPChildren
    extends Children.Keys<SourceGroup> {
        CPChildren() {
        }

        protected void addNotify() {
            this.setKeys(this.getKeys());
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
        }

        protected Node[] createNodes(SourceGroup sg) {
            Node[] nodeArray;
            Node afn = BootCPNodeFactory.jarNode(sg);
            if (afn == null) {
                nodeArray = new Node[]{};
            } else {
                Node[] nodeArray2 = new Node[1];
                nodeArray = nodeArray2;
                nodeArray2[0] = afn;
            }
            return nodeArray;
        }

        private List<SourceGroup> getKeys() {
            FileObject[] roots = ((JRENode)this.getNode()).pp.getBootstrapLibraries();
            if (roots.length == 0) {
                return Collections.emptyList();
            }
            ArrayList<SourceGroup> result = new ArrayList<SourceGroup>(roots.length);
            for (FileObject root : roots) {
                ImageIcon icon;
                ImageIcon openedIcon;
                FileObject file;
                switch (root.toURL().getProtocol()) {
                    case "jar": {
                        file = FileUtil.getArchiveFile((FileObject)root);
                        icon = openedIcon = ImageUtilities.loadImageIcon((String)BootCPNodeFactory.ARCHIVE_ICON, (boolean)false);
                        break;
                    }
                    case "nbjrt": {
                        file = root;
                        icon = openedIcon = ImageUtilities.loadImageIcon((String)BootCPNodeFactory.MODULE_ICON, (boolean)false);
                        break;
                    }
                    default: {
                        file = root;
                        openedIcon = null;
                        icon = null;
                    }
                }
                if (!file.isValid()) continue;
                result.add(new LibrariesSourceGroup(root, file.getNameExt(), icon, openedIcon));
            }
            return result;
        }
    }

    private static class JRENode
    extends AbstractNode
    implements ChangeListener {
        private final PlatformProvider pp;

        private JRENode(PlatformProvider pp) {
            super((Children)new CPChildren(), Lookups.singleton((Object)PathFinders.createPathFinder()));
            this.pp = pp;
            pp.addChangeListener(this);
            this.setIconBaseWithExtension(BootCPNodeFactory.PLATFORM_ICON);
        }

        public String getName() {
            return this.getDisplayName();
        }

        public String getDisplayName() {
            String platformId;
            Pair<String, JavaPlatform> platHolder = this.pp.getPlatform();
            if (platHolder == null) {
                return Bundle.TXT_UnknownPlatform();
            }
            JavaPlatform jp = (JavaPlatform)platHolder.second();
            String name = jp != null ? (jp.isValid() ? jp.getDisplayName() : Bundle.FMT_BrokenPlatform(jp.getDisplayName())) : ((platformId = (String)platHolder.first()) == null ? Bundle.TXT_BrokenPlatform() : Bundle.FMT_BrokenPlatform(platformId));
            return name;
        }

        public String getHtmlDisplayName() {
            Pair<String, JavaPlatform> platHolder = this.pp.getPlatform();
            if (platHolder == null) {
                return null;
            }
            JavaPlatform jp = (JavaPlatform)platHolder.second();
            if (jp == null || !jp.isValid()) {
                String displayName = this.getDisplayName();
                try {
                    displayName = XMLUtil.toElementContent((String)displayName);
                }
                catch (CharConversionException ex) {
                    return null;
                }
                return "<font color=\"#A40000\">" + displayName + "</font>";
            }
            return null;
        }

        public boolean canCopy() {
            return false;
        }

        public String getShortDescription() {
            Pair<String, JavaPlatform> platHolder = this.pp.getPlatform();
            if (platHolder != null && platHolder.second() != null && !((JavaPlatform)platHolder.second()).getInstallFolders().isEmpty()) {
                FileObject installFolder = (FileObject)((JavaPlatform)platHolder.second()).getInstallFolders().iterator().next();
                return FileUtil.getFileDisplayName((FileObject)installFolder);
            }
            return super.getShortDescription();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.fireNameChange(null, null);
            this.fireDisplayNameChange(null, null);
            ((CPChildren)this.getChildren()).addNotify();
        }
    }

    private static class BootCPChildren
    extends ChildFactory.Detachable<FileObject>
    implements ChangeListener,
    PropertyChangeListener {
        private final PlatformProvider pp;
        private ClassPath[] endorsed;
        private static final FileObject BOOT = FileUtil.createMemoryFileSystem().getRoot();

        BootCPChildren(PlatformProvider pp) {
            this.pp = pp;
        }

        protected void addNotify() {
            this.pp.addChangeListener(this);
            for (ClassPath cp : this.endorsed = ((ProjectSourcesClassPathProvider)this.pp.project.getLookup().lookup(ProjectSourcesClassPathProvider.class)).getProjectClassPath(BootCPNodeFactory.ENDORSED)) {
                cp.addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        protected void removeNotify() {
            this.pp.removeChangeListener(this);
            for (ClassPath cp : this.endorsed) {
                cp.removePropertyChangeListener((PropertyChangeListener)this);
            }
            this.endorsed = null;
        }

        protected boolean createKeys(List<FileObject> roots) {
            roots.add(BOOT);
            for (ClassPath cp : this.endorsed) {
                roots.addAll(Arrays.asList(cp.getRoots()));
            }
            return true;
        }

        protected Node createNodeForKey(FileObject root) {
            return root == BOOT ? new JRENode(this.pp) : BootCPNodeFactory.jarNode(new LibrariesSourceGroup(root, root.getNameExt()));
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("roots")) {
                this.refresh(false);
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.refresh(false);
        }
    }

    private static class BootCPNode
    extends AbstractNode {
        BootCPNode(PlatformProvider pp) {
            super(Children.create((ChildFactory)new BootCPChildren(pp), (boolean)false), Lookups.singleton((Object)PathFinders.createPathFinder()));
            this.setName("BootCPNode");
            this.setDisplayName(Bundle.BootCPNode_displayName());
        }

        public Image getIcon(int param) {
            return ImageUtilities.mergeImages((Image)NodeUtils.getTreeFolderIcon((boolean)false), (Image)ImageUtilities.loadImage((String)BootCPNodeFactory.LIBS_BADGE), (int)8, (int)8);
        }

        public Image getOpenedIcon(int param) {
            return ImageUtilities.mergeImages((Image)NodeUtils.getTreeFolderIcon((boolean)true), (Image)ImageUtilities.loadImage((String)BootCPNodeFactory.LIBS_BADGE), (int)8, (int)8);
        }
    }
}

