/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.queries;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.BinaryForSourceQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.java.api.GradleJavaProject;
import org.netbeans.modules.gradle.java.api.GradleJavaSourceSet;
import org.netbeans.spi.java.queries.BinaryForSourceQueryImplementation;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public class GradleBinaryForSource
implements BinaryForSourceQueryImplementation {
    private final Project project;
    private final Map<URL, Res> cache = new HashMap<URL, Res>();

    public GradleBinaryForSource(Project project) {
        this.project = project;
    }

    public BinaryForSourceQuery.Result findBinaryRoots(URL sourceRoot) {
        Res ret = this.cache.get(sourceRoot);
        if (ret == null && "file".equals(sourceRoot.getProtocol())) {
            try {
                File root = FileUtil.normalizeFile((File)Utilities.toFile((URI)sourceRoot.toURI()));
                GradleJavaProject prj = GradleJavaProject.get(this.project);
                for (GradleJavaSourceSet ss : prj.getSourceSets().values()) {
                    for (GradleJavaSourceSet.SourceType type : GradleJavaSourceSet.SourceType.values()) {
                        for (File sourceDir : ss.getSourceDirs(type)) {
                            if (!root.equals(sourceDir)) continue;
                            ret = new Res(this.project, ss.getName(), type == GradleJavaSourceSet.SourceType.RESOURCES);
                            this.cache.put(sourceRoot, ret);
                            return ret;
                        }
                    }
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return ret;
    }

    public static class Res
    implements BinaryForSourceQuery.Result {
        private final Project prj;
        private final String sourceSetName;
        private final boolean resource;

        public Res(Project prj, String sourceSetName, boolean resource) {
            this.prj = prj;
            this.sourceSetName = sourceSetName;
            this.resource = resource;
        }

        public URL[] getRoots() {
            GradleJavaSourceSet ss = GradleJavaProject.get(this.prj).getSourceSets().get(this.sourceSetName);
            if (ss == null) {
                return new URL[0];
            }
            ArrayList<URL> urls = new ArrayList<URL>(2);
            ArrayList<File> targets = new ArrayList<File>(2);
            if (this.resource) {
                if (ss.getOutputResources() != null) {
                    targets.add(ss.getOutputResources());
                }
            } else {
                targets.addAll(ss.getOutputClassDirs());
            }
            for (File target : targets) {
                if (!target.exists()) continue;
                urls.add(FileUtil.urlForArchiveOrDir((File)target));
            }
            return urls.toArray(new URL[urls.size()]);
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }
    }
}

