/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.extexecution.base;

import java.io.BufferedInputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.extexecution.base.BaseExecutionDescriptor;
import org.netbeans.api.extexecution.base.ParametrizedRunnable;
import org.netbeans.api.extexecution.base.input.InputProcessor;
import org.netbeans.api.extexecution.base.input.InputProcessors;
import org.netbeans.api.extexecution.base.input.InputReaderTask;
import org.netbeans.api.extexecution.base.input.InputReaders;
import org.netbeans.modules.extexecution.base.ProcessInputStream;
import org.openide.util.Cancellable;
import org.openide.util.RequestProcessor;

public final class BaseExecutionService {
    private static final Logger LOGGER = Logger.getLogger(BaseExecutionService.class.getName());
    private static final Set<Process> RUNNING_PROCESSES = new HashSet<Process>();
    private static final int EXECUTOR_SHUTDOWN_SLICE = 1000;
    private static final ExecutorService EXECUTOR_SERVICE = new RequestProcessor(BaseExecutionService.class.getName(), Integer.MAX_VALUE);
    private final Callable<? extends Process> processCreator;
    private final BaseExecutionDescriptor descriptor;

    private BaseExecutionService(Callable<? extends Process> processCreator, BaseExecutionDescriptor descriptor) {
        this.processCreator = processCreator;
        this.descriptor = descriptor;
    }

    @NonNull
    public static BaseExecutionService newService(@NonNull Callable<? extends Process> processCreator, @NonNull BaseExecutionDescriptor descriptor) {
        return new BaseExecutionService(processCreator, descriptor);
    }

    private static Charset getInputOutputEncoding() {
        String[] encodingSystemProperties = new String[]{"stdout.encoding", "sun.stdout.encoding", "native.encoding"};
        Charset preferredCharset = null;
        for (String encodingProperty : encodingSystemProperties) {
            String encodingPropertyValue = System.getProperty(encodingProperty);
            if (encodingPropertyValue == null) continue;
            try {
                preferredCharset = Charset.forName(encodingPropertyValue);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.log(Level.WARNING, "Failed to get charset for '" + encodingProperty + "' value : '" + encodingPropertyValue + "'", ex);
            }
            if (preferredCharset == null) continue;
            return preferredCharset;
        }
        return Charset.defaultCharset();
    }

    @NonNull
    public Future<Integer> run() {
        BaseExecutionDescriptor.ReaderFactory factory = this.descriptor.getInReaderFactory();
        final Reader in = factory != null ? factory.newReader() : null;
        final CountDownLatch finishedLatch = new CountDownLatch(1);
        Callable<Integer> callable = new Callable<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Integer call() throws Exception {
                Object pre;
                ArrayList<InputReaderTask> tasks;
                ProcessInputStream errStream;
                ProcessInputStream outStream;
                ExecutorService executor;
                Integer ret;
                Process process;
                boolean interrupted;
                block117: {
                    block115: {
                        interrupted = false;
                        process = null;
                        ret = null;
                        executor = null;
                        outStream = null;
                        errStream = null;
                        tasks = new ArrayList<InputReaderTask>();
                        pre = BaseExecutionService.this.descriptor.getPreExecution();
                        if (pre != null) {
                            pre.run();
                        }
                        if (!Thread.currentThread().isInterrupted()) break block115;
                        Integer n = null;
                        try {
                            if (!(interrupted |= Thread.interrupted())) {
                                if (outStream != null) {
                                    outStream.close(true);
                                }
                                if (errStream != null) {
                                    errStream.close(true);
                                }
                            }
                            if (process == null) return n;
                            process.destroy();
                            Set set = RUNNING_PROCESSES;
                            synchronized (set) {
                                RUNNING_PROCESSES.remove(process);
                            }
                            try {
                                ret = process.exitValue();
                                return n;
                            }
                            catch (IllegalThreadStateException ex) {
                                LOGGER.log(Level.FINE, "Process not yet exited", ex);
                            }
                            return n;
                        }
                        catch (Throwable t) {
                            LOGGER.log(Level.INFO, null, t);
                            throw new WrappedException(t);
                        }
                        finally {
                            try {
                                BaseExecutionService.this.cleanup(tasks, executor);
                                ParametrizedRunnable<Integer> post = BaseExecutionService.this.descriptor.getPostExecution();
                                if (post != null) {
                                    post.run(ret);
                                }
                            }
                            finally {
                                finishedLatch.countDown();
                                if (interrupted) {
                                    Thread.currentThread().interrupt();
                                }
                            }
                        }
                    }
                    process = (Process)BaseExecutionService.this.processCreator.call();
                    Set set = RUNNING_PROCESSES;
                    synchronized (set) {
                        RUNNING_PROCESSES.add(process);
                    }
                    if (!Thread.currentThread().isInterrupted()) break block117;
                    set = null;
                    try {
                        if (!(interrupted |= Thread.interrupted())) {
                            if (outStream != null) {
                                outStream.close(true);
                            }
                            if (errStream != null) {
                                errStream.close(true);
                            }
                        }
                        if (process == null) return set;
                        process.destroy();
                        Set t = RUNNING_PROCESSES;
                        synchronized (t) {
                            RUNNING_PROCESSES.remove(process);
                        }
                        try {
                            ret = process.exitValue();
                            return set;
                        }
                        catch (IllegalThreadStateException ex) {
                            LOGGER.log(Level.FINE, "Process not yet exited", ex);
                        }
                        return set;
                    }
                    catch (Throwable t) {
                        LOGGER.log(Level.INFO, null, t);
                        throw new WrappedException(t);
                    }
                    finally {
                        try {
                            BaseExecutionService.this.cleanup(tasks, executor);
                            ParametrizedRunnable<Integer> post = BaseExecutionService.this.descriptor.getPostExecution();
                            if (post != null) {
                                post.run(ret);
                            }
                        }
                        finally {
                            finishedLatch.countDown();
                            if (interrupted) {
                                Thread.currentThread().interrupt();
                            }
                        }
                    }
                }
                outStream = new ProcessInputStream(process, process.getInputStream());
                errStream = new ProcessInputStream(process, process.getErrorStream());
                executor = Executors.newFixedThreadPool(in != null ? 3 : 2);
                Charset charset = BaseExecutionService.this.descriptor.getCharset();
                if (charset == null) {
                    charset = BaseExecutionService.getInputOutputEncoding();
                }
                tasks.add(InputReaderTask.newDrainingTask(InputReaders.forStream(new BufferedInputStream(outStream), charset), BaseExecutionService.this.createOutProcessor()));
                tasks.add(InputReaderTask.newDrainingTask(InputReaders.forStream(new BufferedInputStream(errStream), charset), BaseExecutionService.this.createErrProcessor()));
                if (in != null) {
                    tasks.add(InputReaderTask.newTask(InputReaders.forReader(in), BaseExecutionService.this.createInProcessor(process.getOutputStream(), charset)));
                }
                for (InputReaderTask task : tasks) {
                    executor.submit(task);
                }
                process.waitFor();
                try {
                    if (!(interrupted |= Thread.interrupted())) {
                        if (outStream != null) {
                            outStream.close(true);
                        }
                        if (errStream != null) {
                            errStream.close(true);
                        }
                    }
                    if (process == null) return ret;
                    process.destroy();
                    pre = RUNNING_PROCESSES;
                    synchronized (pre) {
                        RUNNING_PROCESSES.remove(process);
                    }
                    try {
                        ret = process.exitValue();
                        return ret;
                    }
                    catch (IllegalThreadStateException ex) {
                        LOGGER.log(Level.FINE, "Process not yet exited", ex);
                    }
                    return ret;
                }
                catch (Throwable t) {
                    LOGGER.log(Level.INFO, null, t);
                    throw new WrappedException(t);
                }
                finally {
                    try {
                        BaseExecutionService.this.cleanup(tasks, executor);
                        ParametrizedRunnable<Integer> post = BaseExecutionService.this.descriptor.getPostExecution();
                        if (post != null) {
                            post.run(ret);
                        }
                    }
                    finally {
                        finishedLatch.countDown();
                        if (interrupted) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
                catch (InterruptedException ex2222222) {
                    block120: {
                        LOGGER.log(Level.FINE, null, ex2222222);
                        interrupted = true;
                        if (!(interrupted |= Thread.interrupted())) {
                            if (outStream != null) {
                                outStream.close(true);
                            }
                            if (errStream != null) {
                                errStream.close(true);
                            }
                        }
                        if (process == null) break block120;
                        process.destroy();
                        Set ex2222222 = RUNNING_PROCESSES;
                        synchronized (ex2222222) {
                            RUNNING_PROCESSES.remove(process);
                        }
                        try {
                            ret = process.exitValue();
                        }
                        catch (IllegalThreadStateException ex22222222) {
                            LOGGER.log(Level.FINE, "Process not yet exited", ex22222222);
                        }
                    }
                    try {
                        BaseExecutionService.this.cleanup(tasks, executor);
                        ParametrizedRunnable<Integer> post = BaseExecutionService.this.descriptor.getPostExecution();
                        if (post == null) return ret;
                        post.run(ret);
                        return ret;
                    }
                    finally {
                        finishedLatch.countDown();
                        if (interrupted) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    catch (Throwable t) {
                        try {
                            LOGGER.log(Level.INFO, null, t);
                            throw new WrappedException(t);
                        }
                        catch (Throwable throwable) {
                            try {
                                BaseExecutionService.this.cleanup(tasks, executor);
                                ParametrizedRunnable<Integer> post = BaseExecutionService.this.descriptor.getPostExecution();
                                if (post == null) throw throwable;
                                post.run(ret);
                                throw throwable;
                            }
                            finally {
                                finishedLatch.countDown();
                                if (interrupted) {
                                    Thread.currentThread().interrupt();
                                }
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    LOGGER.log(Level.INFO, null, t);
                    throw new WrappedException(t);
                    {
                        catch (Throwable throwable) {
                            try {
                                if (!(interrupted |= Thread.interrupted())) {
                                    if (outStream != null) {
                                        outStream.close(true);
                                    }
                                    if (errStream != null) {
                                        errStream.close(true);
                                    }
                                }
                                if (process == null) throw throwable;
                                process.destroy();
                                Set set = RUNNING_PROCESSES;
                                synchronized (set) {
                                    RUNNING_PROCESSES.remove(process);
                                }
                                try {
                                    ret = process.exitValue();
                                    throw throwable;
                                }
                                catch (IllegalThreadStateException ex) {
                                    LOGGER.log(Level.FINE, "Process not yet exited", ex);
                                }
                                throw throwable;
                            }
                            catch (Throwable t2) {
                                LOGGER.log(Level.INFO, null, t2);
                                throw new WrappedException(t2);
                            }
                            finally {
                                try {
                                    BaseExecutionService.this.cleanup(tasks, executor);
                                    ParametrizedRunnable<Integer> post = BaseExecutionService.this.descriptor.getPostExecution();
                                    if (post != null) {
                                        post.run(ret);
                                    }
                                }
                                finally {
                                    finishedLatch.countDown();
                                    if (interrupted) {
                                        Thread.currentThread().interrupt();
                                    }
                                }
                            }
                        }
                    }
                }
            }
        };
        FutureTask<Integer> current = new FutureTask<Integer>((Callable)callable){

            @Override
            protected void setException(Throwable t) {
                if (t instanceof WrappedException) {
                    super.setException(((WrappedException)t).getCause());
                } else {
                    super.setException(t);
                }
            }
        };
        EXECUTOR_SERVICE.execute(current);
        return current;
    }

    private void cleanup(List<InputReaderTask> tasks, final ExecutorService processingExecutor) {
        boolean interrupted = false;
        if (processingExecutor != null) {
            try {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        processingExecutor.shutdown();
                        return null;
                    }
                });
                for (Cancellable cancellable : tasks) {
                    cancellable.cancel();
                }
                while (!processingExecutor.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
                    LOGGER.log(Level.INFO, "Awaiting processing finish");
                }
            }
            catch (InterruptedException ex) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    private InputProcessor createOutProcessor() {
        InputProcessor outProcessor = null;
        BaseExecutionDescriptor.InputProcessorFactory descriptorOutFactory = this.descriptor.getOutProcessorFactory();
        if (descriptorOutFactory != null) {
            outProcessor = descriptorOutFactory.newInputProcessor();
        }
        return outProcessor;
    }

    private InputProcessor createErrProcessor() {
        InputProcessor errProcessor = null;
        BaseExecutionDescriptor.InputProcessorFactory descriptorErrFactory = this.descriptor.getErrProcessorFactory();
        if (descriptorErrFactory != null) {
            errProcessor = descriptorErrFactory.newInputProcessor();
        }
        return errProcessor;
    }

    private InputProcessor createInProcessor(OutputStream os, Charset charset) {
        return InputProcessors.copying(new OutputStreamWriter(os, charset));
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                EXECUTOR_SERVICE.shutdown();
                Set set = RUNNING_PROCESSES;
                synchronized (set) {
                    for (Process process : RUNNING_PROCESSES) {
                        process.destroy();
                    }
                }
            }
        });
    }

    private static class WrappedException
    extends Exception {
        public WrappedException(Throwable cause) {
            super(cause);
        }
    }
}

