/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.builtin.visualizer.editable;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import org.netbeans.api.diff.Difference;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.editor.MarkBlockChain;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.diff.builtin.visualizer.editable.DecoratedEditorPane;
import org.netbeans.modules.diff.builtin.visualizer.editable.DiffContentPanel;
import org.netbeans.modules.diff.builtin.visualizer.editable.EditableDiffView;
import org.netbeans.spi.diff.DiffProvider;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

class DiffViewManager
implements ChangeListener {
    private final EditableDiffView master;
    private final DiffContentPanel leftContentPanel;
    private final DiffContentPanel rightContentPanel;
    private boolean myScrollEvent;
    private int cachedDiffSerial;
    private DecoratedDifference[] decorationsCached = new DecoratedDifference[0];
    private HighLight[] secondHilitesCached = new HighLight[0];
    private HighLight[] firstHilitesCached = new HighLight[0];
    private final ScrollMapCached scrollMap = new ScrollMapCached();
    private final RequestProcessor.Task highlightComputeTask;
    private Dimension leftScrollBarPrefSize;
    private final Boolean[] smartScrollDisabled = new Boolean[]{Boolean.FALSE};
    private int rightHeightCached;
    private int leftHeightCached;

    public DiffViewManager(EditableDiffView master) {
        this.master = master;
        this.leftContentPanel = master.getEditorPane1();
        this.rightContentPanel = master.getEditorPane2();
        this.highlightComputeTask = new RequestProcessor("DiffViewHighlightsComputer", 1, true, false).create((Runnable)new HighlightsComputeTask());
    }

    void init() {
        this.initScrolling();
    }

    private void initScrolling() {
        this.rightContentPanel.getScrollPane().setVerticalScrollBarPolicy(20);
        this.leftContentPanel.getScrollPane().setVerticalScrollBarPolicy(20);
        this.leftContentPanel.getScrollPane().getVerticalScrollBar().getModel().addChangeListener(this);
        this.rightContentPanel.getScrollPane().getVerticalScrollBar().getModel().addChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWithSmartScrollingDisabled(Runnable runnable) {
        Boolean[] booleanArray = this.smartScrollDisabled;
        synchronized (this.smartScrollDisabled) {
            this.smartScrollDisabled[0] = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            try {
                runnable.run();
            }
            catch (Exception e) {
                try {
                    Logger.getLogger(DiffViewManager.class.getName()).log(Level.SEVERE, "", e);
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Boolean[] booleanArray = DiffViewManager.this.smartScrollDisabled;
                            synchronized (booleanArray) {
                                ((DiffViewManager)DiffViewManager.this).smartScrollDisabled[0] = false;
                            }
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.rightContentPanel.getScrollPane().getVerticalScrollBar().isVisible()) {
            Dimension d = this.leftContentPanel.getScrollPane().getVerticalScrollBar().getSize();
            if (d.getHeight() > 0.0 && d.getWidth() > 0.0) {
                this.leftScrollBarPrefSize = d;
            }
            this.leftContentPanel.getScrollPane().getVerticalScrollBar().setPreferredSize(new Dimension(0, 0));
            this.leftContentPanel.getScrollPane().getVerticalScrollBar().setSize(new Dimension(0, 0));
            this.leftContentPanel.getScrollPane().getVerticalScrollBar().repaint();
        } else if (this.leftScrollBarPrefSize != null) {
            this.leftContentPanel.getScrollPane().getVerticalScrollBar().setPreferredSize(this.leftScrollBarPrefSize);
            this.leftContentPanel.getScrollPane().getVerticalScrollBar().setSize(this.leftScrollBarPrefSize);
            this.leftContentPanel.getScrollPane().getVerticalScrollBar().repaint();
        }
        JScrollBar leftScrollBar = this.leftContentPanel.getScrollPane().getVerticalScrollBar();
        JScrollBar rightScrollBar = this.rightContentPanel.getScrollPane().getVerticalScrollBar();
        if (e.getSource() == this.leftContentPanel.getScrollPane().getVerticalScrollBar().getModel()) {
            int value = leftScrollBar.getValue();
            this.leftContentPanel.getActionsScrollPane().getVerticalScrollBar().setValue(value);
            if (this.myScrollEvent) {
                return;
            }
            this.myScrollEvent = true;
        } else {
            int value = rightScrollBar.getValue();
            boolean valueChanged = value != this.rightContentPanel.getActionsScrollPane().getVerticalScrollBar().getValue();
            this.rightContentPanel.getActionsScrollPane().getVerticalScrollBar().setValue(value);
            if (this.myScrollEvent) {
                return;
            }
            this.myScrollEvent = true;
            Boolean[] booleanArray = this.smartScrollDisabled;
            // MONITORENTER : this.smartScrollDisabled
            boolean doSmartScroll = this.smartScrollDisabled[0] == false;
            // MONITOREXIT : booleanArray
            if (doSmartScroll && valueChanged) {
                this.smartScroll();
                this.master.updateCurrentDifference();
            }
        }
        this.master.getMyDivider().repaint();
        this.myScrollEvent = false;
    }

    public void scroll() {
        this.myScrollEvent = true;
        this.smartScroll();
        this.master.getMyDivider().repaint();
        this.myScrollEvent = false;
    }

    EditableDiffView getMaster() {
        return this.master;
    }

    private void updateDifferences() {
        assert (EventQueue.isDispatchThread());
        int mds = this.master.getDiffSerial();
        int currentLeftHeight = this.getHeight(this.leftContentPanel.getEditorPane());
        int currentRightHeight = this.getHeight(this.rightContentPanel.getEditorPane());
        if (mds <= this.cachedDiffSerial && currentRightHeight == this.rightHeightCached && currentLeftHeight == this.leftHeightCached) {
            return;
        }
        this.rightHeightCached = currentRightHeight;
        this.leftHeightCached = currentLeftHeight;
        this.cachedDiffSerial = mds;
        this.computeDecorations();
        this.master.getEditorPane1().getLinesActions().repaint();
        this.master.getEditorPane2().getLinesActions().repaint();
        this.secondHilitesCached = new HighLight[0];
        this.firstHilitesCached = this.secondHilitesCached;
        this.highlightComputeTask.cancel();
        this.highlightComputeTask.schedule(0);
    }

    public DecoratedDifference[] getDecorations() {
        if (EventQueue.isDispatchThread()) {
            this.updateDifferences();
        }
        return this.decorationsCached;
    }

    public HighLight[] getSecondHighlights() {
        return this.secondHilitesCached;
    }

    public HighLight[] getFirstHighlights() {
        return this.firstHilitesCached;
    }

    private void computeFirstHighlights() {
        DecoratedDifference[] decorations;
        ArrayList<HighLight> hilites = new ArrayList<HighLight>();
        Document doc = this.leftContentPanel.getEditorPane().getDocument();
        for (DecoratedDifference dd : decorations = this.decorationsCached) {
            if (Thread.interrupted()) {
                return;
            }
            Difference diff = dd.getDiff();
            if (dd.getBottomLeft() == -1) continue;
            int start = DiffViewManager.getRowStartFromLineOffset(doc, diff.getFirstStart() > 0 ? diff.getFirstStart() - 1 : 0);
            if (this.isOneLineChange(diff)) {
                CorrectRowTokenizer firstSt = new CorrectRowTokenizer(diff.getFirstText());
                CorrectRowTokenizer secondSt = new CorrectRowTokenizer(diff.getSecondText());
                for (int i = diff.getSecondStart(); i <= diff.getSecondEnd(); ++i) {
                    String firstRow = firstSt.nextToken();
                    String secondRow = secondSt.nextToken();
                    List<HighLight> rowhilites = this.computeFirstRowHilites(start, firstRow, secondRow);
                    hilites.addAll(rowhilites);
                    start += firstRow.length() + 1;
                }
                continue;
            }
            int end = DiffViewManager.getRowStartFromLineOffset(doc, diff.getFirstEnd());
            if (end == -1) {
                end = doc.getLength();
            }
            SimpleAttributeSet attrs = new SimpleAttributeSet();
            StyleConstants.setBackground(attrs, this.master.getColor(diff));
            attrs.addAttribute("org.netbeans.spi.editor.highlighting.HighlightsContainer.ATTR_EXTENDS_EOL", Boolean.TRUE);
            hilites.add(new HighLight(start, end, attrs));
        }
        this.firstHilitesCached = hilites.toArray(new HighLight[hilites.size()]);
    }

    static int getRowStartFromLineOffset(Document doc, int lineIndex) {
        if (doc instanceof BaseDocument) {
            return Utilities.getRowStartFromLineOffset((BaseDocument)((BaseDocument)doc), (int)lineIndex);
        }
        Element element = doc.getDefaultRootElement();
        Element line = element.getElement(lineIndex);
        return line.getStartOffset();
    }

    private void computeSecondHighlights() {
        DecoratedDifference[] decorations;
        ArrayList<HighLight> hilites = new ArrayList<HighLight>();
        Document doc = this.rightContentPanel.getEditorPane().getDocument();
        for (DecoratedDifference dd : decorations = this.decorationsCached) {
            if (Thread.interrupted()) {
                return;
            }
            Difference diff = dd.getDiff();
            if (dd.getBottomRight() == -1) continue;
            int start = DiffViewManager.getRowStartFromLineOffset(doc, diff.getSecondStart() > 0 ? diff.getSecondStart() - 1 : 0);
            if (this.isOneLineChange(diff)) {
                CorrectRowTokenizer firstSt = new CorrectRowTokenizer(diff.getFirstText());
                CorrectRowTokenizer secondSt = new CorrectRowTokenizer(diff.getSecondText());
                for (int i = diff.getSecondStart(); i <= diff.getSecondEnd(); ++i) {
                    try {
                        String firstRow = firstSt.nextToken();
                        String secondRow = secondSt.nextToken();
                        List<HighLight> rowhilites = this.computeSecondRowHilites(start, firstRow, secondRow);
                        hilites.addAll(rowhilites);
                        start += secondRow.length() + 1;
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                continue;
            }
            int end = DiffViewManager.getRowStartFromLineOffset(doc, diff.getSecondEnd());
            if (end == -1) {
                end = doc.getLength();
            }
            SimpleAttributeSet attrs = new SimpleAttributeSet();
            StyleConstants.setBackground(attrs, this.master.getColor(diff));
            attrs.addAttribute("org.netbeans.spi.editor.highlighting.HighlightsContainer.ATTR_EXTENDS_EOL", Boolean.TRUE);
            hilites.add(new HighLight(start, end, attrs));
        }
        this.secondHilitesCached = hilites.toArray(new HighLight[hilites.size()]);
    }

    private List<HighLight> computeFirstRowHilites(int rowStart, String left, String right) {
        Difference[] diffs;
        ArrayList<HighLight> hilites = new ArrayList<HighLight>(4);
        String leftRows = this.wordsToRows(left);
        String rightRows = this.wordsToRows(right);
        DiffProvider diffprovider = (DiffProvider)Lookup.getDefault().lookup(DiffProvider.class);
        if (diffprovider == null) {
            return hilites;
        }
        try {
            diffs = diffprovider.computeDiff(new StringReader(leftRows), new StringReader(rightRows));
        }
        catch (IOException e) {
            return hilites;
        }
        for (Difference diff : diffs) {
            if (diff.getType() == 1) continue;
            int start = this.rowOffset(leftRows, diff.getFirstStart());
            int end = this.rowOffset(leftRows, diff.getFirstEnd() + 1);
            SimpleAttributeSet attrs = new SimpleAttributeSet();
            StyleConstants.setBackground(attrs, this.master.getColor(diff));
            hilites.add(new HighLight(rowStart + start, rowStart + end, attrs));
        }
        return hilites;
    }

    private List<HighLight> computeSecondRowHilites(int rowStart, String left, String right) {
        Difference[] diffs;
        ArrayList<HighLight> hilites = new ArrayList<HighLight>(4);
        String leftRows = this.wordsToRows(left);
        String rightRows = this.wordsToRows(right);
        DiffProvider diffprovider = (DiffProvider)Lookup.getDefault().lookup(DiffProvider.class);
        if (diffprovider == null) {
            return hilites;
        }
        try {
            diffs = diffprovider.computeDiff(new StringReader(leftRows), new StringReader(rightRows));
        }
        catch (IOException e) {
            return hilites;
        }
        for (Difference diff : diffs) {
            if (diff.getType() == 0) continue;
            int start = this.rowOffset(rightRows, diff.getSecondStart());
            int end = this.rowOffset(rightRows, diff.getSecondEnd() + 1);
            SimpleAttributeSet attrs = new SimpleAttributeSet();
            StyleConstants.setBackground(attrs, this.master.getColor(diff));
            hilites.add(new HighLight(rowStart + start, rowStart + end, attrs));
        }
        return hilites;
    }

    private int rowOffset(String row, int rowIndex) {
        if (rowIndex == 1) {
            return 0;
        }
        int newLines = 0;
        for (int i = 0; i < row.length(); ++i) {
            char c = row.charAt(i);
            if (c != '\n') continue;
            ++newLines;
            if (--rowIndex != 1) continue;
            return i + 1 - newLines;
        }
        return row.length();
    }

    private String wordsToRows(String s) {
        StringBuilder sb = new StringBuilder(s.length() * 2);
        StringTokenizer st = new StringTokenizer(s, " \t\n[]{};:'\",.<>/?-=_+\\|~!@#$%^&*()", true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.length() == 0) continue;
            sb.append(token);
            sb.append('\n');
        }
        return sb.toString();
    }

    private boolean isOneLineChange(Difference diff) {
        return diff.getType() == 2 && diff.getFirstEnd() - diff.getFirstStart() == diff.getSecondEnd() - diff.getSecondStart();
    }

    private void computeDecorations() {
        Document document = this.master.getEditorPane2().getEditorPane().getDocument();
        View rootLeftView = Utilities.getDocumentView((JTextComponent)this.leftContentPanel.getEditorPane());
        View rootRightView = Utilities.getDocumentView((JTextComponent)this.rightContentPanel.getEditorPane());
        if (rootLeftView == null || rootRightView == null) {
            return;
        }
        Difference[] diffs = this.master.getDifferences();
        DecoratedDifference[] decorations = new DecoratedDifference[diffs.length];
        for (int i = 0; i < diffs.length; ++i) {
            Rectangle rightEndRect;
            Difference difference = diffs[i];
            DecoratedDifference dd = new DecoratedDifference(difference, this.canRollback(document, difference));
            Rectangle leftStartRect = this.getRectForView(this.leftContentPanel.getEditorPane(), rootLeftView, difference.getFirstStart() - 1, false);
            Rectangle leftEndRect = difference.getType() == 1 ? this.getRectForView(this.leftContentPanel.getEditorPane(), rootLeftView, difference.getFirstStart(), false) : this.getRectForView(this.leftContentPanel.getEditorPane(), rootLeftView, difference.getFirstEnd() - 1, true);
            Rectangle rightStartRect = this.getRectForView(this.rightContentPanel.getEditorPane(), rootRightView, difference.getSecondStart() - 1, false);
            Rectangle rectangle = rightEndRect = difference.getType() == 0 ? this.getRectForView(this.rightContentPanel.getEditorPane(), rootRightView, difference.getSecondStart(), false) : this.getRectForView(this.rightContentPanel.getEditorPane(), rootRightView, difference.getSecondEnd() - 1, true);
            if (leftStartRect == null || leftEndRect == null || rightStartRect == null || rightEndRect == null) {
                decorations = new DecoratedDifference[]{};
                break;
            }
            if (difference.getType() == 1) {
                dd.topRight = rightStartRect.y;
                dd.bottomRight = rightEndRect.y + rightEndRect.height;
                dd.topLeft = leftEndRect.y == 0 ? leftStartRect.y + leftStartRect.height : leftEndRect.y;
                dd.floodFill = true;
            } else if (difference.getType() == 0) {
                dd.topLeft = leftStartRect.y;
                dd.bottomLeft = leftEndRect.y + leftEndRect.height;
                dd.topRight = rightEndRect.y == 0 ? rightStartRect.y + rightStartRect.height : rightEndRect.y;
                dd.floodFill = true;
            } else {
                dd.topRight = rightStartRect.y;
                dd.bottomRight = rightEndRect.y + rightEndRect.height;
                dd.topLeft = leftStartRect.y;
                dd.bottomLeft = leftEndRect.y + leftEndRect.height;
                dd.floodFill = true;
            }
            decorations[i] = dd;
        }
        this.decorationsCached = decorations;
    }

    private Rectangle getRectForView(final JTextComponent comp, final View rootView, final int lineNumber, final boolean endOffset) {
        final Rectangle[] rect = new Rectangle[1];
        Utilities.runViewHierarchyTransaction((JTextComponent)comp, (boolean)true, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (lineNumber == -1 || lineNumber >= rootView.getViewCount()) {
                    rect[0] = new Rectangle();
                    return;
                }
                View view = rootView.getView(lineNumber);
                try {
                    rect[0] = view == null ? null : comp.modelToView(endOffset ? view.getEndOffset() - 1 : view.getStartOffset());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
        return rect[0];
    }

    private boolean canRollback(Document doc, Difference diff) {
        int start;
        int end;
        if (!(doc instanceof GuardedDocument)) {
            return true;
        }
        GuardedDocument document = (GuardedDocument)doc;
        if (diff.getType() == 0) {
            start = end = Utilities.getRowStartFromLineOffset((BaseDocument)document, (int)diff.getSecondStart());
        } else {
            start = Utilities.getRowStartFromLineOffset((BaseDocument)document, (int)(diff.getSecondStart() > 0 ? diff.getSecondStart() - 1 : 0));
            end = Utilities.getRowStartFromLineOffset((BaseDocument)document, (int)diff.getSecondEnd());
        }
        MarkBlockChain mbc = document.getGuardedBlockChain();
        return (mbc.compareBlock(start, end) & 1) == 0;
    }

    private void smartScroll() {
        DiffContentPanel rightPane = this.master.getEditorPane2();
        DiffContentPanel leftPane = this.master.getEditorPane1();
        int[] map = this.scrollMap.getScrollMap(rightPane.getEditorPane().getSize().height, this.master.getDiffSerial());
        int rightOffet = rightPane.getScrollPane().getVerticalScrollBar().getValue();
        if (rightOffet >= map.length) {
            return;
        }
        leftPane.getScrollPane().getVerticalScrollBar().setValue(map[rightOffet]);
    }

    private int computeLeftOffsetToMatchDifference(DifferencePosition differenceMatchStart, int rightOffset, Rectangle[] positions) {
        int valueSecond;
        int value;
        Rectangle leftStartRect = positions[0];
        Rectangle leftEndRect = positions[1];
        Rectangle rightStartRect = positions[2];
        Rectangle rightEndRect = positions[3];
        Difference diff = differenceMatchStart.getDiff();
        boolean matchStart = differenceMatchStart.isStart();
        if (matchStart) {
            value = leftStartRect.y + leftStartRect.height;
            valueSecond = rightStartRect.y + rightStartRect.height;
        } else if (diff.getType() == 1) {
            value = leftStartRect.y;
            if (rightStartRect.y == 0) {
                value -= rightStartRect.height;
            }
            valueSecond = rightEndRect.y + rightStartRect.height;
        } else {
            value = leftEndRect.y + leftEndRect.height;
            if (diff.getType() == 0) {
                value += leftStartRect.height;
                valueSecond = rightStartRect.y + rightStartRect.height;
            } else {
                valueSecond = rightEndRect.y + rightEndRect.height;
            }
        }
        int secondOffset = rightOffset - valueSecond;
        value += secondOffset;
        if (diff.getType() == 1) {
            value += rightStartRect.height;
        }
        if (diff.getType() == 0) {
            value -= leftStartRect.height;
        }
        return value;
    }

    private int findDifferenceToMatch(int rightOffset, int rightViewportHeight, DecoratedDifference[] diffs, int index) {
        DecoratedDifference dd;
        int candidateIndex = -1;
        while (index < diffs.length && (dd = diffs[index]).getTopRight() <= rightOffset + rightViewportHeight) {
            if (!(dd.getBottomRight() == -1 ? dd.getTopRight() <= rightOffset : dd.getBottomRight() <= rightOffset)) {
                if (candidateIndex > -1) {
                    DecoratedDifference candidate = diffs[candidateIndex];
                    if (candidate.getDiff().getType() == 0) {
                        candidateIndex = index;
                    } else if (candidate.getTopRight() < rightOffset) {
                        candidateIndex = index;
                    } else if (dd.getTopRight() <= rightOffset + rightViewportHeight / 2) {
                        candidateIndex = index;
                    }
                } else {
                    candidateIndex = index;
                }
            }
            ++index;
        }
        return candidateIndex;
    }

    double getScrollFactor() {
        BoundedRangeModel m1 = this.leftContentPanel.getScrollPane().getVerticalScrollBar().getModel();
        BoundedRangeModel m2 = this.rightContentPanel.getScrollPane().getVerticalScrollBar().getModel();
        return ((double)m1.getMaximum() - (double)m1.getExtent()) / (double)(m2.getMaximum() - m2.getExtent());
    }

    void editorPainting(DecoratedEditorPane decoratedEditorPane) {
        if (!decoratedEditorPane.isFirst()) {
            JComponent mydivider = this.master.getMyDivider();
            mydivider.paint(mydivider.getGraphics());
        }
    }

    private int getHeight(final DecoratedEditorPane editorPane) {
        final int[] height = new int[1];
        editorPane.getDocument().render(new Runnable(){

            @Override
            public void run() {
                try {
                    Rectangle rec = editorPane.modelToView(editorPane.getDocument().getLength());
                    if (rec != null) {
                        height[0] = (int)(rec.getY() + rec.getHeight());
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
        return height[0];
    }

    private class HighlightsComputeTask
    implements Runnable {
        private int diffSerial;

        private HighlightsComputeTask() {
        }

        @Override
        public void run() {
            this.diffSerial = DiffViewManager.this.cachedDiffSerial;
            DiffViewManager.this.computeSecondHighlights();
            if (this.diffSerial != DiffViewManager.this.cachedDiffSerial) {
                return;
            }
            DiffViewManager.this.computeFirstHighlights();
            if (this.diffSerial == DiffViewManager.this.cachedDiffSerial) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DiffViewManager.this.master.getEditorPane1().fireHilitingChanged();
                        DiffViewManager.this.master.getEditorPane2().fireHilitingChanged();
                    }
                });
            }
        }
    }

    private class ScrollMapCached {
        private int rightPanelHeightCached;
        private int[] scrollMapCached;
        private int diffSerialCached;

        private ScrollMapCached() {
        }

        public synchronized int[] getScrollMap(int rightPanelHeight, int diffSerial) {
            if (rightPanelHeight != this.rightPanelHeightCached || this.diffSerialCached != diffSerial || this.scrollMapCached == null) {
                this.diffSerialCached = diffSerial;
                this.rightPanelHeightCached = rightPanelHeight;
                this.scrollMapCached = this.compute();
            }
            return this.scrollMapCached;
        }

        private int[] compute() {
            DiffContentPanel rightPane = DiffViewManager.this.master.getEditorPane2();
            int rightViewportHeight = rightPane.getScrollPane().getViewport().getViewRect().height;
            int[] scrollMap = new int[this.rightPanelHeightCached];
            EditorUI editorUI = Utilities.getEditorUI((JTextComponent)DiffViewManager.this.leftContentPanel.getEditorPane());
            if (editorUI == null) {
                return scrollMap;
            }
            int lastOffset = 0;
            View rootLeftView = Utilities.getDocumentView((JTextComponent)DiffViewManager.this.leftContentPanel.getEditorPane());
            View rootRightView = Utilities.getDocumentView((JTextComponent)DiffViewManager.this.rightContentPanel.getEditorPane());
            if (rootLeftView == null || rootRightView == null) {
                return scrollMap;
            }
            HashMap<Difference, Rectangle[]> positionsPerDiff = new HashMap<Difference, Rectangle[]>(DiffViewManager.this.getDecorations().length);
            DecoratedDifference[] diffs = DiffViewManager.this.getDecorations();
            int lastDiffIndex = 0;
            for (int rightOffset = 0; rightOffset < this.rightPanelHeightCached; rightOffset += 5) {
                int leftOffset;
                int candidateIndex;
                DifferencePosition dpos = null;
                int n = candidateIndex = diffs.length == 0 ? -1 : DiffViewManager.this.findDifferenceToMatch(rightOffset, rightViewportHeight, diffs, lastDiffIndex);
                if (candidateIndex > -1) {
                    boolean matchStart;
                    lastDiffIndex = candidateIndex;
                    DecoratedDifference candidate = diffs[candidateIndex];
                    boolean bl = matchStart = candidate.getTopRight() > rightOffset + rightViewportHeight / 2;
                    if (candidate.getDiff().getType() == 0 && candidate.getTopRight() < rightOffset + rightViewportHeight * 4 / 5) {
                        matchStart = false;
                    }
                    if (candidate.getDiff().getType() == 0 && candidate == diffs[diffs.length - 1]) {
                        matchStart = false;
                    }
                    dpos = new DifferencePosition(candidate.getDiff(), matchStart);
                }
                if (dpos == null) {
                    leftOffset = lastOffset + rightOffset;
                } else {
                    Difference diff = dpos.getDiff();
                    Rectangle[] positions = (Rectangle[])positionsPerDiff.get(diff);
                    if (positions == null) {
                        positions = new Rectangle[]{DiffViewManager.this.getRectForView(DiffViewManager.this.leftContentPanel.getEditorPane(), rootLeftView, diff.getFirstStart() - 1, false), DiffViewManager.this.getRectForView(DiffViewManager.this.leftContentPanel.getEditorPane(), rootLeftView, diff.getFirstEnd() - 1, true), DiffViewManager.this.getRectForView(DiffViewManager.this.rightContentPanel.getEditorPane(), rootRightView, diff.getSecondStart() - 1, false), DiffViewManager.this.getRectForView(DiffViewManager.this.rightContentPanel.getEditorPane(), rootRightView, diff.getSecondEnd() - 1, true)};
                        positionsPerDiff.put(diff, positions);
                    }
                    leftOffset = DiffViewManager.this.computeLeftOffsetToMatchDifference(dpos, rightOffset, positions);
                    lastOffset = leftOffset - rightOffset;
                }
                int maxIndex = Math.min(this.rightPanelHeightCached - rightOffset, 5);
                for (int i = 0; i < maxIndex; ++i) {
                    scrollMap[rightOffset + i] = leftOffset + i;
                }
            }
            scrollMap = this.smooth(scrollMap);
            return scrollMap;
        }

        private int[] smooth(int[] map) {
            int[] newMap = new int[map.length];
            int leftShift = 0;
            float correction = 0.0f;
            for (int i = 0; i < map.length; ++i) {
                int leftOffset = map[i];
                int requestedShift = leftOffset - i;
                if (requestedShift > leftShift) {
                    if (correction > (float)(requestedShift - leftShift)) {
                        correction = requestedShift - leftShift;
                    }
                    leftShift = (int)((float)leftShift + correction);
                    correction += 0.02f;
                } else if (requestedShift < leftShift) {
                    --leftShift;
                } else {
                    correction = 1.0f;
                }
                newMap[i] = i + leftShift;
            }
            return newMap;
        }
    }

    private static class CorrectRowTokenizer {
        private final String s;
        private int idx;

        public CorrectRowTokenizer(String s) {
            this.s = s;
        }

        public String nextToken() {
            String token = null;
            for (int end = this.idx; end < this.s.length(); ++end) {
                if (this.s.charAt(end) != '\n') continue;
                token = this.s.substring(this.idx, end);
                this.idx = end + 1;
                break;
            }
            return token;
        }
    }

    public static class HighLight {
        private final int startOffset;
        private final int endOffset;
        private final AttributeSet attrs;

        public HighLight(int startOffset, int endOffset, AttributeSet attrs) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.attrs = attrs;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public AttributeSet getAttrs() {
            return this.attrs;
        }
    }

    public static class DecoratedDifference {
        private final Difference diff;
        private final boolean canRollback;
        private int topLeft;
        private int bottomLeft = -1;
        private int topRight;
        private int bottomRight = -1;
        private boolean floodFill;

        public DecoratedDifference(Difference difference, boolean canRollback) {
            this.diff = difference;
            this.canRollback = canRollback;
        }

        public boolean canRollback() {
            return this.canRollback;
        }

        public Difference getDiff() {
            return this.diff;
        }

        public int getTopLeft() {
            return this.topLeft;
        }

        public int getBottomLeft() {
            return this.bottomLeft;
        }

        public int getTopRight() {
            return this.topRight;
        }

        public int getBottomRight() {
            return this.bottomRight;
        }

        public boolean isFloodFill() {
            return this.floodFill;
        }
    }

    public static class DifferencePosition {
        private Difference diff;
        private boolean isStart;

        public DifferencePosition(Difference diff, boolean start) {
            this.diff = diff;
            this.isStart = start;
        }

        public Difference getDiff() {
            return this.diff;
        }

        public boolean isStart() {
            return this.isStart;
        }
    }
}

