/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle.frames.models;

import java.io.InvalidObjectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.truffle.access.CurrentPCInfo;
import org.netbeans.modules.debugger.jpda.truffle.access.TruffleAccess;
import org.netbeans.modules.debugger.jpda.truffle.frames.TruffleStackFrame;
import org.netbeans.modules.debugger.jpda.truffle.frames.models.Bundle;
import org.netbeans.modules.debugger.jpda.truffle.source.Source;
import org.netbeans.modules.debugger.jpda.truffle.source.SourcePosition;
import org.netbeans.spi.debugger.ui.DebuggingView;
import org.openide.util.Exceptions;

public final class TruffleDVFrame
implements DebuggingView.DVFrame {
    private final DebuggingView.DVThread thread;
    private final TruffleStackFrame truffleFrame;

    TruffleDVFrame(DebuggingView.DVThread thread, TruffleStackFrame truffleFrame) {
        this.thread = thread;
        this.truffleFrame = truffleFrame;
    }

    TruffleStackFrame getTruffleFrame() {
        return this.truffleFrame;
    }

    public String getName() {
        return this.truffleFrame.getMethodName();
    }

    public DebuggingView.DVThread getThread() {
        return this.thread;
    }

    public void makeCurrent() {
        CurrentPCInfo currentPCInfo = TruffleAccess.getCurrentPCInfo(this.truffleFrame.getThread());
        if (currentPCInfo != null) {
            currentPCInfo.setSelectedStackFrame(this.truffleFrame);
        }
    }

    public URI getSourceURI() {
        URI uri;
        SourcePosition sourcePosition = this.truffleFrame.getSourcePosition();
        if (sourcePosition == null) {
            return null;
        }
        Source source = sourcePosition.getSource();
        URL url = source.getUrl();
        if (url != null) {
            try {
                uri = url.toURI();
            }
            catch (URISyntaxException ex) {
                uri = source.getURI();
            }
        } else {
            uri = source.getURI();
        }
        return uri;
    }

    public String getSourceMimeType() {
        SourcePosition sourcePosition = this.truffleFrame.getSourcePosition();
        if (sourcePosition != null) {
            Source source = sourcePosition.getSource();
            return source.getMimeType();
        }
        return null;
    }

    public int getLine() {
        SourcePosition sourcePosition = this.truffleFrame.getSourcePosition();
        if (sourcePosition != null) {
            return sourcePosition.getStartLine();
        }
        return -1;
    }

    public int getColumn() {
        SourcePosition sourcePosition = this.truffleFrame.getSourcePosition();
        if (sourcePosition != null) {
            return sourcePosition.getStartColumn();
        }
        return -1;
    }

    public void popOff() throws DebuggingView.PopException {
        int depth;
        JPDAThread tr;
        JPDADebugger debugger = this.truffleFrame.getDebugger();
        boolean unwindScheduled = TruffleAccess.unwind(debugger, tr = this.truffleFrame.getThread(), depth = this.truffleFrame.getDepth());
        if (unwindScheduled) {
            CurrentPCInfo currentPCInfo = TruffleAccess.getCurrentGuestPCInfo(tr);
            try {
                currentPCInfo.getStepCommandVar().setFromMirrorObject((Object)-1);
                tr.resume();
            }
            catch (InvalidObjectException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else {
            throw new DebuggingView.PopException(Bundle.MSG_FramePopFailed());
        }
    }
}

