/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.action;

import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.node.BaseNode;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.lib.ddl.DatabaseSpecification;
import org.netbeans.lib.ddl.impl.AbstractCommand;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DatabaseConnector;
import org.netbeans.modules.db.explorer.DbUtilities;
import org.netbeans.modules.db.explorer.action.BaseAction;
import org.netbeans.modules.db.explorer.action.RefreshAction;
import org.netbeans.modules.db.explorer.dataview.DataViewWindow;
import org.netbeans.modules.db.explorer.dlg.LabeledTextFieldDialog;
import org.netbeans.modules.db.explorer.node.SchemaNameProvider;
import org.netbeans.modules.db.explorer.node.TableListNode;
import org.netbeans.modules.db.explorer.node.TableNode;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;
import org.openide.windows.WindowManager;

public class RecreateTableAction
extends BaseAction {
    private static final Logger LOGGER = Logger.getLogger(RecreateTableAction.class.getName());

    protected boolean enable(Node[] activatedNodes) {
        boolean enabled = false;
        if (activatedNodes.length == 1) {
            TableNode tn = (TableNode)activatedNodes[0].getLookup().lookup(TableNode.class);
            DatabaseConnection dbconn = (DatabaseConnection)activatedNodes[0].getLookup().lookup(DatabaseConnection.class);
            if (!(dbconn == null || tn != null && tn.isSystem())) {
                enabled = DatabaseConnection.isVitalConnection(dbconn.getConnection(), dbconn);
            }
        }
        return enabled;
    }

    public void performAction(Node[] activatedNodes) {
        final BaseNode node = (BaseNode)((Object)activatedNodes[0].getLookup().lookup(BaseNode.class));
        final DatabaseConnection connection = (DatabaseConnection)activatedNodes[0].getLookup().lookup(DatabaseConnection.class);
        final DatabaseConnector connector = connection.getConnector();
        Frame par = WindowManager.getDefault().getMainWindow();
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                try {
                    Specification spec = connector.getDatabaseSpecification();
                    FileChooserBuilder chooser = new FileChooserBuilder(RecreateTableAction.class);
                    chooser.setTitle(NbBundle.getMessage(RecreateTableAction.class, (String)"RecreateTableFileOpenDialogTitle"));
                    chooser.setFileFilter(new FileFilter(){

                        @Override
                        public boolean accept(File f) {
                            return f.isDirectory() || f.getName().endsWith(".grab");
                        }

                        @Override
                        public String getDescription() {
                            return NbBundle.getMessage(RecreateTableAction.class, (String)"GrabTableFileTypeDescription");
                        }
                    });
                    File file = chooser.showOpenDialog();
                    if (file == null || !file.isFile()) {
                        return;
                    }
                    FileInputStream fstream = new FileInputStream(file);
                    ObjectInputStream istream = new ObjectInputStream(fstream);
                    AbstractCommand cmd = (AbstractCommand)istream.readObject();
                    istream.close();
                    cmd.setSpecification((DatabaseSpecification)spec);
                    SchemaNameProvider schemaProvider = (SchemaNameProvider)node.getLookup().lookup(SchemaNameProvider.class);
                    String schemaName = schemaProvider.getSchemaName();
                    String catName = schemaProvider.getCatalogName();
                    if (schemaName == null) {
                        schemaName = catName;
                    }
                    cmd.setObjectOwner(schemaName);
                    String newtab = cmd.getObjectName();
                    String msg = cmd.getCommand();
                    LabeledTextFieldDialog dlg = new LabeledTextFieldDialog(msg);
                    dlg.setStringValue(newtab);
                    boolean noResult = true;
                    while (noResult) {
                        if (dlg.run()) {
                            if (!dlg.isEditable()) {
                                noResult = RecreateTableAction.this.runCommand(dlg, cmd);
                                continue;
                            }
                            noResult = RecreateTableAction.this.runWindow(connection, dlg);
                            continue;
                        }
                        noResult = false;
                    }
                }
                catch (Exception exc) {
                    LOGGER.log(Level.INFO, exc.getLocalizedMessage(), exc);
                    DbUtilities.reportError(NbBundle.getMessage(RecreateTableAction.class, (String)"ERR_UnableToRecreateTable"), exc.getMessage());
                }
                BaseNode refreshNode = node;
                while (!(refreshNode instanceof TableListNode) && (refreshNode = refreshNode.getParentNode()) != null) {
                }
                if (refreshNode == null) {
                    refreshNode = node;
                }
                ((RefreshAction)SystemAction.get(RefreshAction.class)).performAction(new Node[]{refreshNode});
            }
        }, 0);
    }

    private boolean runCommand(LabeledTextFieldDialog dlg, AbstractCommand cmd) {
        boolean noResult = true;
        String newtab = dlg.getStringValue();
        cmd.setObjectName(newtab);
        try {
            cmd.execute();
            noResult = false;
        }
        catch (DDLException exc) {
            LOGGER.log(Level.INFO, null, exc);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)exc.getMessage(), 0));
            noResult = true;
        }
        catch (Exception exc) {
            LOGGER.log(Level.INFO, exc.getLocalizedMessage(), exc);
            DbUtilities.reportError(NbBundle.getMessage(RecreateTableAction.class, (String)"ERR_UnableToRecreateTable"), exc.getMessage());
            noResult = false;
        }
        return noResult;
    }

    private boolean runWindow(DatabaseConnection connection, LabeledTextFieldDialog dlg) throws Exception {
        WindowTask wintask = new WindowTask(connection, dlg);
        Mutex.EVENT.postReadRequest((Runnable)wintask);
        while (!wintask.completed) {
            Thread.sleep(10L);
        }
        if (wintask.exc != null) {
            throw new DatabaseException(wintask.exc);
        }
        return !wintask.win.executeCommand();
    }

    public String getName() {
        return NbBundle.getMessage(RecreateTableAction.class, (String)"RecreateTable");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(RecreateTableAction.class);
    }

    private static class WindowTask
    implements Runnable {
        public DataViewWindow win;
        public Exception exc = null;
        public boolean completed = false;
        private final DatabaseConnection connection;
        private final LabeledTextFieldDialog dlg;

        public WindowTask(DatabaseConnection conn, LabeledTextFieldDialog dlg) {
            this.connection = conn;
            this.dlg = dlg;
        }

        @Override
        public void run() {
            try {
                this.win = new DataViewWindow(this.connection, this.dlg.getEditedCommand());
            }
            catch (Exception e) {
                this.exc = e;
            }
            this.completed = true;
        }
    }
}

