/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.dlg;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.netbeans.lib.ddl.DDLCommand;
import org.netbeans.lib.ddl.impl.CreateIndex;
import org.netbeans.lib.ddl.impl.CreateTable;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.lib.ddl.impl.TableColumn;
import org.netbeans.lib.ddl.util.CommandBuffer;
import org.netbeans.modules.db.explorer.dlg.ColumnItem;

public class CreateTableDDL {
    private Specification spec;
    private String schema;
    private String tablename;

    public CreateTableDDL(Specification spec, String schema, String tablename) {
        this.spec = spec;
        this.schema = schema;
        this.tablename = tablename;
    }

    public boolean execute(List<ColumnItem> columns, List<ColumnItem> pkcols) throws Exception {
        CommandBuffer cbuff = new CommandBuffer();
        ArrayList<CreateIndex> idxCommands = new ArrayList<CreateIndex>();
        CreateTable cmd = this.spec.createCommandCreateTable(this.tablename);
        cmd.setObjectOwner(this.schema);
        TableColumn cmdcol = null;
        CreateIndex xcmd = null;
        for (ColumnItem col : columns) {
            String name = col.getName();
            cmdcol = col.isPrimaryKey() && !this.hasPrimaryKeys(pkcols) ? cmd.createPrimaryKeyColumn(name) : (col.isUnique() && !col.isPrimaryKey() ? cmd.createUniqueColumn(name) : cmd.createColumn(name));
            cmdcol.setColumnType(Specification.getType((String)col.getType().getType()));
            cmdcol.setColumnSize(col.getSize());
            cmdcol.setDecimalSize(col.getScale());
            cmdcol.setNullAllowed(col.allowsNull());
            String defval = col.getDefaultValue();
            if (defval != null && defval.length() > 0) {
                cmdcol.setDefaultValue(defval);
            }
            if (col.hasCheckConstraint()) {
                cmd.createCheckConstraint(name, col.getCheckConstraint());
            }
            if (!col.isIndexed() || col.isPrimaryKey() || col.isUnique()) continue;
            xcmd = this.spec.createCommandCreateIndex(this.tablename);
            xcmd.setNewObject(true);
            xcmd.setIndexName(this.tablename + "_" + name + "_idx");
            xcmd.setIndexType(new String());
            xcmd.setObjectOwner(this.schema);
            xcmd.specifyNewColumn(name);
            idxCommands.add(xcmd);
        }
        if (this.hasPrimaryKeys(pkcols)) {
            cmdcol = cmd.createPrimaryKeyConstraint(this.tablename);
            cmdcol.setTableConstraintColumns(new Vector<ColumnItem>(pkcols));
            cmdcol.setColumnType(0);
            cmdcol.setColumnSize(0);
            cmdcol.setDecimalSize(0);
            cmdcol.setNullAllowed(true);
        }
        cbuff.add((DDLCommand)cmd);
        for (int i = 0; i < idxCommands.size(); ++i) {
            cbuff.add((DDLCommand)idxCommands.get(i));
        }
        cbuff.execute();
        return cbuff.wasException();
    }

    private boolean hasPrimaryKeys(List<ColumnItem> pkcols) {
        return pkcols != null && pkcols.size() > 0;
    }
}

