/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.navigation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.lsp.StructureElement;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.csl.api.StructureScanner;
import org.netbeans.modules.csl.core.Language;
import org.netbeans.modules.csl.core.LanguageRegistry;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.lsp.StructureProvider;

public class GsfStructureProvider
implements StructureProvider {
    private static final Logger LOGGER = Logger.getLogger(GsfStructureProvider.class.getName());

    private static StructureElement.Kind convertKind(ElementKind elementKind) {
        switch (elementKind) {
            case ATTRIBUTE: {
                return StructureElement.Kind.Property;
            }
            case CALL: {
                return StructureElement.Kind.Event;
            }
            case CLASS: {
                return StructureElement.Kind.Class;
            }
            case CONSTANT: {
                return StructureElement.Kind.Constant;
            }
            case CONSTRUCTOR: {
                return StructureElement.Kind.Constructor;
            }
            case DB: {
                return StructureElement.Kind.File;
            }
            case ERROR: {
                return StructureElement.Kind.Event;
            }
            case METHOD: {
                return StructureElement.Kind.Method;
            }
            case FILE: {
                return StructureElement.Kind.File;
            }
            case FIELD: {
                return StructureElement.Kind.Field;
            }
            case MODULE: {
                return StructureElement.Kind.Module;
            }
            case VARIABLE: {
                return StructureElement.Kind.Variable;
            }
            case GLOBAL: {
                return StructureElement.Kind.Module;
            }
            case INTERFACE: {
                return StructureElement.Kind.Interface;
            }
            case KEYWORD: {
                return StructureElement.Kind.Key;
            }
            case OTHER: {
                return StructureElement.Kind.Object;
            }
            case PACKAGE: {
                return StructureElement.Kind.Package;
            }
            case PARAMETER: {
                return StructureElement.Kind.TypeParameter;
            }
            case PROPERTY: {
                return StructureElement.Kind.Property;
            }
            case RULE: {
                return StructureElement.Kind.Event;
            }
            case TAG: {
                return StructureElement.Kind.Operator;
            }
            case TEST: {
                return StructureElement.Kind.Function;
            }
        }
        return StructureElement.Kind.Object;
    }

    private static void createDetail(StructureItem item, StructureProvider.Builder builder) {
        NoHtmlFormatter formatter = new NoHtmlFormatter();
        String s = item.getHtml(formatter);
        if (!(s = s.substring(item.getName().length()).trim()).trim().isEmpty()) {
            builder.detail(s);
        }
    }

    private static void createTags(StructureItem item, StructureProvider.Builder builder) {
        if (item.getModifiers().contains(Modifier.DEPRECATED)) {
            builder.addTag(StructureElement.Tag.Deprecated);
        }
    }

    private static void createChildren(Document doc, StructureItem item, StructureProvider.Builder builder) {
        List<? extends StructureItem> origChildren;
        if (!item.isLeaf() && !(origChildren = item.getNestedItems()).isEmpty()) {
            ArrayList<StructureElement> children = new ArrayList<StructureElement>(origChildren.size());
            GsfStructureProvider.convertStructureItems(doc, origChildren, children);
            builder.children(children);
        }
    }

    public List<StructureElement> getStructure(final Document doc) {
        final ArrayList<StructureElement> sElements = new ArrayList<StructureElement>();
        try {
            ParserManager.parse(Collections.singletonList(Source.create((Document)doc)), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    Parser.Result result = resultIterator.getParserResult(-1);
                    if (result instanceof ParserResult) {
                        StructureScanner scanner;
                        ParserResult parserResult = (ParserResult)result;
                        Language language = LanguageRegistry.getInstance().getLanguageByMimeType(resultIterator.getSnapshot().getMimeType());
                        if (language != null && (scanner = language.getStructure()) != null) {
                            List<? extends StructureItem> items = scanner.scan(parserResult);
                            GsfStructureProvider.convertStructureItems(doc, items, sElements);
                        }
                    }
                }
            });
            return sElements;
        }
        catch (ParseException ex) {
            LOGGER.log(Level.FINE, null, ex);
            return Collections.EMPTY_LIST;
        }
    }

    private static void convertStructureItems(Document doc, List<? extends StructureItem> items, List<StructureElement> sElements) {
        StructureElement lastElement = null;
        if (doc instanceof LineDocument) {
            LineDocument ldoc = (LineDocument)doc;
            for (StructureItem structureItem : items) {
                int startOffset;
                int lineStart = startOffset = (int)structureItem.getPosition();
                int lineEnd = (int)structureItem.getEndPosition();
                StructureProvider.Builder builder = StructureProvider.newBuilder((String)structureItem.getName(), (StructureElement.Kind)GsfStructureProvider.convertKind(structureItem.getKind()));
                builder.selectionStartOffset(startOffset).selectionEndOffset(lineEnd);
                GsfStructureProvider.createDetail(structureItem, builder);
                GsfStructureProvider.createTags(structureItem, builder);
                try {
                    String prefix = doc.getText(lineStart, startOffset);
                    lineStart = LineDocumentUtils.getLineStart((LineDocument)ldoc, (int)lineStart);
                    if (prefix.trim().isEmpty()) {
                        lineEnd = LineDocumentUtils.getLineEnd((LineDocument)ldoc, (int)lineEnd);
                    }
                }
                catch (BadLocationException ex) {
                    lineStart = startOffset;
                    lineEnd = (int)structureItem.getEndPosition();
                }
                if (lastElement == null) {
                    builder.expandedStartOffset(lineStart);
                    builder.expandedEndOffset(lineEnd);
                } else if (lastElement.getExpandedEndOffset() < lineStart) {
                    builder.expandedStartOffset(lineStart);
                    builder.expandedEndOffset(lineEnd);
                } else if (lastElement.getExpandedStartOffset() <= lineStart && lineEnd == lastElement.getExpandedEndOffset()) {
                    sElements.remove(lastElement);
                    StructureProvider.Builder leBuilder = StructureProvider.copy(lastElement);
                    leBuilder.expandedEndOffset(startOffset - 1);
                    sElements.add(leBuilder.build());
                }
                builder.expandedStartOffset(lineStart).expandedEndOffset(lineEnd);
                GsfStructureProvider.createChildren(doc, structureItem, builder);
                lastElement = builder.build();
                sElements.add(lastElement);
            }
        } else {
            for (StructureItem structureItem : items) {
                int n = (int)structureItem.getPosition();
                int selectionEnd = (int)structureItem.getEndPosition();
                StructureProvider.Builder builder = StructureProvider.newBuilder((String)structureItem.getName(), (StructureElement.Kind)GsfStructureProvider.convertKind(structureItem.getKind()));
                builder.selectionStartOffset(n).selectionEndOffset(selectionEnd);
                builder.expandedStartOffset(n).expandedEndOffset(selectionEnd);
                GsfStructureProvider.createDetail(structureItem, builder);
                GsfStructureProvider.createTags(structureItem, builder);
                GsfStructureProvider.createChildren(doc, structureItem, builder);
                sElements.add(builder.build());
            }
        }
    }

    private static class NoHtmlFormatter
    extends HtmlFormatter {
        StringBuilder sb = new StringBuilder();

        private NoHtmlFormatter() {
        }

        @Override
        public void reset() {
            this.sb = new StringBuilder();
        }

        static String stripHtml(String htmlText) {
            if (null == htmlText) {
                return null;
            }
            return htmlText.replaceAll("<[^>]*>", "").replace("&nbsp;", " ").trim();
        }

        @Override
        public void appendHtml(String html) {
            this.sb.append(NoHtmlFormatter.stripHtml(html));
        }

        @Override
        public void appendText(String text, int fromInclusive, int toExclusive) {
            int l = toExclusive - fromInclusive;
            if (this.sb.length() + l < this.maxLength) {
                this.sb.append(text.subSequence(fromInclusive, toExclusive));
            } else {
                this.sb.append(text.subSequence(fromInclusive, toExclusive - (l - this.maxLength)));
                this.sb.append("...");
            }
        }

        @Override
        public void emphasis(boolean start) {
        }

        @Override
        public void name(ElementKind kind, boolean start) {
        }

        @Override
        public void parameters(boolean start) {
        }

        @Override
        public void active(boolean start) {
        }

        @Override
        public void type(boolean start) {
        }

        @Override
        public void deprecated(boolean start) {
        }

        @Override
        public String getText() {
            return this.sb.toString();
        }
    }
}

