/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.tasks;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.CharConversionException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.bugtracking.IssueImpl;
import org.netbeans.modules.bugtracking.QueryImpl;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.RepositoryRegistry;
import org.netbeans.modules.bugtracking.commons.UIUtils;
import org.netbeans.modules.bugtracking.spi.IssueScheduleInfo;
import org.netbeans.modules.bugtracking.spi.IssueStatusProvider;
import org.netbeans.modules.bugtracking.tasks.Bundle;
import org.netbeans.modules.bugtracking.tasks.Category;
import org.netbeans.modules.bugtracking.tasks.DashboardTopComponent;
import org.netbeans.modules.bugtracking.tasks.FilterPanel;
import org.netbeans.modules.bugtracking.tasks.QuickSearchPanel;
import org.netbeans.modules.bugtracking.tasks.actions.Actions;
import org.netbeans.modules.bugtracking.tasks.cache.DashboardStorage;
import org.netbeans.modules.bugtracking.tasks.cache.TaskEntry;
import org.netbeans.modules.bugtracking.tasks.dashboard.CategoryNode;
import org.netbeans.modules.bugtracking.tasks.dashboard.DashboardViewer;
import org.netbeans.modules.bugtracking.tasks.dashboard.RepositoryNode;
import org.netbeans.modules.bugtracking.tasks.dashboard.TaskNode;
import org.netbeans.modules.bugtracking.ui.issue.IssueAction;
import org.netbeans.modules.team.commons.treelist.TreeListNode;
import org.netbeans.modules.team.ide.spi.IDEServices;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.FindAction;
import org.openide.util.ChangeSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.SharedClassObject;
import org.openide.util.actions.Presenter;
import org.openide.xml.XMLUtil;

public class DashboardUtils {
    private static final int VISIBLE_START_CHARS = 5;
    private static final String BOLD_START_SUBSTITUTE = "$$$BOLD_START$$$";
    private static final String BOLD_END_SUBSTITUTE = "$$$BOLD_END$$$";
    private static final String NEW_COLOR = UIUtils.getColorString((Color)UIUtils.getTaskNewColor());
    private static final String MODIFIED_COLOR = UIUtils.getColorString((Color)UIUtils.getTaskModifiedColor());
    private static final String CONFLICT_COLOR = UIUtils.getColorString((Color)UIUtils.getTaskConflictColor());
    private static final Image SCHEDULE_ICON = ImageUtilities.loadImage((String)"org/netbeans/modules/bugtracking/tasks/resources/schedule.png", (boolean)true);
    private static final Image SCHEDULE_WARNING_ICON = ImageUtilities.loadImage((String)"org/netbeans/modules/bugtracking/tasks/resources/schedule_alarm.png", (boolean)true);
    private static final int SCHEDULE_NOT_IN_SCHEDULE = 0;
    private static final int SCHEDULE_IN_SCHEDULE = 1;
    private static final int SCHEDULE_AFTER_DUE = 2;

    public static String getCategoryDisplayText(CategoryNode categoryNode) {
        String categoryName = categoryNode.getCategory().getName();
        boolean containsActiveTask = DashboardViewer.getInstance().containsActiveTask((TreeListNode)categoryNode);
        return DashboardUtils.getTopLvlDisplayText(containsActiveTask, categoryName, categoryNode.isOpened());
    }

    public static String getRepositoryDisplayText(RepositoryNode repositoryNode) {
        String repositoryName = repositoryNode.getRepository().getDisplayName();
        boolean containsActiveTask = DashboardViewer.getInstance().containsActiveTask((TreeListNode)repositoryNode);
        return DashboardUtils.getTopLvlDisplayText(containsActiveTask, repositoryName, repositoryNode.isOpened());
    }

    private static String getTopLvlDisplayText(boolean containsActiveTask, String name, boolean isOpened) {
        try {
            name = XMLUtil.toElementContent((String)name);
        }
        catch (CharConversionException charConversionException) {
            // empty catch block
        }
        String activeText = containsActiveTask ? "<b>" + name + "</b>" : name;
        String displayName = !isOpened ? "<html><strike>" + activeText + "</strike><html>" : "<html>" + activeText + "<html>";
        return displayName;
    }

    public static String getTaskPlainDisplayText(IssueImpl task, JComponent component, int maxWidth) {
        return DashboardUtils.computeFitText(component, maxWidth, DashboardUtils.getTaskDisplayName(task), false);
    }

    public static String getTaskDisplayText(IssueImpl task, JComponent component, int maxWidth, boolean active, boolean hasFocus) {
        String fitText = DashboardUtils.computeFitText(component, maxWidth, DashboardUtils.getTaskDisplayName(task), active);
        boolean html = false;
        String text = DashboardUtils.getFilterBoldText(fitText);
        if (text.length() != fitText.length() || active || task.isFinished()) {
            text = DashboardUtils.escapeXmlChars(text);
        }
        if (text.length() != fitText.length()) {
            html = true;
        }
        if (active) {
            text = BOLD_START_SUBSTITUTE + fitText + BOLD_END_SUBSTITUTE;
            html = true;
        }
        text = DashboardUtils.replaceSubstitutes(text);
        if (task.isFinished()) {
            text = "<strike>" + text + "</strike>";
            html = true;
        }
        return DashboardUtils.getTaskAnotatedText(text, task.getStatus(), hasFocus, html, task.isFinished());
    }

    public static String computeFitText(JComponent component, int maxWidth, String text, boolean bold) {
        String sufix;
        if (text == null) {
            text = "";
        }
        if (text.length() <= 8) {
            return text;
        }
        int width = maxWidth;
        FontMetrics fm = bold ? component.getFontMetrics(component.getFont().deriveFont(1)) : component.getFontMetrics(component.getFont());
        int sufixLength = fm.stringWidth((sufix = "...") + " ");
        int desired = width - sufixLength;
        if (desired <= 0) {
            return text;
        }
        for (int i = 0; i <= text.length() - 1; ++i) {
            String prefix = text.substring(0, i);
            int swidth = fm.stringWidth(prefix);
            if (swidth < desired) continue;
            if (fm.stringWidth(text.substring(i + 1)) <= fm.stringWidth(sufix)) {
                return text;
            }
            return prefix.length() > 0 ? prefix + sufix : text;
        }
        return text;
    }

    public static String getTaskAnotatedText(IssueImpl task) {
        return DashboardUtils.getTaskAnotatedText(DashboardUtils.getTaskDisplayName(task), task.getStatus(), false, false, task.isFinished());
    }

    private static String getTaskAnotatedText(String text, IssueStatusProvider.Status status, boolean hasFocus, boolean isHTML, boolean isFinished) {
        if (status == IssueStatusProvider.Status.INCOMING_NEW && !hasFocus) {
            text = "<html><font color=\"" + NEW_COLOR + "\">" + text + "</font></html>";
        } else if (status == IssueStatusProvider.Status.INCOMING_MODIFIED && !hasFocus) {
            text = "<html><font color=\"" + MODIFIED_COLOR + "\">" + text + "</font></html>";
        } else if (status == IssueStatusProvider.Status.CONFLICT && !hasFocus) {
            text = "<html><font color=\"" + CONFLICT_COLOR + "\">" + text + "</font></html>";
        } else if (isHTML) {
            text = "<html>" + text + "</html>";
        }
        return text;
    }

    private static String escapeXmlChars(String text) {
        String result = text;
        try {
            result = XMLUtil.toElementContent((String)text);
        }
        catch (CharConversionException charConversionException) {
            // empty catch block
        }
        return result;
    }

    static String getTaskDisplayName(IssueImpl task) {
        String displayName = task.getDisplayName();
        if (displayName.startsWith("#")) {
            displayName = displayName.replaceFirst("#", "");
        }
        return displayName;
    }

    private static String getFilterBoldText(String fitText) {
        String filterText = FilterPanel.getInstance().getFilterText();
        if (!filterText.equals("")) {
            int searchIndex = 0;
            StringBuilder sb = new StringBuilder(fitText);
            int index = sb.toString().toLowerCase().indexOf(filterText.toLowerCase(), searchIndex);
            while (index != -1) {
                sb.insert(index, BOLD_START_SUBSTITUTE);
                index = index + BOLD_START_SUBSTITUTE.length() + filterText.length();
                sb.insert(index, BOLD_END_SUBSTITUTE);
                searchIndex = index + BOLD_END_SUBSTITUTE.length();
                index = sb.toString().toLowerCase().indexOf(filterText.toLowerCase(), searchIndex);
            }
            return sb.toString();
        }
        return fitText;
    }

    public static String getFindActionMapKey() {
        return ((FindAction)SharedClassObject.findObject(FindAction.class, (boolean)true)).getActionMapKey().toString();
    }

    private static String replaceSubstitutes(String text) {
        text = text.replace(BOLD_START_SUBSTITUTE, "<b>");
        return text.replace(BOLD_END_SUBSTITUTE, "</b>");
    }

    public static void quickSearchTask(RepositoryImpl repositoryImpl) {
        JButton open = new JButton(NbBundle.getMessage(DashboardTopComponent.class, (String)"OPTION_Open"));
        open.setEnabled(false);
        JButton cancel = new JButton(NbBundle.getMessage(DashboardTopComponent.class, (String)"OPTION_Cancel"));
        QuickSearchPanel quickSearchPanel = new QuickSearchPanel(repositoryImpl);
        NotifyDescriptor quickSearchDialog = new NotifyDescriptor((Object)quickSearchPanel, NbBundle.getMessage(DashboardTopComponent.class, (String)"LBL_QuickTitle", (Object)repositoryImpl.getDisplayName()), 2, -1, new Object[]{open, cancel}, (Object)open);
        quickSearchDialog.setValid(false);
        QuickSearchListener quickSearchListener = new QuickSearchListener(quickSearchPanel, open);
        quickSearchPanel.addQuickSearchListener(quickSearchListener);
        Object result = DialogDisplayer.getDefault().notify(quickSearchDialog);
        if (result == open) {
            IssueImpl issueImpl = quickSearchPanel.getSelectedTask();
            IssueAction.openIssue(issueImpl.getRepositoryImpl(), issueImpl.getID());
            Category selectedCategory = quickSearchPanel.getSelectedCategory();
            if (selectedCategory != null) {
                DashboardViewer.getInstance().addTaskToCategory(selectedCategory, new TaskNode(issueImpl, null));
            }
        }
        quickSearchPanel.removeQuickSearchListener(quickSearchListener);
    }

    public static boolean isRepositoryOpened(String repositoryId) {
        List<String> closedIds = DashboardStorage.getInstance().readClosedRepositories();
        return !closedIds.contains(repositoryId);
    }

    public static void loadCategory(Category category) {
        DashboardStorage storage = DashboardStorage.getInstance();
        List<TaskEntry> taskEntries = storage.readCategory(category.getName());
        category.setTasks(DashboardUtils.loadTasks(taskEntries));
    }

    public static Collection<RepositoryImpl> getRepositories() {
        return RepositoryRegistry.getInstance().getKnownRepositories(false, true);
    }

    private static List<IssueImpl> loadTasks(List<TaskEntry> taskEntries) {
        ArrayList<IssueImpl> tasks = new ArrayList<IssueImpl>(taskEntries.size());
        HashMap<String, LinkedList<String>> repository2Ids = new HashMap<String, LinkedList<String>>();
        for (TaskEntry taskEntry : taskEntries) {
            LinkedList<String> idList = (LinkedList<String>)repository2Ids.get(taskEntry.getRepositoryId());
            if (idList == null) {
                idList = new LinkedList<String>();
                repository2Ids.put(taskEntry.getRepositoryId(), idList);
            }
            idList.add(taskEntry.getIssueId());
        }
        for (Map.Entry entry : repository2Ids.entrySet()) {
            List l;
            Collection<IssueImpl> issues;
            RepositoryImpl repository = DashboardUtils.getRepository((String)entry.getKey());
            if (repository == null || (issues = repository.getIssueImpls((l = (List)entry.getValue()).toArray(new String[0]))) == null) continue;
            tasks.addAll(issues);
        }
        return tasks;
    }

    private static RepositoryImpl getRepository(String repositoryId) {
        Collection<RepositoryImpl> repositories = DashboardUtils.getRepositories();
        for (RepositoryImpl repository : repositories) {
            if (!repository.getId().equals(repositoryId)) continue;
            return repository;
        }
        return null;
    }

    public static Icon getTaskIcon(IssueImpl issue) {
        Image priorityIcon = issue.getPriorityIcon();
        Image scheduleIcon = DashboardUtils.getScheduleIcon(issue);
        if (scheduleIcon != null) {
            return ImageUtilities.image2Icon((Image)ImageUtilities.mergeImages((Image)priorityIcon, (Image)scheduleIcon, (int)0, (int)0));
        }
        return ImageUtilities.image2Icon((Image)priorityIcon);
    }

    public static int getScheduleIndex(IssueImpl issue) {
        boolean afterDue = DashboardUtils.isAfterDue(issue);
        boolean scheduleNow = DashboardUtils.isInSchedule(issue);
        if (afterDue) {
            return 2;
        }
        if (scheduleNow) {
            return 1;
        }
        return 0;
    }

    private static Image getScheduleIcon(IssueImpl issue) {
        boolean afterDue = DashboardUtils.isAfterDue(issue);
        boolean scheduleNow = DashboardUtils.isInSchedule(issue);
        if (afterDue) {
            return SCHEDULE_WARNING_ICON;
        }
        if (scheduleNow) {
            return SCHEDULE_ICON;
        }
        return null;
    }

    private static boolean isAfterDue(IssueImpl issue) {
        Calendar now = Calendar.getInstance();
        Calendar dueDate = Calendar.getInstance();
        IssueScheduleInfo schedule = issue.getSchedule();
        if (issue.getDueDate() != null) {
            dueDate.setTime(issue.getDueDate());
        } else if (schedule != null) {
            dueDate.setTime(schedule.getDate());
            dueDate.add(5, schedule.getInterval());
        } else {
            return false;
        }
        return now.get(1) >= dueDate.get(1) && now.get(6) >= dueDate.get(6);
    }

    private static boolean isInSchedule(IssueImpl issue) {
        Calendar now = Calendar.getInstance();
        IssueScheduleInfo scheduleInfo = issue.getSchedule();
        if (scheduleInfo == null) {
            return false;
        }
        Calendar scheduleStart = Calendar.getInstance();
        scheduleStart.setTime(scheduleInfo.getDate());
        Calendar scheduleEnd = Calendar.getInstance();
        scheduleEnd.setTime(scheduleInfo.getDate());
        scheduleEnd.add(5, scheduleInfo.getInterval());
        return now.getTimeInMillis() >= scheduleStart.getTimeInMillis() && now.getTimeInMillis() <= scheduleEnd.getTimeInMillis();
    }

    public static int compareTaskIds(String id1, String id2) {
        int id = 0;
        boolean isIdNumeric = true;
        try {
            id = Integer.parseInt(id1);
        }
        catch (NumberFormatException numberFormatException) {
            isIdNumeric = false;
        }
        int idOther = 0;
        boolean isIdOtherNumberic = true;
        try {
            idOther = Integer.parseInt(id2);
        }
        catch (NumberFormatException numberFormatException) {
            isIdOtherNumberic = false;
        }
        if (isIdNumeric && isIdOtherNumberic) {
            return DashboardUtils.compareNumericId(id, idOther);
        }
        if (isIdNumeric) {
            return 1;
        }
        if (isIdOtherNumberic) {
            return -1;
        }
        return DashboardUtils.compareComplexId(id1, id2);
    }

    private static int compareNumericId(int id, int idOther) {
        if (id < idOther) {
            return -1;
        }
        if (id > idOther) {
            return 1;
        }
        return 0;
    }

    private static int compareComplexId(String id1, String id2) {
        int suffixInt2;
        int suffixInt1;
        int dividerIndex1 = id1.lastIndexOf("-");
        int dividerIndex2 = id2.lastIndexOf("-");
        if (dividerIndex1 == -1 || dividerIndex2 == -1) {
            DashboardViewer.LOG.log(Level.WARNING, "Unsupported ID format - id1: {0}, id2: {1}", new Object[]{id1, id2});
            return id1.compareTo(id2);
        }
        String prefix1 = id1.subSequence(0, dividerIndex1).toString();
        String suffix1 = id1.substring(dividerIndex1 + 1);
        String prefix2 = id2.subSequence(0, dividerIndex2).toString();
        String suffix2 = id2.substring(dividerIndex2 + 1);
        int comparePrefix = prefix1.compareTo(prefix2);
        if (comparePrefix != 0) {
            return comparePrefix;
        }
        try {
            suffixInt1 = Integer.parseInt(suffix1);
            suffixInt2 = Integer.parseInt(suffix2);
        }
        catch (NumberFormatException nfe) {
            DashboardViewer.LOG.log(Level.WARNING, "Unsupported ID format - id1: {0}, id2: {1}", new Object[]{id1, id2});
            return suffix1.compareTo(suffix2);
        }
        return DashboardUtils.compareNumericId(suffixInt1, suffixInt2);
    }

    public static boolean confirmDelete(String title, String message) {
        NotifyDescriptor nd = new NotifyDescriptor((Object)message, title, 0, 3, null, NotifyDescriptor.YES_OPTION);
        return DialogDisplayer.getDefault().notify(nd) == NotifyDescriptor.YES_OPTION;
    }

    public static SchedulingMenu createScheduleMenu(IssueScheduleInfo previousSchedule) {
        return new SchedulingMenu(previousSchedule);
    }

    public static IssueScheduleInfo getToday() {
        Calendar calendar = DashboardUtils.getTodayCalendar();
        return new IssueScheduleInfo(calendar.getTime());
    }

    public static IssueScheduleInfo getThisWeek() {
        Calendar calendar = DashboardUtils.getTodayCalendar();
        calendar.set(7, calendar.getFirstDayOfWeek());
        return new IssueScheduleInfo(calendar.getTime(), 7);
    }

    public static IssueScheduleInfo getNextWeek() {
        Calendar calendar = DashboardUtils.getTodayCalendar();
        calendar.set(7, calendar.getFirstDayOfWeek());
        calendar.add(5, 7);
        return new IssueScheduleInfo(calendar.getTime(), 7);
    }

    public static IssueScheduleInfo getAll() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(0L);
        return new IssueScheduleInfo(calendar.getTime(), Integer.MAX_VALUE);
    }

    public static Calendar getTodayCalendar() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    public static int getMillisToTomorrow() {
        Calendar now = Calendar.getInstance();
        Calendar tomorrow = DashboardUtils.getTodayCalendar();
        tomorrow.add(6, 1);
        Long millisToTomorrow = tomorrow.getTimeInMillis() - now.getTimeInMillis() + 60000L;
        return millisToTomorrow.intValue();
    }

    public static void setQueryAutoRefresh(QueryImpl q, boolean b) {
        NbPreferences.forModule(Actions.class).putBoolean(DashboardUtils.getQueryRefreshKey(q), b);
    }

    public static boolean isQueryAutoRefresh(QueryImpl q) {
        return NbPreferences.forModule(Actions.class).getBoolean(DashboardUtils.getQueryRefreshKey(q), true);
    }

    private static String getQueryRefreshKey(QueryImpl q) {
        RepositoryImpl r = q.getRepositoryImpl();
        StringBuilder sb = new StringBuilder();
        sb.append("query.auto.refresh.");
        sb.append(r.getConnectorId());
        sb.append("<=>");
        sb.append(r.getId());
        sb.append("<=>");
        sb.append(q.getDisplayName());
        return sb.toString();
    }

    private static class QuickSearchListener
    implements ChangeListener {
        private QuickSearchPanel quickSearchPanel;
        private JButton open;

        public QuickSearchListener(QuickSearchPanel quickSearchPanel, JButton open) {
            this.quickSearchPanel = quickSearchPanel;
            this.open = open;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            IssueImpl selectedTask = this.quickSearchPanel.getSelectedTask();
            this.open.setEnabled(selectedTask != null);
        }
    }

    public static final class SchedulingMenu {
        private final JMenu menu;
        private final List<JMenuItem> menuItems;
        private final ChangeSupport support = new ChangeSupport((Object)this);
        private IssueScheduleInfo scheduleInfo;

        public SchedulingMenu(final IssueScheduleInfo previousSchedule) {
            this.menu = new JMenu(NbBundle.getMessage(DashboardUtils.class, (String)"LBL_ScheduleFor"));
            this.menuItems = new ArrayList<JMenuItem>();
            for (int i = 0; i < 7; ++i) {
                Calendar calendar = DashboardUtils.getTodayCalendar();
                calendar.add(5, i);
                String itemName = calendar.getDisplayName(7, 2, Locale.getDefault());
                if (i == 0) {
                    itemName = Bundle.CTL_Today(itemName);
                }
                JCheckBoxMenuItem item = new JCheckBoxMenuItem(new ScheduleItemAction(itemName, new IssueScheduleInfo(calendar.getTime())));
                this.menu.add(item);
                this.menuItems.add(item);
            }
            this.menu.addSeparator();
            this.menuItems.add(null);
            JCheckBoxMenuItem thisWeek = new JCheckBoxMenuItem(new ScheduleItemAction(Bundle.CTL_ThisWeek(), DashboardUtils.getThisWeek()));
            this.menu.add(thisWeek);
            this.menuItems.add(thisWeek);
            JCheckBoxMenuItem nextWeek = new JCheckBoxMenuItem(new ScheduleItemAction(Bundle.CTL_NextWeek(), DashboardUtils.getNextWeek()));
            this.menu.add(nextWeek);
            this.menuItems.add(nextWeek);
            this.menu.addSeparator();
            this.menuItems.add(null);
            final IDEServices.DatePickerComponent picker = UIUtils.createDatePickerComponent();
            JCheckBoxMenuItem chooseDate = null;
            if (picker.allowsOpeningDaySelector()) {
                chooseDate = new JCheckBoxMenuItem(new ScheduleItemAction(Bundle.CTL_ChooseDate(), null){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        picker.setDate(previousSchedule == null ? new Date() : previousSchedule.getDate());
                        if (picker.openDaySelector()) {
                            Date date = picker.getDate();
                            scheduleInfo = date == null ? null : new IssueScheduleInfo(date);
                            support.fireChange();
                        }
                    }
                });
            } else if (previousSchedule != null) {
                chooseDate = new JCheckBoxMenuItem(Bundle.CTL_CustomDateChosen(DateFormat.getDateInstance(2).format(previousSchedule.getDate())));
                chooseDate.setEnabled(false);
            }
            if (chooseDate != null) {
                this.menu.add(chooseDate);
                this.menuItems.add(chooseDate);
            }
            JCheckBoxMenuItem notScheduled = new JCheckBoxMenuItem(new ScheduleItemAction(Bundle.CTL_NotScheduled(), null));
            this.menu.add(notScheduled);
            this.menuItems.add(notScheduled);
            if (previousSchedule == null) {
                notScheduled.setSelected(true);
                return;
            }
            for (JMenuItem item : this.menuItems) {
                IssueScheduleInfo assignedSchedule;
                if (item == null || !(item.getAction() instanceof ScheduleItemAction) || (assignedSchedule = ((ScheduleItemAction)item.getAction()).getAssignedSchedule()) == null || !assignedSchedule.equals(previousSchedule)) continue;
                item.setSelected(true);
                return;
            }
            if (chooseDate != null) {
                chooseDate.setSelected(true);
            }
        }

        public Action getMenuAction() {
            return new ScheduleMenuAction(this.menu);
        }

        public List<JMenuItem> getMenuItems() {
            return this.menuItems;
        }

        public IssueScheduleInfo getScheduleInfo() {
            return this.scheduleInfo;
        }

        public void addChangeListener(ChangeListener listener) {
            this.support.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.support.removeChangeListener(listener);
        }

        private class ScheduleItemAction
        extends AbstractAction {
            private final IssueScheduleInfo assignedSchedule;

            public ScheduleItemAction(String name, IssueScheduleInfo assignedSchedule) {
                super(name);
                this.assignedSchedule = assignedSchedule;
            }

            public IssueScheduleInfo getAssignedSchedule() {
                return this.assignedSchedule;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                SchedulingMenu.this.scheduleInfo = this.assignedSchedule;
                SchedulingMenu.this.support.fireChange();
            }
        }
    }

    private static class ScheduleMenuAction
    extends AbstractAction
    implements Presenter.Popup {
        private final JMenu menu;

        public ScheduleMenuAction(JMenu menu) {
            this.menu = menu;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.menu.getAction().actionPerformed(e);
        }

        @Override
        public void setEnabled(boolean newValue) {
            super.setEnabled(newValue);
            this.menu.setEnabled(newValue);
        }

        public JMenuItem getPopupPresenter() {
            return this.menu;
        }
    }
}

