/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jgit.api.CherryPickResult;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.RebaseCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.dircache.DirCacheBuildIterator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.RebaseTodoFile;
import org.eclipse.jgit.lib.RebaseTodoLine;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.merge.RecursiveMerger;
import org.eclipse.jgit.merge.StrategyRecursive;
import org.eclipse.jgit.merge.ThreeWayMerger;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.io.SafeBufferedOutputStream;
import org.netbeans.libs.git.GitCherryPickResult;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.GitStatus;
import org.netbeans.libs.git.jgit.DelegatingGitProgressMonitor;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.ConflictCommand;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.jgit.commands.ResetCommand;
import org.netbeans.libs.git.progress.FileListener;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.netbeans.libs.git.progress.StatusListener;

public class CherryPickCommand
extends GitCommand {
    private final String[] revisions;
    private GitCherryPickResult result;
    private final ProgressMonitor monitor;
    private final GitClient.CherryPickOperation operation;
    private final FileListener listener;
    private static final String SEQUENCER = "sequencer";
    private static final String SEQUENCER_HEAD = "head";
    private static final String SEQUENCER_TODO = "todo";
    private boolean workAroundStrategyIssue = true;

    public CherryPickCommand(Repository repository, GitClassFactory gitFactory, String[] revisions, GitClient.CherryPickOperation operation, ProgressMonitor monitor, FileListener listener) {
        super(repository, gitFactory, monitor);
        this.revisions = revisions;
        this.operation = operation;
        this.monitor = monitor;
        this.listener = listener;
    }

    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        ObjectId originalCommit = this.getOriginalCommit();
        ObjectId head = this.getHead();
        try {
            block1 : switch (this.operation) {
                case BEGIN: {
                    List<RebaseTodoLine> steps = this.prepareCommand(head);
                    this.applySteps(steps, false);
                    break;
                }
                case ABORT: {
                    if ((repository.getRepositoryState() == RepositoryState.CHERRY_PICKING || repository.getRepositoryState() == RepositoryState.CHERRY_PICKING_RESOLVED) && originalCommit == null) {
                        originalCommit = head;
                    }
                    Utils.deleteRecursively(this.getSequencerFolder());
                    if (originalCommit != null) {
                        ResetCommand reset = new ResetCommand(repository, this.getClassFactory(), originalCommit.name(), GitClient.ResetType.HARD, new DelegatingGitProgressMonitor(this.monitor), this.listener);
                        reset.execute();
                    }
                    this.result = this.createCustomResult(GitCherryPickResult.CherryPickStatus.ABORTED);
                    break;
                }
                case QUIT: {
                    Utils.deleteRecursively(this.getSequencerFolder());
                    switch (repository.getRepositoryState()) {
                        case CHERRY_PICKING: {
                            this.result = this.createResult(CherryPickResult.CONFLICT);
                            break block1;
                        }
                        case CHERRY_PICKING_RESOLVED: {
                            this.result = this.createCustomResult(GitCherryPickResult.CherryPickStatus.UNCOMMITTED);
                            break block1;
                        }
                    }
                    this.result = this.createCustomResult(GitCherryPickResult.CherryPickStatus.OK);
                    break;
                }
                case CONTINUE: {
                    switch (repository.getRepositoryState()) {
                        case CHERRY_PICKING: {
                            this.result = this.createResult(CherryPickResult.CONFLICT);
                            break block1;
                        }
                        case CHERRY_PICKING_RESOLVED: {
                            this.result = this.createCustomResult(GitCherryPickResult.CherryPickStatus.UNCOMMITTED);
                            break block1;
                        }
                    }
                    List<RebaseTodoLine> steps = this.readTodoFile(repository);
                    this.applySteps(steps, true);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected operation " + this.operation.name());
                }
            }
        }
        catch (IOException | GitAPIException ex) {
            throw new GitException(ex);
        }
    }

    @Override
    protected String getCommandDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("git cherry-pick ");
        if (this.operation == GitClient.CherryPickOperation.BEGIN) {
            for (String rev : this.revisions) {
                sb.append(rev).append(" ");
            }
        } else {
            sb.append(this.operation.toString());
        }
        return sb.toString();
    }

    public GitCherryPickResult getResult() {
        return this.result;
    }

    static RebaseCommand.Operation getOperation(GitClient.RebaseOperationType operation) {
        return RebaseCommand.Operation.valueOf((String)operation.name());
    }

    private void applySteps(List<RebaseTodoLine> steps, boolean skipFirstStep) throws GitAPIException, IOException {
        Repository repository = this.getRepository();
        ObjectReader or = repository.newObjectReader();
        CherryPickResult res = null;
        boolean skipped = false;
        ArrayList<Ref> cherryPickedRefs = new ArrayList<Ref>();
        Iterator<RebaseTodoLine> it = steps.iterator();
        while (it.hasNext()) {
            RebaseTodoLine step = it.next();
            if (step.getAction() == RebaseTodoLine.Action.PICK) {
                if (skipFirstStep && !skipped) {
                    it.remove();
                    this.writeTodoFile(repository, steps);
                    skipped = true;
                    continue;
                }
                Collection ids = or.resolve(step.getCommit());
                if (ids.size() != 1) {
                    throw new JGitInternalException("Could not resolve uniquely the abbreviated object ID");
                }
                org.eclipse.jgit.api.CherryPickCommand command = new Git(repository).cherryPick();
                command.include((AnyObjectId)ids.iterator().next());
                if (this.workAroundStrategyIssue) {
                    command.setStrategy((MergeStrategy)new FailuresDetectRecurciveStrategy());
                }
                if ((res = command.call()).getStatus() != CherryPickResult.CherryPickStatus.OK) break;
                it.remove();
                this.writeTodoFile(repository, steps);
                cherryPickedRefs.addAll(res.getCherryPickedRefs());
                continue;
            }
            it.remove();
        }
        this.result = res == null ? this.createCustomResult(GitCherryPickResult.CherryPickStatus.OK, cherryPickedRefs) : this.createResult(res, cherryPickedRefs);
        if (steps.isEmpty()) {
            Utils.deleteRecursively(this.getSequencerFolder());
        }
    }

    private GitCherryPickResult createResult(CherryPickResult res) {
        return this.createResult(res, Collections.emptyList());
    }

    private GitCherryPickResult createResult(CherryPickResult res, List<Ref> cherryPickedRefs) {
        GitRevisionInfo currHead = this.getCurrentHead();
        GitCherryPickResult.CherryPickStatus status = GitCherryPickResult.CherryPickStatus.valueOf(res.getStatus().name());
        List<File> conflicts = res.getStatus() == CherryPickResult.CherryPickStatus.CONFLICTING ? this.getConflicts(currHead) : Collections.emptyList();
        List<GitRevisionInfo> commits = this.toCommits(cherryPickedRefs);
        return this.getClassFactory().createCherryPickResult(status, conflicts, this.getFailures(res), currHead, commits);
    }

    private List<GitRevisionInfo> toCommits(List<Ref> cherryPickedRefs) {
        ArrayList<GitRevisionInfo> commits = new ArrayList<GitRevisionInfo>(cherryPickedRefs.size());
        Repository repository = this.getRepository();
        RevWalk walk = new RevWalk(repository);
        for (Ref ref : cherryPickedRefs) {
            try {
                commits.add(this.getClassFactory().createRevisionInfo(Utils.findCommit(repository, ref.getLeaf().getObjectId(), walk), repository));
            }
            catch (GitException ex) {
                Logger.getLogger(CherryPickCommand.class.getName()).log(Level.INFO, null, ex);
            }
        }
        return commits;
    }

    private GitRevisionInfo getCurrentHead() {
        GitRevisionInfo currHead;
        Repository repository = this.getRepository();
        try {
            currHead = this.getClassFactory().createRevisionInfo(Utils.findCommit(repository, "HEAD"), repository);
        }
        catch (GitException ex) {
            currHead = null;
        }
        return currHead;
    }

    private GitCherryPickResult createCustomResult(GitCherryPickResult.CherryPickStatus status) {
        return this.createCustomResult(status, Collections.emptyList());
    }

    private GitCherryPickResult createCustomResult(GitCherryPickResult.CherryPickStatus status, List<Ref> cherryPickedRefs) {
        return this.getClassFactory().createCherryPickResult(status, Collections.emptyList(), Collections.emptyList(), this.getCurrentHead(), this.toCommits(cherryPickedRefs));
    }

    private List<File> getConflicts(GitRevisionInfo info) {
        List<File> conflicts;
        try {
            Repository repository = this.getRepository();
            ConflictCommand cmd = new ConflictCommand(repository, this.getClassFactory(), new File[0], new DelegatingGitProgressMonitor(this.monitor), new StatusListener(){

                @Override
                public void notifyStatus(GitStatus status) {
                }
            });
            cmd.execute();
            Map<File, GitStatus> statuses = cmd.getStatuses();
            conflicts = new ArrayList<File>(statuses.size());
            for (Map.Entry<File, GitStatus> e : statuses.entrySet()) {
                if (!e.getValue().isConflict()) continue;
                conflicts.add(e.getKey());
            }
        }
        catch (GitException ex) {
            Logger.getLogger(CherryPickCommand.class.getName()).log(Level.INFO, null, ex);
            conflicts = Collections.emptyList();
        }
        return conflicts;
    }

    private List<File> getFailures(CherryPickResult result) {
        Map obstructions;
        ArrayList<File> files = new ArrayList<File>();
        File workDir = this.getRepository().getWorkTree();
        if (result.getStatus() == CherryPickResult.CherryPickStatus.FAILED && (obstructions = result.getFailingPaths()) != null) {
            for (Map.Entry failure : obstructions.entrySet()) {
                files.add(new File(workDir, (String)failure.getKey()));
            }
        }
        return Collections.unmodifiableList(files);
    }

    private File getSequencerFolder() {
        return new File(this.getRepository().getDirectory(), SEQUENCER);
    }

    private ObjectId getOriginalCommit() throws GitException {
        Repository repository = this.getRepository();
        File seqHead = new File(this.getSequencerFolder(), SEQUENCER_HEAD);
        ObjectId originalCommitId = null;
        if (seqHead.canRead()) {
            try {
                byte[] content = IO.readFully((File)seqHead);
                if (content.length > 0) {
                    originalCommitId = ObjectId.fromString((byte[])content, (int)0);
                }
                if (originalCommitId != null) {
                    originalCommitId = repository.resolve(originalCommitId.getName() + "^{commit}");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return originalCommitId;
    }

    private ObjectId getHead() throws GitException {
        return Utils.findCommit(this.getRepository(), "HEAD");
    }

    private List<RebaseTodoLine> prepareCommand(ObjectId head) throws GitException, IOException {
        Repository repository = this.getRepository();
        ObjectReader or = repository.newObjectReader();
        RevWalk walk = new RevWalk(or);
        ArrayList<RevCommit> commits = new ArrayList<RevCommit>(this.revisions.length);
        for (String rev : this.revisions) {
            RevCommit commit = Utils.findCommit(repository, rev, walk);
            commits.add(commit);
        }
        ArrayList<RebaseTodoLine> steps = new ArrayList<RebaseTodoLine>(commits.size());
        if (commits.size() == 1) {
            RevCommit commit = (RevCommit)commits.get(0);
            steps.add(new RebaseTodoLine(RebaseTodoLine.Action.PICK, or.abbreviate((AnyObjectId)commit), commit.getShortMessage()));
        } else if (!commits.isEmpty()) {
            File sequencer = this.getSequencerFolder();
            sequencer.mkdirs();
            try {
                for (RevCommit commit : commits) {
                    steps.add(new RebaseTodoLine(RebaseTodoLine.Action.PICK, or.abbreviate((AnyObjectId)commit), commit.getShortMessage()));
                }
                this.writeTodoFile(repository, steps);
                this.writeFile(new File(sequencer, SEQUENCER_HEAD), head);
            }
            catch (IOException ex) {
                Utils.deleteRecursively(sequencer);
                throw new GitException(ex);
            }
        }
        return steps;
    }

    private void writeFile(File file, ObjectId id) throws IOException {
        try (SafeBufferedOutputStream bos = new SafeBufferedOutputStream((OutputStream)new FileOutputStream(file));){
            id.copyTo((OutputStream)bos);
            bos.write(10);
        }
    }

    private void writeTodoFile(Repository repository, List<RebaseTodoLine> steps) throws IOException {
        File f = new File(repository.getDirectory(), SEQUENCER);
        if (f.canWrite()) {
            RebaseTodoFile todoFile = new RebaseTodoFile(repository);
            todoFile.writeRebaseTodoFile(SEQUENCER + File.separator + SEQUENCER_TODO, steps, false);
        }
    }

    private List<RebaseTodoLine> readTodoFile(Repository repository) throws IOException {
        String path = SEQUENCER + File.separator + SEQUENCER_TODO;
        File f = new File(repository.getDirectory(), path);
        if (f.canRead()) {
            RebaseTodoFile todoFile = new RebaseTodoFile(repository);
            return todoFile.readRebaseTodo(SEQUENCER + File.separator + SEQUENCER_TODO, true);
        }
        return Collections.emptyList();
    }

    private class FailuresDetectRecurciveStrategy
    extends StrategyRecursive {
        private FailuresDetectRecurciveStrategy() {
        }

        public ThreeWayMerger newMerger(Repository db) {
            return this.newMerger(db, false);
        }

        public ThreeWayMerger newMerger(Repository db, boolean inCore) {
            return new RecursiveMerger(db, inCore){

                protected boolean mergeTreeWalk(TreeWalk treeWalk, boolean ignoreConflicts) throws IOException {
                    boolean hasWorkingTreeIterator;
                    boolean ok = true;
                    boolean bl = hasWorkingTreeIterator = this.tw.getTreeCount() > 4;
                    while (treeWalk.next()) {
                        if (!this.processEntry((CanonicalTreeParser)treeWalk.getTree(0, CanonicalTreeParser.class), (CanonicalTreeParser)treeWalk.getTree(1, CanonicalTreeParser.class), (CanonicalTreeParser)treeWalk.getTree(2, CanonicalTreeParser.class), (DirCacheBuildIterator)treeWalk.getTree(3, DirCacheBuildIterator.class), hasWorkingTreeIterator ? (WorkingTreeIterator)treeWalk.getTree(4, WorkingTreeIterator.class) : null, ignoreConflicts)) {
                            ok = false;
                        }
                        if (!treeWalk.isSubtree() || !this.enterSubtree) continue;
                        treeWalk.enterSubtree();
                    }
                    if (!ok) {
                        this.cleanUp();
                    }
                    return ok;
                }
            };
        }
    }
}

