/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.xml.cookies;

import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.netbeans.api.xml.cookies.XMLProcessorDetail;
import org.netbeans.spi.xml.cookies.Util;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DefaultXMLProcessorDetail
extends XMLProcessorDetail {
    private int columnNumber;
    private int lineNumber;
    private String publicId;
    private String systemId;
    private Exception exception;

    public DefaultXMLProcessorDetail(SAXParseException spex) {
        if (spex == null) {
            throw new NullPointerException();
        }
        this.exception = spex;
        this.columnNumber = spex.getColumnNumber();
        this.lineNumber = spex.getLineNumber();
        this.publicId = spex.getPublicId();
        this.systemId = spex.getSystemId();
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("DefaultXMLProcessorDetail: SAXParseException");
            Util.THIS.debug("    exception= " + this.exception);
            Util.THIS.debug("    columnNumber= " + this.columnNumber);
            Util.THIS.debug("    lineNumber= " + this.lineNumber);
            Util.THIS.debug("    publicId= " + this.publicId);
            Util.THIS.debug("    systemId= " + this.systemId);
        }
    }

    public DefaultXMLProcessorDetail(TransformerException trex) {
        if (trex == null) {
            throw new NullPointerException();
        }
        this.exception = trex;
        SourceLocator locator = trex.getLocator();
        if (locator != null) {
            this.columnNumber = locator.getColumnNumber();
            this.lineNumber = locator.getLineNumber();
            this.publicId = locator.getPublicId();
            this.systemId = locator.getSystemId();
            if (this.lineNumber == -1) {
                this.tryWrappedLocator(trex);
            }
        } else {
            this.columnNumber = -1;
            this.lineNumber = -1;
            this.publicId = null;
            this.systemId = null;
            this.tryWrappedLocator(trex);
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("DefaultXMLProcessorDetail: TransformerException");
            Util.THIS.debug("    exception= " + this.exception);
            Util.THIS.debug("    columnNumber= " + this.columnNumber);
            Util.THIS.debug("    lineNumber= " + this.lineNumber);
            Util.THIS.debug("    publicId= " + this.publicId);
            Util.THIS.debug("    systemId= " + this.systemId);
        }
    }

    private void tryWrappedLocator(Exception ex) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("DefaultXMLProcessorDetail.tryWrappedLocator: " + ex);
        }
        Throwable wrapped = null;
        if (ex instanceof TransformerException) {
            wrapped = ((TransformerException)ex).getException();
        } else if (ex instanceof SAXException) {
            wrapped = ((SAXException)ex).getException();
        } else {
            return;
        }
        if (wrapped instanceof SAXParseException) {
            SAXParseException pex = (SAXParseException)wrapped;
            if (pex.getLineNumber() == -1) {
                this.tryWrappedLocator(pex);
            } else {
                this.columnNumber = pex.getColumnNumber();
                this.lineNumber = pex.getLineNumber();
                this.publicId = pex.getPublicId();
                this.systemId = pex.getSystemId();
            }
        } else if (wrapped instanceof TransformerException) {
            TransformerException wrappedTransformerEx = (TransformerException)wrapped;
            SourceLocator locator = wrappedTransformerEx.getLocator();
            if (locator == null) {
                this.tryWrappedLocator(wrappedTransformerEx);
            } else if (locator.getLineNumber() == -1) {
                this.tryWrappedLocator(wrappedTransformerEx);
            } else {
                this.columnNumber = locator.getColumnNumber();
                this.lineNumber = locator.getLineNumber();
                this.publicId = locator.getPublicId();
                this.systemId = locator.getSystemId();
            }
        } else if (wrapped instanceof SAXException) {
            this.tryWrappedLocator((SAXException)wrapped);
        }
    }

    @Override
    public int getColumnNumber() {
        return this.columnNumber;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public String getPublicId() {
        return this.publicId;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public Exception getException() {
        return this.exception;
    }
}

