/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.templates;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.api.scripting.Scripting;
import org.netbeans.api.templates.CreateDescriptor;
import org.netbeans.api.templates.CreateFromTemplateHandler;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class ScriptingCreateFromTemplateHandler
extends CreateFromTemplateHandler {
    private static final Logger LOG = Logger.getLogger(ScriptingCreateFromTemplateHandler.class.getName());
    public static final String SCRIPT_ENGINE_ATTR = "javax.script.ScriptEngine";
    private static ScriptEngineManager manager;
    private static final String ENCODING_PROPERTY_NAME = "encoding";
    private static final String ID_INDENT_ENGINE = "org.netbeans.api.templates.IndentEngine";

    @Override
    public boolean accept(CreateDescriptor desc) {
        return ScriptingCreateFromTemplateHandler.engine(desc.getTemplate()) != null;
    }

    @Override
    public List<FileObject> createFromTemplate(CreateDescriptor desc) throws IOException {
        String extWithDot;
        boolean noExt;
        FileObject template = desc.getTemplate();
        String name = desc.getProposedName();
        HashMap<String, Object> values = new HashMap<String, Object>(desc.getParameters());
        FileObject f = desc.getTarget();
        boolean bl = noExt = desc.hasFreeExtension() && name.indexOf(46) != -1;
        if (noExt) {
            extWithDot = null;
        } else {
            extWithDot = "." + template.getExt();
            if (name.endsWith(extWithDot)) {
                name = name.substring(0, name.length() - extWithDot.length());
            }
        }
        String nameUniq = FileUtil.findFreeFileName((FileObject)f, (String)name, (String)(noExt ? null : template.getExt()));
        ScriptEngine eng = ScriptingCreateFromTemplateHandler.engine(template);
        Bindings bind = eng.getContext().getBindings(100);
        if (!values.containsKey("name")) {
            values.put("name", nameUniq);
        }
        bind.putAll((Map<? extends String, ? extends Object>)values);
        if (desc.getTemplate().isFolder()) {
            FileObject folder = FileUtil.createFolder((FileObject)desc.getTarget(), (String)nameUniq);
            CreateFromTemplateHandler.copyAttributesFromTemplate(null, desc.getTemplate(), folder);
            return CreateFromTemplateHandler.defaultCopyContents(desc, desc.getTemplate(), folder);
        }
        FileObject output = FileUtil.createData((FileObject)f, (String)(noExt ? nameUniq : nameUniq + extWithDot));
        Charset targetEnc = FileEncodingQuery.getEncoding((FileObject)output);
        Charset sourceEnc = FileEncodingQuery.getEncoding((FileObject)template);
        if (!values.containsKey(ENCODING_PROPERTY_NAME)) {
            bind.put(ENCODING_PROPERTY_NAME, (Object)targetEnc.name());
        }
        FileLock lock = output.lock();
        try (OutputStreamWriter w = new OutputStreamWriter(output.getOutputStream(lock), targetEnc);
             InputStreamReader is = new InputStreamReader(template.getInputStream(), sourceEnc);){
            StringWriter sw = new StringWriter();
            ScriptEngine eng2 = desc.isPreformatted() ? null : ScriptingCreateFromTemplateHandler.indentEngine();
            eng.getContext().setWriter(new PrintWriter(eng2 != null ? sw : w));
            eng.getContext().setAttribute(FileObject.class.getName(), template, 100);
            eng.getContext().setAttribute("javax.script.filename", template.getNameExt(), 100);
            eng.eval(is);
            if (eng2 != null) {
                eng2.getContext().setAttribute("mimeType", template.getMIMEType(), 100);
                eng2.getContext().setWriter(w);
                eng2.eval(new StringReader(sw.toString()));
            }
        }
        catch (ScriptException ex) {
            IOException io = new IOException(ex.getMessage(), ex);
            throw io;
        }
        finally {
            lock.releaseLock();
        }
        return Collections.singletonList(output);
    }

    public static ScriptEngine indentEngine() {
        return ScriptingCreateFromTemplateHandler.getEngine(ID_INDENT_ENGINE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScriptEngine getEngine(String engName) {
        Class<ScriptingCreateFromTemplateHandler> clazz = ScriptingCreateFromTemplateHandler.class;
        synchronized (ScriptingCreateFromTemplateHandler.class) {
            if (manager == null) {
                manager = Scripting.createManager();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return manager.getEngineByName(engName);
        }
    }

    public static ScriptEngine engine(FileObject fo) {
        Object obj = fo.getAttribute(SCRIPT_ENGINE_ATTR);
        if (obj instanceof ScriptEngine) {
            return (ScriptEngine)obj;
        }
        if (obj instanceof String) {
            return ScriptingCreateFromTemplateHandler.getEngine((String)obj);
        }
        return null;
    }
}

