/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.netbeans.modules.search.ResultModel;
import org.netbeans.modules.search.Selectable;
import org.netbeans.modules.search.TextDetail;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public final class MatchingObject
implements Comparable<MatchingObject>,
Selectable {
    public static final String PROP_INVALIDITY_STATUS = "invalidityStatus";
    public static final String PROP_SELECTED = "selected";
    private static final Logger LOG = Logger.getLogger(MatchingObject.class.getName());
    private static final int FILE_READ_BUFFER_SIZE = 4096;
    private final ResultModel resultModel;
    private final FileObject fileObject;
    private DataObject dataObject;
    private final long timestamp;
    private int matchesCount = 0;
    private Node nodeDelegate = null;
    List<TextDetail> textDetails;
    private final Charset charset;
    private boolean selected = true;
    private boolean expanded = false;
    private boolean[] matchesSelection;
    private int selectedMatchesCount;
    private boolean childrenSelectionDirty;
    private boolean valid = true;
    private InvalidityStatus invalidityStatus = null;
    private StringBuilder text;
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private FileListener fileListener;
    private static final boolean REALLY_WRITE = true;

    MatchingObject(ResultModel resultModel, FileObject fileObject, Charset charset, List<TextDetail> textDetails) {
        if (resultModel == null) {
            throw new IllegalArgumentException("resultModel = null");
        }
        if (fileObject == null) {
            throw new IllegalArgumentException("object = null");
        }
        this.textDetails = textDetails;
        this.resultModel = resultModel;
        this.charset = charset;
        this.fileObject = fileObject;
        this.dataObject = this.dataObject();
        this.timestamp = fileObject.lastModified().getTime();
        boolean bl = this.valid = this.timestamp != 0L;
        if (this.dataObject != null) {
            this.matchesCount = this.computeMatchesCount();
            this.nodeDelegate = this.dataObject.getNodeDelegate();
        }
        this.setUpDataObjValidityChecking();
        if (textDetails != null && !textDetails.isEmpty()) {
            this.adjustTextDetails();
        }
    }

    private void adjustTextDetails() {
        TextDetail lastDetail = this.textDetails.get(this.textDetails.size() - 1);
        int maxLine = lastDetail.getLine();
        int maxDigits = this.countDigits(maxLine);
        for (TextDetail td : this.textDetails) {
            int digits = this.countDigits(td.getLine());
            if (digits >= maxDigits) continue;
            td.setLineNumberIndent(this.indent(maxDigits - digits));
        }
    }

    private int countDigits(int number) {
        int digits = 0;
        while (number > 0) {
            number /= 10;
            ++digits;
        }
        return digits;
    }

    private String indent(int chars) {
        switch (chars) {
            case 1: {
                return "&nbsp;&nbsp;";
            }
            case 2: {
                return "&nbsp;&nbsp;&nbsp;&nbsp;";
            }
            case 3: {
                return "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
            }
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < chars; ++i) {
            sb.append("&nbsp;&nbsp;");
        }
        return sb.toString();
    }

    private void setUpDataObjValidityChecking() {
        if (this.fileObject != null && this.fileObject.isValid()) {
            this.fileListener = new FileListener();
            this.fileObject.addFileChangeListener((FileChangeListener)this.fileListener);
        }
    }

    void cleanup() {
        if (this.fileObject != null && this.fileListener != null) {
            this.fileObject.removeFileChangeListener((FileChangeListener)this.fileListener);
            this.fileListener = null;
        }
        this.dataObject = null;
        this.nodeDelegate = null;
    }

    private void setInvalid(InvalidityStatus invalidityStatus) {
        if (this.invalidityStatus == invalidityStatus) {
            return;
        }
        InvalidityStatus oldStatus = this.invalidityStatus;
        this.valid = false;
        this.invalidityStatus = invalidityStatus;
        this.resultModel.objectBecameInvalid(this);
        if (this.fileObject != null && this.fileListener != null && invalidityStatus == InvalidityStatus.DELETED) {
            this.fileObject.removeFileChangeListener((FileChangeListener)this.fileListener);
        }
        this.changeSupport.firePropertyChange(PROP_INVALIDITY_STATUS, (Object)oldStatus, (Object)invalidityStatus);
    }

    public boolean isObjectValid() {
        return this.valid && this.dataObject != null ? this.dataObject.isValid() : false;
    }

    public FileObject getFileObject() {
        return this.fileObject;
    }

    @Override
    public void setSelected(boolean selected) {
        if (selected == this.selected) {
            return;
        }
        this.selected = selected;
        this.matchesSelection = null;
        this.changeSupport.firePropertyChange(PROP_SELECTED, !selected, selected);
    }

    @Override
    public void setSelectedRecursively(boolean selected) {
        if (this.selected == selected) {
            return;
        }
        if (this.textDetails != null) {
            for (TextDetail td : this.getTextDetails()) {
                td.setSelectedRecursively(selected);
            }
        }
        this.setSelected(selected);
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    boolean isUniformSelection() {
        return this.matchesSelection == null;
    }

    Boolean checkSubnodesSelection() {
        if (this.matchesSelection == null) {
            return this.selected;
        }
        boolean firstMatchSelection = this.matchesSelection[0];
        for (int i = 1; i < this.matchesSelection.length; ++i) {
            if (this.matchesSelection[i] == firstMatchSelection) continue;
            return null;
        }
        return firstMatchSelection;
    }

    boolean toggleSubnodeSelection(ResultModel resultModel, int index) {
        if (this.matchesSelection == null) {
            int detailsCount = resultModel.getDetailsCount(this);
            if (detailsCount == 1) {
                this.selected = !this.selected;
                return true;
            }
            this.matchesSelection = new boolean[detailsCount];
            Arrays.fill(this.matchesSelection, this.selected);
            this.matchesSelection[index] = !this.selected;
            boolean wasSelected = this.selected;
            this.selectedMatchesCount = wasSelected ? detailsCount - 1 : 1;
            this.selected = true;
            return this.selected != wasSelected;
        }
        assert (this.selected);
        assert (this.selectedMatchesCount > 0 && this.selectedMatchesCount < this.matchesSelection.length);
        boolean wasSubnodeSelected = this.matchesSelection[index];
        if (wasSubnodeSelected) {
            if (--this.selectedMatchesCount == 0) {
                this.matchesSelection = null;
                this.selected = false;
                return true;
            }
        } else if (++this.selectedMatchesCount == this.matchesSelection.length) {
            this.matchesSelection = null;
            return false;
        }
        this.matchesSelection[index] = !wasSubnodeSelected;
        return false;
    }

    boolean isSubnodeSelected(int index) {
        if (this.matchesSelection == null) {
            return this.selected;
        }
        if (index >= 0 && index < this.matchesSelection.length) {
            return this.matchesSelection[index];
        }
        LOG.log(Level.FINE, "Illegal index={0} in the case matchesSelection.length={1}", new Object[]{index, this.matchesSelection.length});
        return false;
    }

    void markChildrenSelectionDirty() {
        this.childrenSelectionDirty = true;
    }

    void markChildrenSelectionClean() {
        this.childrenSelectionDirty = false;
    }

    boolean isChildrenSelectionDirty() {
        return this.childrenSelectionDirty;
    }

    void markExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    boolean isExpanded() {
        return this.expanded;
    }

    String getName() {
        return this.getFileObject().getNameExt();
    }

    String getHtmlDisplayName() {
        return this.getFileObject().getNameExt();
    }

    long getTimestamp() {
        return this.timestamp;
    }

    String getDescription() {
        return this.getFileObject().getParent().getPath();
    }

    String getText() throws IOException {
        StringBuilder txt = this.text(false);
        return txt != null ? txt.toString() : null;
    }

    public List<TextDetail> getTextDetails() {
        return this.textDetails;
    }

    public int getDetailsCount() {
        if (this.textDetails == null) {
            return 0;
        }
        return this.textDetails.size();
    }

    public Node[] getDetails() {
        if (this.textDetails == null) {
            return null;
        }
        ArrayList<TextDetail.DetailNode> detailNodes = new ArrayList<TextDetail.DetailNode>(this.textDetails.size());
        for (TextDetail txtDetail : this.textDetails) {
            detailNodes.add(new TextDetail.DetailNode(txtDetail, false));
        }
        return detailNodes.toArray(new Node[detailNodes.size()]);
    }

    public Children getDetailsChildren(boolean replacing) {
        return new DetailsChildren(replacing);
    }

    FileLock lock() throws IOException {
        return this.getFileObject().lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StringBuilder text(boolean refreshCache) throws IOException {
        assert (!EventQueue.isDispatchThread());
        if (refreshCache || this.text == null) {
            if (this.charset == null) {
                this.text = new StringBuilder(this.getFileObject().asText());
            } else {
                this.text = new StringBuilder();
                InputStream istm = this.getFileObject().getInputStream();
                try {
                    CharsetDecoder decoder = this.charset.newDecoder();
                    InputStreamReader isr = new InputStreamReader(istm, decoder);
                    try {
                        BufferedReader br = new BufferedReader(isr, 4096);
                        try {
                            int read;
                            char[] chars = new char[4096];
                            while ((read = br.read(chars)) != -1) {
                                this.text.append(chars, 0, read);
                            }
                        }
                        finally {
                            br.close();
                        }
                    }
                    finally {
                        isr.close();
                    }
                }
                finally {
                    istm.close();
                }
            }
        }
        return this.text;
    }

    @Override
    public int compareTo(MatchingObject o) {
        if (o == null) {
            return Integer.MAX_VALUE;
        }
        return this.getName().compareToIgnoreCase(o.getName());
    }

    private DataObject dataObject() {
        try {
            return DataObject.find((FileObject)this.fileObject);
        }
        catch (DataObjectNotFoundException ex) {
            this.valid = false;
            return null;
        }
    }

    public DataObject getDataObject() {
        return this.dataObject;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    InvalidityStatus checkValidity() {
        InvalidityStatus status = this.getFreshInvalidityStatus();
        if (status != null) {
            this.valid = false;
            this.invalidityStatus = status;
        }
        return status;
    }

    public InvalidityStatus getInvalidityStatus() {
        return this.invalidityStatus;
    }

    String getInvalidityDescription() {
        InvalidityStatus status = this.getFreshInvalidityStatus();
        String descr = status != null ? status.getDescription(this.getFileObject().getPath()) : null;
        return descr;
    }

    private InvalidityStatus getFreshInvalidityStatus() {
        this.log(Level.FINER, "getInvalidityStatus()");
        FileObject f = this.getFileObject();
        if (!f.isValid()) {
            this.log(Level.FINEST, " - DELETED");
            return InvalidityStatus.DELETED;
        }
        if (f.isFolder()) {
            this.log(Level.FINEST, " - BECAME_DIR");
            return InvalidityStatus.BECAME_DIR;
        }
        long stamp = f.lastModified().getTime();
        if (stamp > this.resultModel.getStartTime()) {
            this.log(Level.SEVERE, "file's timestamp changed since start of the search");
            if (LOG.isLoggable(Level.FINEST)) {
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(stamp);
                this.log(Level.FINEST, " - file stamp:           " + stamp + " (" + cal.getTime() + ')');
                cal.setTimeInMillis(this.resultModel.getStartTime());
                this.log(Level.FINEST, " - result model created: " + this.resultModel.getStartTime() + " (" + cal.getTime() + ')');
            }
            return InvalidityStatus.CHANGED;
        }
        if (f.getSize() > Integer.MAX_VALUE) {
            return InvalidityStatus.TOO_BIG;
        }
        if (!f.canRead()) {
            return InvalidityStatus.CANT_READ;
        }
        return null;
    }

    boolean isValid() {
        return this.valid;
    }

    public void updateDataObject(DataObject updatedDataObject) {
        FileObject updatedPF = updatedDataObject.getPrimaryFile();
        if (this.dataObject == null || this.dataObject.getPrimaryFile().equals(updatedPF)) {
            if (updatedPF.isValid()) {
                this.invalidityStatus = null;
                if (this.fileListener == null) {
                    this.fileListener = new FileListener();
                    updatedPF.addFileChangeListener((FileChangeListener)this.fileListener);
                } else if (updatedPF != this.dataObject.getPrimaryFile()) {
                    this.dataObject.getPrimaryFile().removeFileChangeListener((FileChangeListener)this.fileListener);
                    updatedPF.addFileChangeListener((FileChangeListener)this.fileListener);
                }
                this.dataObject = updatedDataObject;
                this.nodeDelegate = updatedDataObject.getNodeDelegate();
                this.valid = true;
                for (TextDetail td : this.textDetails) {
                    td.updateDataObject(updatedDataObject);
                }
            }
        } else {
            throw new IllegalArgumentException("Expected data object for the same file");
        }
    }

    public InvalidityStatus replace() throws IOException {
        boolean shouldReplaceNone;
        assert (!EventQueue.isDispatchThread());
        assert (this.isSelected());
        Boolean uniformSelection = this.checkSubnodesSelection();
        boolean bl = shouldReplaceNone = uniformSelection == Boolean.FALSE;
        if (shouldReplaceNone) {
            return null;
        }
        StringBuilder content = this.text(true);
        List<TextDetail> textMatches = this.getTextDetails();
        int offsetShift = 0;
        for (int i = 0; i < textMatches.size(); ++i) {
            TextDetail textDetail = textMatches.get(i);
            if (!textDetail.isSelected()) continue;
            String matchedSubstring = content.substring(textDetail.getStartOffset() + offsetShift, textDetail.getEndOffset() + offsetShift);
            if (!matchedSubstring.equals(textDetail.getMatchedText())) {
                this.log(Level.SEVERE, "file match part differs from the expected match");
                if (LOG.isLoggable(Level.FINEST)) {
                    this.log(Level.SEVERE, " - expected line: \"" + textDetail.getMatchedText() + '\"');
                    this.log(Level.SEVERE, " - file line:     \"" + matchedSubstring + '\"');
                }
                return InvalidityStatus.CHANGED;
            }
            String replacedString = this.resultModel.basicCriteria.getReplaceExpr();
            if (this.resultModel.basicCriteria.isRegexp()) {
                Matcher m = this.resultModel.basicCriteria.getTextPattern().matcher(matchedSubstring);
                replacedString = m.replaceFirst(this.resultModel.basicCriteria.getReplaceString());
            } else if (this.resultModel.basicCriteria.isPreserveCase()) {
                replacedString = MatchingObject.adaptCase(replacedString, matchedSubstring);
            }
            content.replace(textDetail.getStartOffset() + offsetShift, textDetail.getEndOffset() + offsetShift, replacedString);
            offsetShift += replacedString.length() - matchedSubstring.length();
        }
        return null;
    }

    public static String adaptCase(String value, String casePattern) {
        if (casePattern.equals(casePattern.toUpperCase())) {
            return value.toUpperCase();
        }
        if (casePattern.equals(casePattern.toLowerCase())) {
            return value.toLowerCase();
        }
        if (Character.isUpperCase(casePattern.charAt(0))) {
            return Character.toUpperCase(value.charAt(0)) + value.substring(1);
        }
        if (Character.isLowerCase(casePattern.charAt(0))) {
            if (casePattern.substring(1).equals(casePattern.substring(1).toUpperCase())) {
                return Character.toLowerCase(value.charAt(0)) + value.substring(1).toUpperCase();
            }
            return Character.toLowerCase(value.charAt(0)) + value.substring(1);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(FileLock fileLock) throws IOException {
        if (this.text == null) {
            throw new IllegalStateException("Buffer is gone");
        }
        Writer writer = null;
        try {
            writer = new OutputStreamWriter(this.fileObject.getOutputStream(fileLock), this.charset);
            writer.write(this.makeStringToWrite());
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private String makeStringToWrite() {
        return MatchingObject.makeStringToWrite(this.text);
    }

    static String makeStringToWrite(StringBuilder text) {
        return text.toString();
    }

    private void log(Level logLevel, String msg) {
        String id;
        String string = id = this.dataObject != null ? this.dataObject.getName() : this.fileObject.toString();
        if (LOG.isLoggable(logLevel)) {
            LOG.log(logLevel, "{0}: {1}", new Object[]{id, msg});
        }
    }

    public String toString() {
        return super.toString() + "[" + this.getName() + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MatchingObject other = (MatchingObject)obj;
        if (this.resultModel == other.resultModel || this.resultModel != null && this.resultModel.equals(other.resultModel)) {
            return this.fileObject == other.fileObject || this.fileObject != null && this.fileObject.equals(other.fileObject);
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 73 * hash + (this.fileObject != null ? this.fileObject.hashCode() : 0);
        hash = 73 * hash + (this.resultModel != null ? this.resultModel.hashCode() : 0);
        return hash;
    }

    private int computeMatchesCount() {
        return this.resultModel.getDetailsCount(this);
    }

    String getFileDisplayName() {
        return FileUtil.getFileDisplayName((FileObject)this.fileObject);
    }

    int getMatchesCount() {
        return this.matchesCount;
    }

    Node getNodeDelegate() {
        return this.nodeDelegate;
    }

    private class FileListener
    extends FileChangeAdapter {
        private FileListener() {
        }

        public void fileDeleted(FileEvent fe) {
            MatchingObject.this.setInvalid(InvalidityStatus.DELETED);
        }

        public void fileChanged(FileEvent fe) {
            if (((MatchingObject)MatchingObject.this).resultModel.basicCriteria.isSearchAndReplace()) {
                MatchingObject.this.setInvalid(InvalidityStatus.CHANGED);
            }
        }
    }

    private class DetailsChildren
    extends Children.Keys<TextDetail> {
        private boolean replacing;

        public DetailsChildren(boolean replacing) {
            this.replacing = replacing;
            this.setKeys(MatchingObject.this.getTextDetails());
        }

        protected Node[] createNodes(TextDetail key) {
            return new Node[]{new TextDetail.DetailNode(key, this.replacing)};
        }
    }

    public static class Def {
        private FileObject fileObject;
        private Charset charset;
        private List<TextDetail> textDetails;

        public Def(FileObject fileObject, Charset charset, List<TextDetail> textDetails) {
            this.fileObject = fileObject;
            this.charset = charset;
            this.textDetails = textDetails;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public void setCharset(Charset charset) {
            this.charset = charset;
        }

        public FileObject getFileObject() {
            return this.fileObject;
        }

        public void setFileObject(FileObject fileObject) {
            this.fileObject = fileObject;
        }

        public List<TextDetail> getTextDetails() {
            return this.textDetails;
        }

        public void setTextDetails(List<TextDetail> textDetails) {
            this.textDetails = textDetails;
        }
    }

    public static enum InvalidityStatus {
        DELETED(true, "Inv_status_Err_deleted"),
        BECAME_DIR(true, "Inv_status_Err_became_dir"),
        CHANGED(false, "Inv_status_Err_changed"),
        TOO_BIG(false, "Inv_status_Err_too_big"),
        CANT_READ(false, "Inv_status_Err_cannot_read");

        private final boolean fatal;
        private final String descrBundleKey;

        private InvalidityStatus(boolean fatal, String descrBundleKey) {
            this.fatal = fatal;
            this.descrBundleKey = descrBundleKey;
        }

        boolean isFatal() {
            return this.fatal;
        }

        String getDescription(String path) {
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)this.descrBundleKey, (Object)path);
        }
    }
}

