/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;
import java.util.zip.Checksum;
import org.neo4j.io.fs.ChecksumMismatchException;
import org.neo4j.io.fs.ChecksumWriter;
import org.neo4j.io.fs.ReadPastEndException;
import org.neo4j.kernel.impl.transaction.log.FlushableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.ReadableLogPositionAwareChannel;

public class InMemoryClosableChannel
implements ReadableLogPositionAwareChannel,
FlushableLogPositionAwareChannel,
ReadableByteChannel {
    private final byte[] bytes;
    private final Reader reader;
    private final Writer writer;
    private final boolean isReader;
    private boolean open = true;
    private static final Flushable NO_OP_FLUSHABLE = () -> {};

    public InMemoryClosableChannel() {
        this(false);
    }

    public InMemoryClosableChannel(boolean isReader) {
        this(1000, isReader);
    }

    public InMemoryClosableChannel(byte[] bytes, boolean append, boolean isReader, ByteOrder byteOrder) {
        this.bytes = bytes;
        this.isReader = isReader;
        ByteBuffer writeBuffer = ByteBuffer.wrap(this.bytes).order(byteOrder);
        ByteBuffer readBuffer = ByteBuffer.wrap(this.bytes).order(byteOrder);
        if (append) {
            writeBuffer.position(bytes.length);
        }
        this.writer = new Writer(writeBuffer);
        this.reader = new Reader(readBuffer);
    }

    public InMemoryClosableChannel(int bufferSize, boolean isReader) {
        this(new byte[bufferSize], false, isReader, ByteOrder.LITTLE_ENDIAN);
    }

    public InMemoryClosableChannel(int bufferSize) {
        this(new byte[bufferSize], false, false, ByteOrder.LITTLE_ENDIAN);
    }

    public void reset() {
        this.writer.clear();
        this.reader.clear();
        Arrays.fill(this.bytes, (byte)0);
    }

    public Reader reader() {
        return this.reader;
    }

    public Writer writer() {
        return this.writer;
    }

    public InMemoryClosableChannel put(byte b) {
        this.writer.put(b);
        return this;
    }

    public InMemoryClosableChannel putShort(short s) {
        this.writer.putShort(s);
        return this;
    }

    public InMemoryClosableChannel putInt(int i) {
        this.writer.putInt(i);
        return this;
    }

    public InMemoryClosableChannel putLong(long l) {
        this.writer.putLong(l);
        return this;
    }

    public InMemoryClosableChannel putFloat(float f) {
        this.writer.putFloat(f);
        return this;
    }

    public InMemoryClosableChannel putDouble(double d) {
        this.writer.putDouble(d);
        return this;
    }

    public InMemoryClosableChannel put(byte[] bytes, int length) {
        return this.put(bytes, 0, length);
    }

    public InMemoryClosableChannel put(byte[] bytes, int offset, int length) {
        this.writer.put(bytes, offset, length);
        return this;
    }

    public InMemoryClosableChannel putAll(ByteBuffer src) {
        this.writer.putAll(src);
        return this;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() {
        this.open = false;
        this.reader.close();
        this.writer.close();
    }

    public Flushable prepareForFlush() {
        return NO_OP_FLUSHABLE;
    }

    public byte get() throws ReadPastEndException {
        return this.reader.get();
    }

    public short getShort() throws ReadPastEndException {
        return this.reader.getShort();
    }

    public int getInt() throws ReadPastEndException {
        return this.reader.getInt();
    }

    public long getLong() throws ReadPastEndException {
        return this.reader.getLong();
    }

    public float getFloat() throws ReadPastEndException {
        return this.reader.getFloat();
    }

    public double getDouble() throws ReadPastEndException {
        return this.reader.getDouble();
    }

    public void get(byte[] bytes, int length) throws ReadPastEndException {
        this.reader.get(bytes, length);
    }

    public int endChecksumAndValidate() throws IOException {
        return this.reader.endChecksumAndValidate();
    }

    public LogPositionMarker getCurrentLogPosition(LogPositionMarker positionMarker) {
        ByteBufferBase buffer = this.isReader ? this.reader : this.writer;
        return buffer.getCurrentLogPosition(positionMarker);
    }

    public LogPosition getCurrentLogPosition() {
        ByteBufferBase buffer = this.isReader ? this.reader : this.writer;
        return buffer.getCurrentLogPosition();
    }

    public void setLogPosition(LogPositionMarker positionMarker) {
        ByteBufferBase buffer = this.isReader ? this.reader : this.writer;
        buffer.setLogPosition(positionMarker);
    }

    public int putChecksum() {
        return this.writer.putChecksum();
    }

    public void beginChecksum() {
        this.reader.beginChecksum();
        this.writer.beginChecksum();
    }

    public int getChecksum() {
        return this.reader.getChecksum();
    }

    public int positionWriter(int position) {
        int previous = (int)this.writer.position();
        this.writer.position(position);
        return previous;
    }

    public int positionReader(int position) {
        int previous = (int)this.reader.position();
        this.reader.position(position);
        return previous;
    }

    public int readerPosition() {
        return (int)this.reader.position();
    }

    public int writerPosition() {
        return (int)this.writer.position();
    }

    public void truncateTo(int offset) {
        this.reader.limit(offset);
    }

    public int capacity() {
        return this.bytes.length;
    }

    public int availableBytesToRead() {
        return this.reader.remaining();
    }

    public int availableBytesToWrite() {
        return this.writer.remaining();
    }

    public long position() throws IOException {
        ByteBufferBase buffer = this.isReader ? this.reader : this.writer;
        return buffer.position();
    }

    public void position(long byteOffset) {
        ByteBufferBase buffer = this.isReader ? this.reader : this.writer;
        buffer.position((int)byteOffset);
    }

    public int write(ByteBuffer buffer) throws IOException {
        int remaining = buffer.remaining();
        this.writer.write(buffer);
        return remaining;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int readerRemaining = this.reader.buffer.remaining();
        if (readerRemaining >= dst.remaining()) {
            ByteBuffer limitedSlice = this.reader.buffer.slice().limit(dst.remaining());
            int remaining = limitedSlice.remaining();
            dst.put(limitedSlice);
            this.reader.buffer.position(this.reader.buffer.position() + remaining);
            return remaining;
        }
        dst.put(this.reader.buffer);
        return readerRemaining;
    }

    public static class Writer
    extends ByteBufferBase
    implements FlushableLogPositionAwareChannel {
        private final Checksum checksum = (Checksum)CHECKSUM_FACTORY.get();

        Writer(ByteBuffer buffer) {
            super(buffer);
        }

        public Writer put(byte b) {
            this.buffer.put(b);
            this.updateCrc(1);
            return this;
        }

        public Writer putShort(short s) {
            this.buffer.putShort(s);
            this.updateCrc(2);
            return this;
        }

        public Writer putInt(int i) {
            this.buffer.putInt(i);
            this.updateCrc(4);
            return this;
        }

        public Writer putLong(long l) {
            this.buffer.putLong(l);
            this.updateCrc(8);
            return this;
        }

        public Writer putFloat(float f) {
            this.buffer.putFloat(f);
            this.updateCrc(4);
            return this;
        }

        public Writer putDouble(double d) {
            this.buffer.putDouble(d);
            this.updateCrc(8);
            return this;
        }

        public Writer put(byte[] bytes, int offset, int length) {
            this.buffer.put(bytes, offset, length);
            this.checksum.update(bytes, offset, length);
            return this;
        }

        public Writer putAll(ByteBuffer src) {
            src.mark();
            this.buffer.put(src);
            src.reset();
            this.checksum.update(src);
            return this;
        }

        public Flushable prepareForFlush() {
            return NO_OP_FLUSHABLE;
        }

        public int putChecksum() {
            int checksum = (int)this.checksum.getValue();
            this.buffer.putInt(checksum);
            return checksum;
        }

        public void beginChecksum() {
            this.checksum.reset();
        }

        private void updateCrc(int size) {
            this.checksum.update(this.buffer.array(), this.buffer.position() - size, size);
        }

        public int write(ByteBuffer byteBuffer) throws IOException {
            int remaining = byteBuffer.remaining();
            byteBuffer.mark();
            this.buffer.put(byteBuffer);
            byteBuffer.reset();
            this.checksum.update(byteBuffer);
            return remaining;
        }

        public boolean isOpen() {
            return !this.isClosed;
        }
    }

    public class Reader
    extends ByteBufferBase
    implements ReadableLogPositionAwareChannel {
        private final Checksum checksum;

        Reader(ByteBuffer buffer) {
            super(buffer);
            this.checksum = (Checksum)ChecksumWriter.CHECKSUM_FACTORY.get();
        }

        public byte get() throws ReadPastEndException {
            this.ensureAvailableToRead(1);
            this.updateCrc(1);
            return this.buffer.get();
        }

        public short getShort() throws ReadPastEndException {
            this.ensureAvailableToRead(2);
            this.updateCrc(2);
            return this.buffer.getShort();
        }

        public int getInt() throws ReadPastEndException {
            this.ensureAvailableToRead(4);
            this.updateCrc(4);
            return this.buffer.getInt();
        }

        public long getLong() throws ReadPastEndException {
            this.ensureAvailableToRead(8);
            this.updateCrc(8);
            return this.buffer.getLong();
        }

        public float getFloat() throws ReadPastEndException {
            this.ensureAvailableToRead(4);
            this.updateCrc(4);
            return this.buffer.getFloat();
        }

        public double getDouble() throws ReadPastEndException {
            this.ensureAvailableToRead(8);
            this.updateCrc(8);
            return this.buffer.getDouble();
        }

        public void get(byte[] bytes, int length) throws ReadPastEndException {
            this.ensureAvailableToRead(length);
            this.buffer.get(bytes, 0, length);
            this.checksum.update(bytes, 0, length);
        }

        public int endChecksumAndValidate() throws ReadPastEndException {
            this.ensureAvailableToRead(4);
            int checksum = (int)this.checksum.getValue();
            int storedChecksum = this.buffer.getInt();
            if (checksum != storedChecksum) {
                throw new ChecksumMismatchException((long)storedChecksum, (long)checksum);
            }
            this.beginChecksum();
            return checksum;
        }

        public void beginChecksum() {
            this.checksum.reset();
        }

        public int getChecksum() {
            return (int)this.checksum.getValue();
        }

        @Override
        public long position() {
            return this.buffer.position();
        }

        @Override
        public void position(long byteOffset) {
            this.buffer.position(Math.toIntExact(byteOffset));
            this.beginChecksum();
        }

        private void ensureAvailableToRead(int i) throws ReadPastEndException {
            if (this.remaining() < i || this.position() + (long)i > InMemoryClosableChannel.this.writer.position()) {
                throw ReadPastEndException.INSTANCE;
            }
        }

        private void updateCrc(int size) {
            this.checksum.update(this.buffer.array(), this.buffer.position(), size);
        }

        public int read(ByteBuffer dst) throws IOException {
            int remaining = dst.remaining();
            this.ensureAvailableToRead(remaining);
            dst.mark();
            dst.put(this.buffer);
            dst.reset();
            this.checksum.update(dst);
            return remaining;
        }

        public boolean isOpen() {
            return !this.isClosed;
        }
    }

    static class ByteBufferBase
    implements LogPositionAwareChannel,
    Closeable {
        protected final ByteBuffer buffer;
        protected boolean isClosed;

        ByteBufferBase(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        void clear() {
            this.buffer.clear();
        }

        long position() {
            return this.buffer.position();
        }

        void position(long position) {
            this.buffer.position((int)position);
        }

        int remaining() {
            return this.buffer.remaining();
        }

        void limit(int offset) {
            this.buffer.limit(offset);
        }

        @Override
        public void close() {
            this.isClosed = true;
        }

        public LogPositionMarker getCurrentLogPosition(LogPositionMarker positionMarker) {
            positionMarker.mark(0L, (long)this.buffer.position());
            return positionMarker;
        }

        public LogPosition getCurrentLogPosition() {
            return new LogPosition(0L, (long)this.buffer.position());
        }

        public void setLogPosition(LogPositionMarker positionMarker) {
            this.position(positionMarker.getByteOffset());
        }
    }
}

