/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.neo4j.scheduler.ActiveGroup;
import org.neo4j.scheduler.CallableExecutor;
import org.neo4j.scheduler.FailedJobRun;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.scheduler.MonitoredJobExecutor;
import org.neo4j.scheduler.MonitoredJobInfo;
import org.neo4j.scheduler.SchedulerThreadFactoryFactory;
import org.neo4j.time.FakeClock;

public class FakeClockJobScheduler
extends FakeClock
implements JobScheduler {
    private final AtomicLong jobIdGen = new AtomicLong();
    private final Collection<JobTrigger> jobs = new CopyOnWriteArrayList<JobTrigger>();

    private <V> JobTrigger<V> schedule(Callable<V> job, long firstDeadline) {
        JobTrigger<V> jobTrigger = new JobTrigger<V>(job, firstDeadline, 0L);
        this.jobs.add(jobTrigger);
        return jobTrigger;
    }

    private JobTrigger schedule(Runnable job, long firstDeadline) {
        JobTrigger jobTrigger = new JobTrigger(job, firstDeadline, 0L);
        this.jobs.add(jobTrigger);
        return jobTrigger;
    }

    private JobTrigger scheduleRecurring(Runnable job, long firstDeadline, long period) {
        JobTrigger jobTrigger = new JobTrigger(job, firstDeadline, period);
        this.jobs.add(jobTrigger);
        return jobTrigger;
    }

    public FakeClock forward(long delta, TimeUnit unit) {
        super.forward(delta, unit);
        this.processSchedule();
        return this;
    }

    private void processSchedule() {
        boolean anyTriggered;
        do {
            anyTriggered = false;
            for (JobTrigger job : this.jobs) {
                if (!job.tryTrigger()) continue;
                anyTriggered = true;
            }
        } while (anyTriggered);
    }

    private long now() {
        return this.instant().toEpochMilli();
    }

    public void setTopLevelGroupName(String name) {
    }

    public void setParallelism(Group group, int parallelism) {
    }

    public void setThreadFactory(Group group, SchedulerThreadFactoryFactory threadFactory) {
    }

    public CallableExecutor executor(Group group) {
        return new FakeClockExecutor();
    }

    public MonitoredJobExecutor monitoredJobExecutor(Group group) {
        FakeClockExecutor executor = new FakeClockExecutor();
        return (monitoringParams, command) -> executor.execute(command);
    }

    public ThreadFactory threadFactory(Group group) {
        throw new UnsupportedOperationException();
    }

    public <T> JobHandle<T> schedule(Group group, JobMonitoringParams jobMonitoringParams, Callable<T> job) {
        JobTrigger<T> handle = this.schedule(job, this.now());
        this.processSchedule();
        return handle;
    }

    public JobHandle<?> schedule(Group group, Runnable job) {
        JobTrigger handle = this.schedule(job, this.now());
        this.processSchedule();
        return handle;
    }

    public JobHandle<?> schedule(Group group, JobMonitoringParams monitoredJobParams, Runnable job) {
        return this.schedule(group, job);
    }

    public JobHandle<?> schedule(Group group, Runnable job, long initialDelay, TimeUnit timeUnit) {
        JobTrigger handle = this.schedule(job, this.now() + timeUnit.toMillis(initialDelay));
        if (initialDelay <= 0L) {
            this.processSchedule();
        }
        return handle;
    }

    public JobHandle<?> schedule(Group group, JobMonitoringParams monitoredJobParams, Runnable job, long initialDelay, TimeUnit timeUnit) {
        return this.schedule(group, job, initialDelay, timeUnit);
    }

    public JobHandle<?> scheduleRecurring(Group group, Runnable job, long period, TimeUnit timeUnit) {
        JobTrigger handle = this.scheduleRecurring(job, this.now(), timeUnit.toMillis(period));
        this.processSchedule();
        return handle;
    }

    public JobHandle<?> scheduleRecurring(Group group, JobMonitoringParams monitoredJobParams, Runnable job, long period, TimeUnit timeUnit) {
        return this.scheduleRecurring(group, job, period, timeUnit);
    }

    public JobHandle<?> scheduleRecurring(Group group, Runnable job, long initialDelay, long period, TimeUnit timeUnit) {
        JobTrigger handle = this.scheduleRecurring(job, this.now() + timeUnit.toMillis(initialDelay), timeUnit.toMillis(period));
        if (initialDelay <= 0L) {
            this.processSchedule();
        }
        return handle;
    }

    public JobHandle<?> scheduleRecurring(Group group, JobMonitoringParams monitoredJobParams, Runnable job, long initialDelay, long period, TimeUnit timeUnit) {
        return this.scheduleRecurring(group, job, initialDelay, period, timeUnit);
    }

    public Stream<ActiveGroup> activeGroups() {
        return Stream.empty();
    }

    public List<MonitoredJobInfo> getMonitoredJobs() {
        return List.of();
    }

    public List<FailedJobRun> getFailedJobRuns() {
        return List.of();
    }

    public void init() {
        throw new UnsupportedOperationException();
    }

    public void start() {
        throw new UnsupportedOperationException();
    }

    public void stop() {
        throw new UnsupportedOperationException();
    }

    public void shutdown() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        this.shutdown();
    }

    class JobTrigger<T>
    implements JobHandle<T>,
    Future<T> {
        private final long id;
        private final Runnable runnable;
        private final Callable<T> callable;
        private final long period;
        private long deadline;

        JobTrigger(Callable<T> callable, long firstDeadline, long period) {
            this.id = FakeClockJobScheduler.this.jobIdGen.incrementAndGet();
            this.runnable = null;
            this.callable = callable;
            this.deadline = firstDeadline;
            this.period = period;
        }

        JobTrigger(Runnable runnable, long firstDeadline, long period) {
            this.id = FakeClockJobScheduler.this.jobIdGen.incrementAndGet();
            this.runnable = runnable;
            this.callable = null;
            this.deadline = firstDeadline;
            this.period = period;
        }

        boolean tryTrigger() {
            if (FakeClockJobScheduler.this.now() >= this.deadline) {
                if (this.runnable != null) {
                    this.runnable.run();
                }
                if (this.callable != null) {
                    try {
                        this.callable.call();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                if (this.period != 0L) {
                    this.deadline += this.period;
                } else {
                    FakeClockJobScheduler.this.jobs.remove(this);
                }
                return true;
            }
            return false;
        }

        public void cancel() {
            this.cancel(false);
        }

        public void waitTermination() {
            throw new UnsupportedOperationException();
        }

        public void waitTermination(long timeout, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return FakeClockJobScheduler.this.jobs.remove(this);
        }

        @Override
        public boolean isCancelled() {
            return !FakeClockJobScheduler.this.jobs.contains(this);
        }

        @Override
        public boolean isDone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public T get() {
            throw new UnsupportedOperationException();
        }

        @Override
        public T get(long timeout, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JobTrigger jobTrigger = (JobTrigger)o;
            return this.id == jobTrigger.id;
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }
    }

    private class FakeClockExecutor
    implements CallableExecutor {
        private FakeClockExecutor() {
        }

        public <T> Future<T> submit(Callable<T> callable) {
            return FakeClockJobScheduler.this.schedule(callable, FakeClockJobScheduler.this.now());
        }

        public void execute(Runnable command) {
            FakeClockJobScheduler.this.schedule(command, FakeClockJobScheduler.this.now());
        }
    }
}

