/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension.timeout;

import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.awaitility.core.ConditionTimeoutException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.LifecycleMethodExecutionExceptionHandler;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.neo4j.internal.utils.DumpUtils;

public class VerboseTimeoutExceptionExtension
implements TestExecutionExceptionHandler,
LifecycleMethodExecutionExceptionHandler {
    private static final ExtensionContext.Namespace THREAD_DUMPER_NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{"threadDumper"});
    private static final String DISABLED = "disabled";

    public static void disable(ExtensionContext context) {
        context.getRoot().getStore(THREAD_DUMPER_NAMESPACE).put((Object)DISABLED, (Object)DISABLED);
    }

    public void handleTestExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        VerboseTimeoutExceptionExtension.handleFailure(context, context.getRequiredTestMethod().getName(), throwable);
        throw throwable;
    }

    public void handleBeforeAllMethodExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        VerboseTimeoutExceptionExtension.handleFailure(context, "BeforeAll", throwable);
        throw throwable;
    }

    public void handleBeforeEachMethodExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        VerboseTimeoutExceptionExtension.handleFailure(context, "BeforeEach", throwable);
        throw throwable;
    }

    public void handleAfterEachMethodExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        VerboseTimeoutExceptionExtension.handleFailure(context, "AfterEach", throwable);
        throw throwable;
    }

    public void handleAfterAllMethodExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        VerboseTimeoutExceptionExtension.handleFailure(context, "AfterAll", throwable);
        throw throwable;
    }

    private static boolean isTimeout(Throwable throwable) {
        return throwable != null && (throwable instanceof TimeoutException || throwable instanceof ConditionTimeoutException || StringUtils.contains((CharSequence)throwable.getMessage(), (CharSequence)"timed out") || !Objects.equals(throwable, throwable.getCause()) && VerboseTimeoutExceptionExtension.isTimeout(throwable.getCause()) || Arrays.stream(throwable.getSuppressed()).anyMatch(VerboseTimeoutExceptionExtension::isTimeout));
    }

    private static void handleFailure(ExtensionContext context, String testMethod, Throwable cause) {
        if (VerboseTimeoutExceptionExtension.isEnabled(context) && VerboseTimeoutExceptionExtension.isTimeout(cause)) {
            String displayName = context.getDisplayName();
            cause.addSuppressed(new ThreadDump(String.format("Test %s-%s timed out. ", displayName, testMethod)));
        }
    }

    private static boolean isEnabled(ExtensionContext context) {
        return context.getRoot().getStore(THREAD_DUMPER_NAMESPACE).get((Object)DISABLED) == null;
    }

    static class ThreadDump
    extends RuntimeException {
        ThreadDump(String header) {
            super(header + DumpUtils.threadDump());
            this.setStackTrace(new StackTraceElement[0]);
        }
    }
}

