/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.ssl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileSystemUtils;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.ssl.InsecureRandom;

public class SelfSignedCertificateFactory {
    private static final boolean useInsecureCertificateGeneration = Boolean.getBoolean("org.neo4j.useInsecureCertificateGeneration");
    private static final String DEFAULT_ENCRYPTION = "RSA";
    private final SecureRandom random = useInsecureCertificateGeneration ? new InsecureRandom() : new SecureRandom();
    private static final Date NOT_BEFORE = new Date(System.currentTimeMillis() - 31536000000L);
    private static final Date NOT_AFTER = new Date(253402300799000L);
    private static final String DEFAULT_KEY_FILE_NAME = "private.key";
    private static final String DEFAULT_CERT_FILE_NAME = "public.crt";
    private static final String DEFAULT_HOST_NAME = "localhost";
    private static volatile boolean cleanupRequired = true;

    public static void create(FileSystemAbstraction fs, Path certDir) {
        SelfSignedCertificateFactory.create(fs, certDir, DEFAULT_KEY_FILE_NAME, DEFAULT_CERT_FILE_NAME);
    }

    public static void create(FileSystemAbstraction fs, Path certDir, String hostname) {
        SelfSignedCertificateFactory.create(fs, certDir, DEFAULT_KEY_FILE_NAME, DEFAULT_CERT_FILE_NAME, hostname);
    }

    public static void create(FileSystemAbstraction fs, Path certDir, String keyFileName, String certFileName, String hostname) {
        SelfSignedCertificateFactory certificateFactory = new SelfSignedCertificateFactory();
        Path privateKeyFile = certDir.resolve(keyFileName);
        Path certificateFile = certDir.resolve(certFileName);
        if (!Files.exists(privateKeyFile, new LinkOption[0]) && !Files.exists(certificateFile, new LinkOption[0])) {
            try {
                certificateFactory.createSelfSignedCertificate(fs, certificateFile, privateKeyFile, hostname);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to generate private key and certificate", e);
            }
        }
    }

    public static void create(FileSystemAbstraction fs, Path certDir, String keyFileName, String certFileName) {
        SelfSignedCertificateFactory.create(fs, certDir, keyFileName, certFileName, DEFAULT_HOST_NAME);
    }

    public void createSelfSignedCertificate(FileSystemAbstraction fs, Path certificatePath, Path privateKeyPath, String hostName) throws GeneralSecurityException, IOException, OperatorCreationException {
        SelfSignedCertificateFactory.installCleanupHook(certificatePath, privateKeyPath);
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance(DEFAULT_ENCRYPTION);
        keyGen.initialize(2048, this.random);
        KeyPair keypair = keyGen.generateKeyPair();
        X500Name owner = new X500Name("CN=" + hostName);
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(owner, new BigInteger(64, this.random), NOT_BEFORE, NOT_AFTER, owner, keypair.getPublic());
        GeneralNames subjectAlternativeName = new GeneralNames(new GeneralName(2, hostName));
        builder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)subjectAlternativeName);
        PrivateKey privateKey = keypair.getPrivate();
        ContentSigner signer = new JcaContentSignerBuilder("SHA512WithRSAEncryption").build(privateKey);
        X509CertificateHolder certHolder = builder.build(signer);
        X509Certificate cert = new JcaX509CertificateConverter().setProvider((Provider)new BouncyCastleProvider()).getCertificate(certHolder);
        cert.verify(keypair.getPublic());
        SelfSignedCertificateFactory.writePem(fs, "CERTIFICATE", cert.getEncoded(), certificatePath);
        SelfSignedCertificateFactory.writePem(fs, "PRIVATE KEY", privateKey.getEncoded(), privateKeyPath);
        cleanupRequired = false;
    }

    private static void installCleanupHook(Path certificatePath, Path privateKeyPath) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (cleanupRequired) {
                System.err.println("Cleaning up partially generated self-signed certificate...");
                try {
                    if (Files.exists(certificatePath, new LinkOption[0])) {
                        Files.delete(certificatePath);
                    }
                    if (Files.exists(privateKeyPath, new LinkOption[0])) {
                        Files.delete(privateKeyPath);
                    }
                }
                catch (IOException e) {
                    System.err.println("Error cleaning up");
                    e.printStackTrace(System.err);
                }
            }
        }));
    }

    private static void writePem(FileSystemAbstraction fs, String type, byte[] encodedContent, Path path) throws IOException {
        fs.mkdirs(path.getParent());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (PemWriter writer = new PemWriter((Writer)new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8));){
            writer.writeObject((PemObjectGenerator)new PemObject(type, encodedContent));
        }
        FileSystemUtils.writeAllBytes((FileSystemAbstraction)fs, (Path)path, (byte[])out.toByteArray(), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        if (fs instanceof DefaultFileSystemAbstraction) {
            try {
                Files.setPosixFilePermissions(path, Set.of(PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_READ));
            }
            catch (UnsupportedOperationException ignore) {
                path.toFile().setReadable(false, false);
                path.toFile().setWritable(false, false);
                path.toFile().setReadable(true);
                path.toFile().setWritable(true);
            }
        }
    }
}

