/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.jar;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;

public class JarBuilder {
    public URL createJarFor(Path f, Class<?> ... classesToInclude) throws IOException {
        try (JarOutputStream jarOut = new JarOutputStream(Files.newOutputStream(f, new OpenOption[0]));){
            for (Class<?> target : classesToInclude) {
                String fileName = target.getName().replace('.', '/') + ".class";
                jarOut.putNextEntry(new ZipEntry(fileName));
                jarOut.write(this.classCompiledBytes(fileName));
                jarOut.closeEntry();
            }
        }
        return f.toUri().toURL();
    }

    private byte[] classCompiledBytes(String fileName) throws IOException {
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream(fileName);){
            Objects.requireNonNull(in);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while (in.available() > 0) {
                out.write(in.read());
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }
}

