/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.proc;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public final class ProcessUtil {
    private ProcessUtil() {
    }

    public static Path getJavaExecutable() {
        String javaHome = System.getProperty("java.home");
        return Paths.get(javaHome, "bin", "java");
    }

    public static List<String> getClassPathList() {
        return Arrays.asList(ProcessUtil.getClassPath().split(File.pathSeparator));
    }

    public static String getClassPath() {
        return System.getProperty("java.class.path");
    }

    public static List<String> getModuleOptions() {
        String moduleOptions = System.getProperty("jdk.custom.options");
        if (StringUtils.isEmpty((CharSequence)moduleOptions)) {
            return Collections.emptyList();
        }
        return Arrays.stream(moduleOptions.split(" ")).filter(StringUtils::isNotBlank).map(String::trim).collect(Collectors.toList());
    }

    public static Process start(String ... arguments) throws IOException {
        return ProcessUtil.start(ProcessBuilder::inheritIO, arguments);
    }

    public static Process start(Consumer<ProcessBuilder> configurator, String ... arguments) throws IOException {
        ArrayList<String> args = new ArrayList<String>();
        args.add(ProcessUtil.getJavaExecutable().toString());
        List<String> moduleOptions = ProcessUtil.getModuleOptions();
        if (!moduleOptions.isEmpty()) {
            args.addAll(moduleOptions);
        }
        args.add("-cp");
        args.add(ProcessUtil.getClassPath());
        args.addAll(Arrays.asList(arguments));
        ProcessBuilder processBuilder = new ProcessBuilder(args);
        configurator.accept(processBuilder);
        return processBuilder.start();
    }
}

