/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.ssl;

import java.io.IOException;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;
import org.neo4j.test.ssl.InsecureRandom;

public class SelfSignedCertificateFactory {
    private static final boolean useInsecureCertificateGeneration = Boolean.getBoolean("org.neo4j.useInsecureCertificateGeneration");
    private static final String DEFAULT_ENCRYPTION = "RSA";
    private final SecureRandom random = useInsecureCertificateGeneration ? new InsecureRandom() : new SecureRandom();
    private static final Date NOT_BEFORE = new Date(System.currentTimeMillis() - 31536000000L);
    private static final Date NOT_AFTER = new Date(253402300799000L);
    private static final Provider PROVIDER = new BouncyCastleProvider();
    private static final String DEFAULT_KEY_FILE_NAME = "private.key";
    private static final String DEFAULT_CERT_FILE_NAME = "public.crt";
    private static final String DEFAULT_HOST_NAME = "localhost";
    private static volatile boolean cleanupRequired = true;

    public static void create(Path certDir) {
        SelfSignedCertificateFactory.create(certDir, DEFAULT_KEY_FILE_NAME, DEFAULT_CERT_FILE_NAME);
    }

    public static void create(Path certDir, String keyFileName, String certFileName) {
        SelfSignedCertificateFactory certificateFactory = new SelfSignedCertificateFactory();
        Path privateKeyFile = certDir.resolve(keyFileName);
        Path certificateFile = certDir.resolve(certFileName);
        if (!Files.exists(privateKeyFile, new LinkOption[0]) && !Files.exists(certificateFile, new LinkOption[0])) {
            try {
                certificateFactory.createSelfSignedCertificate(certificateFile, privateKeyFile, DEFAULT_HOST_NAME);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to generate private key and certificate", e);
            }
        }
    }

    public void createSelfSignedCertificate(Path certificatePath, Path privateKeyPath, String hostName) throws GeneralSecurityException, IOException, OperatorCreationException {
        SelfSignedCertificateFactory.installCleanupHook(certificatePath, privateKeyPath);
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance(DEFAULT_ENCRYPTION);
        keyGen.initialize(2048, this.random);
        KeyPair keypair = keyGen.generateKeyPair();
        X500Name owner = new X500Name("CN=" + hostName);
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(owner, new BigInteger(64, this.random), NOT_BEFORE, NOT_AFTER, owner, keypair.getPublic());
        GeneralNames subjectAlternativeName = new GeneralNames(new GeneralName(2, hostName));
        builder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)subjectAlternativeName);
        PrivateKey privateKey = keypair.getPrivate();
        ContentSigner signer = new JcaContentSignerBuilder("SHA512WithRSAEncryption").build(privateKey);
        X509CertificateHolder certHolder = builder.build(signer);
        X509Certificate cert = new JcaX509CertificateConverter().setProvider(PROVIDER).getCertificate(certHolder);
        cert.verify(keypair.getPublic());
        this.writePem("CERTIFICATE", cert.getEncoded(), certificatePath);
        this.writePem("PRIVATE KEY", privateKey.getEncoded(), privateKeyPath);
        cleanupRequired = false;
    }

    private static void installCleanupHook(Path certificatePath, Path privateKeyPath) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (cleanupRequired) {
                System.err.println("Cleaning up partially generated self-signed certificate...");
                try {
                    if (Files.exists(certificatePath, new LinkOption[0])) {
                        Files.delete(certificatePath);
                    }
                    if (Files.exists(privateKeyPath, new LinkOption[0])) {
                        Files.delete(privateKeyPath);
                    }
                }
                catch (IOException e) {
                    System.err.println("Error cleaning up");
                    e.printStackTrace(System.err);
                }
            }
        }));
    }

    private void writePem(String type, byte[] encodedContent, Path path) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (PemWriter writer = new PemWriter((Writer)Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]));){
            writer.writeObject((PemObjectGenerator)new PemObject(type, encodedContent));
            writer.flush();
        }
        try {
            Files.setPosixFilePermissions(path, Set.of(PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_READ));
        }
        catch (UnsupportedOperationException ignore) {
            path.toFile().setReadable(false, false);
            path.toFile().setWritable(false, false);
            path.toFile().setReadable(true);
            path.toFile().setWritable(true);
        }
    }

    static {
        Security.addProvider(PROVIDER);
    }
}

