/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.neo4j.scheduler.CallableExecutor;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.test.scheduler.JobSchedulerAdapter;

public class OnDemandJobScheduler
extends JobSchedulerAdapter {
    private final List<OnDemandJobHandle<?>> jobs = new CopyOnWriteArrayList();
    private final boolean removeJobsAfterExecution;

    public OnDemandJobScheduler() {
        this(true);
    }

    public OnDemandJobScheduler(boolean removeJobsAfterExecution) {
        this.removeJobsAfterExecution = removeJobsAfterExecution;
    }

    @Override
    public CallableExecutor executor(Group group) {
        return new OnDemandExecutor();
    }

    @Override
    public JobHandle<?> schedule(Group group, Runnable job) {
        return this.schedule(job);
    }

    @Override
    public JobHandle<?> schedule(Group group, JobMonitoringParams jobMonitoringParams, Runnable job) {
        return this.schedule(job);
    }

    @Override
    public JobHandle<?> schedule(Group group, Runnable job, long initialDelay, TimeUnit timeUnit) {
        return this.schedule(job);
    }

    @Override
    public JobHandle<?> schedule(Group group, JobMonitoringParams jobMonitoringParams, Runnable job, long initialDelay, TimeUnit timeUnit) {
        return this.schedule(job);
    }

    @Override
    public JobHandle<?> scheduleRecurring(Group group, Runnable runnable, long period, TimeUnit timeUnit) {
        return this.schedule(runnable);
    }

    @Override
    public JobHandle<?> scheduleRecurring(Group group, JobMonitoringParams jobMonitoringParams, Runnable runnable, long period, TimeUnit timeUnit) {
        return this.schedule(runnable);
    }

    @Override
    public JobHandle<?> scheduleRecurring(Group group, Runnable runnable, long initialDelay, long period, TimeUnit timeUnit) {
        return this.schedule(runnable);
    }

    @Override
    public JobHandle<?> scheduleRecurring(Group group, JobMonitoringParams jobMonitoringParams, Runnable runnable, long initialDelay, long period, TimeUnit timeUnit) {
        return this.schedule(runnable);
    }

    public Object getJob() {
        if (this.jobs.isEmpty()) {
            return null;
        }
        OnDemandJobHandle<?> job = this.jobs.get(0);
        return job.callable != null ? job.callable : job.runnable;
    }

    public void runJob() {
        for (OnDemandJobHandle<?> job : this.jobs) {
            job.run();
            if (!this.removeJobsAfterExecution) continue;
            this.jobs.remove(job);
        }
    }

    private OnDemandJobHandle<?> schedule(Runnable runnable) {
        OnDemandJobHandle jobHandle = new OnDemandJobHandle(runnable);
        this.jobs.add(jobHandle);
        return jobHandle;
    }

    private <T> OnDemandJobHandle<T> schedule(Callable<T> callable) {
        OnDemandJobHandle<T> jobHandle = new OnDemandJobHandle<T>(callable);
        this.jobs.add(jobHandle);
        return jobHandle;
    }

    public class OnDemandJobHandle<T>
    implements JobHandle<T>,
    Future<T> {
        private Runnable runnable;
        private Callable<T> callable;

        OnDemandJobHandle(Runnable runnable) {
            this.runnable = runnable;
            this.callable = null;
        }

        OnDemandJobHandle(Callable<T> callable) {
            this.runnable = null;
            this.callable = callable;
        }

        public void cancel() {
            OnDemandJobScheduler.this.jobs.remove(this);
        }

        public void waitTermination() {
        }

        public void waitTermination(long timeout, TimeUnit unit) {
        }

        @Override
        public T get() throws ExecutionException, InterruptedException {
            return null;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return OnDemandJobScheduler.this.jobs.remove(this);
        }

        @Override
        public boolean isCancelled() {
            return !OnDemandJobScheduler.this.jobs.contains(this);
        }

        @Override
        public boolean isDone() {
            return !OnDemandJobScheduler.this.jobs.contains(this);
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return null;
        }

        void run() {
            if (this.runnable != null) {
                this.runnable.run();
            }
            if (this.callable != null) {
                try {
                    this.callable.call();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private class OnDemandExecutor
    implements CallableExecutor {
        private OnDemandExecutor() {
        }

        public <T> Future<T> submit(Callable<T> callable) {
            return OnDemandJobScheduler.this.schedule(callable);
        }

        public void execute(Runnable runnable) {
            OnDemandJobScheduler.this.schedule(runnable);
        }
    }
}

