/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.rule;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.rules.TestRule;
import org.junit.runners.model.Statement;
import org.neo4j.test.OtherThreadExecutor;

public class OtherThreadRule<STATE>
implements TestRule {
    private String name;
    private long timeout;
    private TimeUnit unit;
    private volatile OtherThreadExecutor<STATE> executor;

    public OtherThreadRule() {
        this(null);
    }

    public OtherThreadRule(String name) {
        this.set(name, 60L, TimeUnit.SECONDS);
    }

    public OtherThreadRule(long timeout, TimeUnit unit) {
        this.set(null, timeout, unit);
    }

    public void set(long timeout, TimeUnit unit) {
        this.timeout = timeout;
        this.unit = unit;
    }

    public void set(String name, long timeout, TimeUnit unit) {
        this.name = name;
        this.timeout = timeout;
        this.unit = unit;
    }

    public <RESULT> Future<RESULT> execute(OtherThreadExecutor.WorkerCommand<STATE, RESULT> cmd) {
        Future<RESULT> future = this.executor.executeDontWait(cmd);
        try {
            this.executor.awaitStartExecuting();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while awaiting start of execution.", e);
        }
        return future;
    }

    protected STATE initialState() {
        return null;
    }

    public static Matcher<OtherThreadRule> isWaiting() {
        return OtherThreadRule.isThreadState(Thread.State.WAITING, Thread.State.TIMED_WAITING);
    }

    private static Matcher<OtherThreadRule> isThreadState(final Thread.State ... eitherOfStates) {
        return new TypeSafeMatcher<OtherThreadRule>(){

            protected boolean matchesSafely(OtherThreadRule rule) {
                try {
                    rule.executor.waitUntilThreadState(eitherOfStates);
                    return true;
                }
                catch (TimeoutException e) {
                    rule.executor.printStackTrace(System.err);
                    return false;
                }
            }

            public void describeTo(Description description) {
                description.appendText("Thread blocked in state WAITING");
            }
        };
    }

    public OtherThreadExecutor<STATE> get() {
        return this.executor;
    }

    public void interrupt() {
        this.executor.interrupt();
    }

    public String toString() {
        OtherThreadExecutor<STATE> otherThread = this.executor;
        if (otherThread == null) {
            return "OtherThreadRule[state=dead]";
        }
        return otherThread.toString();
    }

    public void beforeEach(ExtensionContext context) {
        String displayName = context.getDisplayName();
        String threadName = this.name != null ? this.name + "-" + displayName : displayName;
        this.init(threadName);
    }

    public void afterEach(ExtensionContext context) {
        try {
            this.executor.close();
        }
        finally {
            this.executor = null;
        }
    }

    public Statement apply(final Statement base, final org.junit.runner.Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                String threadName = OtherThreadRule.this.name != null ? OtherThreadRule.this.name + "-" + description.getDisplayName() : description.getDisplayName();
                OtherThreadRule.this.init(threadName);
                try {
                    base.evaluate();
                }
                finally {
                    try {
                        OtherThreadRule.this.executor.close();
                    }
                    finally {
                        OtherThreadRule.this.executor = null;
                    }
                }
            }
        };
    }

    public void init(String threadName) {
        this.executor = new OtherThreadExecutor<STATE>(threadName, this.timeout, this.unit, this.initialState());
    }

    public void close() {
        this.executor.close();
    }
}

