/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.matchers;

import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class ByteArrayMatcher
extends TypeSafeDiagnosingMatcher<byte[]> {
    private static final char[] hexadecimals = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private final byte[] expected;

    public static ByteArrayMatcher byteArray(byte ... expected) {
        return new ByteArrayMatcher(expected);
    }

    public static ByteArrayMatcher byteArray(int ... expected) {
        byte[] bytes = new byte[expected.length];
        for (int i = 0; i < expected.length; ++i) {
            bytes[i] = (byte)expected[i];
        }
        return ByteArrayMatcher.byteArray(bytes);
    }

    public ByteArrayMatcher(byte[] expected) {
        this.expected = expected;
    }

    protected boolean matchesSafely(byte[] actual, Description description) {
        if (actual.length != this.expected.length) {
            this.describe(actual, description);
            return false;
        }
        for (int i = 0; i < this.expected.length; ++i) {
            if (actual[i] == this.expected[i]) continue;
            this.describe(actual, description);
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        this.describe(this.expected, description);
    }

    private void describe(byte[] bytes, Description description) {
        String prefix = "byte[] { ";
        String suffix = "}";
        StringBuilder sb = new StringBuilder(bytes.length * 3 + prefix.length() + suffix.length());
        sb.append(prefix);
        for (int i = 0; i < bytes.length; ++i) {
            int b = bytes[i] & 0xFF;
            char hi = hexadecimals[b >> 4];
            char lo = hexadecimals[b & 0xF];
            sb.append(hi).append(lo).append(' ');
        }
        sb.append(suffix);
        description.appendText(sb.toString());
    }
}

