/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.scheduler;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.scheduler.ActiveGroup;
import org.neo4j.scheduler.CallableExecutor;
import org.neo4j.scheduler.CallableExecutorService;
import org.neo4j.scheduler.FailedJobRun;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.scheduler.MonitoredJobExecutor;
import org.neo4j.scheduler.MonitoredJobInfo;
import org.neo4j.scheduler.SchedulerThreadFactoryFactory;
import org.neo4j.test.scheduler.DaemonThreadFactory;

public class ThreadPoolJobScheduler
extends LifecycleAdapter
implements JobScheduler {
    private final ExecutorService oneOffExecutor;
    private final ScheduledExecutorService scheduledExecutor;
    private final ThreadFactory threadFactory;

    public ThreadPoolJobScheduler() {
        this("ThreadPoolScheduler");
    }

    public ThreadPoolJobScheduler(String prefix) {
        this(Executors.newCachedThreadPool(new DaemonThreadFactory(prefix + "-oneoff")), Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors(), new DaemonThreadFactory(prefix + "-scheduled")));
    }

    public ThreadPoolJobScheduler(ExecutorService oneOffExecutor, ScheduledExecutorService scheduledExecutor) {
        this.oneOffExecutor = oneOffExecutor;
        this.scheduledExecutor = scheduledExecutor;
        this.threadFactory = new DaemonThreadFactory();
    }

    public ThreadPoolJobScheduler(ExecutorService oneOffExecutor) {
        this(oneOffExecutor, null);
    }

    public void setTopLevelGroupName(String name) {
        throw new UnsupportedOperationException();
    }

    public void setParallelism(Group group, int parallelism) {
    }

    public void setThreadFactory(Group group, SchedulerThreadFactoryFactory threadFactory) {
        throw new UnsupportedOperationException();
    }

    public CallableExecutor executor(Group group) {
        return new CallableExecutorService(this.oneOffExecutor);
    }

    public MonitoredJobExecutor monitoredJobExecutor(Group group) {
        return (monitoringParams, command) -> this.oneOffExecutor.execute(command);
    }

    public int virtualThreadCount() {
        return 0;
    }

    public ThreadFactory threadFactory(Group group) {
        return this.threadFactory;
    }

    public <T> JobHandle<T> schedule(Group group, JobMonitoringParams jobMonitoringParams, Callable<T> job) {
        return new FutureJobHandle<T>(this.oneOffExecutor.submit(job));
    }

    public JobHandle<?> schedule(Group group, Runnable job) {
        return new FutureJobHandle(this.oneOffExecutor.submit(job));
    }

    public JobHandle<?> schedule(Group group, JobMonitoringParams monitoredJobParams, Runnable job) {
        return new FutureJobHandle(this.oneOffExecutor.submit(job));
    }

    public JobHandle<?> schedule(Group group, Runnable runnable, long initialDelay, TimeUnit timeUnit) {
        return new FutureJobHandle(this.scheduledExecutor.schedule(runnable, initialDelay, timeUnit));
    }

    public JobHandle<?> schedule(Group group, JobMonitoringParams monitoredJobParams, Runnable runnable, long initialDelay, TimeUnit timeUnit) {
        return new FutureJobHandle(this.scheduledExecutor.schedule(runnable, initialDelay, timeUnit));
    }

    public JobHandle<?> scheduleRecurring(Group group, Runnable runnable, long period, TimeUnit timeUnit) {
        this.throwIfScheduledExecutorIsNull();
        return new FutureJobHandle(this.scheduledExecutor.scheduleAtFixedRate(runnable, period, period, timeUnit));
    }

    public JobHandle<?> scheduleRecurring(Group group, JobMonitoringParams monitoredJobParams, Runnable runnable, long period, TimeUnit timeUnit) {
        this.throwIfScheduledExecutorIsNull();
        return new FutureJobHandle(this.scheduledExecutor.scheduleAtFixedRate(runnable, period, period, timeUnit));
    }

    public JobHandle<?> scheduleRecurring(Group group, Runnable runnable, long initialDelay, long period, TimeUnit timeUnit) {
        this.throwIfScheduledExecutorIsNull();
        return new FutureJobHandle(this.scheduledExecutor.scheduleAtFixedRate(runnable, initialDelay, period, timeUnit));
    }

    public JobHandle<?> scheduleRecurring(Group group, JobMonitoringParams monitoredJobParams, Runnable runnable, long initialDelay, long period, TimeUnit timeUnit) {
        this.throwIfScheduledExecutorIsNull();
        return new FutureJobHandle(this.scheduledExecutor.scheduleAtFixedRate(runnable, initialDelay, period, timeUnit));
    }

    public Stream<ActiveGroup> activeGroups() {
        throw new UnsupportedOperationException();
    }

    public List<MonitoredJobInfo> getMonitoredJobs() {
        throw new UnsupportedOperationException();
    }

    public List<FailedJobRun> getFailedJobRuns() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.oneOffExecutor.shutdown();
        this.ensureExecutorShutDown(this.oneOffExecutor);
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdown();
            this.ensureExecutorShutDown(this.scheduledExecutor);
        }
    }

    private void ensureExecutorShutDown(ExecutorService oneOffExecutor) {
        if (ThreadPoolJobScheduler.isNotShutdown(oneOffExecutor)) {
            oneOffExecutor.shutdownNow();
            if (ThreadPoolJobScheduler.isNotShutdown(oneOffExecutor)) {
                throw new IllegalStateException("Executors did not shutdown in time.");
            }
        }
    }

    private void throwIfScheduledExecutorIsNull() {
        if (this.scheduledExecutor == null) {
            throw new IllegalStateException("ScheduledExecutorService cannot be null when scheduling recurring tasks");
        }
    }

    private static boolean isNotShutdown(ExecutorService executor) {
        try {
            return !executor.awaitTermination(20L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return true;
        }
    }

    private static class FutureJobHandle<V>
    implements JobHandle<V> {
        private final Future<V> future;

        FutureJobHandle(Future<V> future) {
            this.future = future;
        }

        public void cancel() {
            this.future.cancel(false);
        }

        public void waitTermination() throws InterruptedException, ExecutionException {
            this.future.get();
        }

        public void waitTermination(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            this.future.get(timeout, unit);
        }

        public V get() throws ExecutionException, InterruptedException {
            return this.future.get();
        }
    }
}

