/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.conditions;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.assertj.core.api.Condition;
import org.neo4j.internal.helpers.collection.Iterables;

public final class Conditions {
    public static final Condition<Boolean> TRUE = new Condition(value -> value, "Should be true.", new Object[0]);
    public static final Condition<Boolean> FALSE = new Condition(value -> value == false, "Should be false.", new Object[0]);

    private Conditions() {
    }

    public static <T> Condition<T> condition(Predicate<T> predicate) {
        Objects.requireNonNull(predicate);
        return new Condition(predicate, "Generic condition. See predicate for condition details.", new Object[0]);
    }

    public static <T> Condition<Iterable<T>> contains(T value) {
        Objects.requireNonNull(value);
        return new Condition(v -> Iterables.stream((Iterable)v).anyMatch(value::equals), "Should contain " + String.valueOf(value), new Object[0]);
    }

    public static <T> Condition<String> contains(String value) {
        Objects.requireNonNull(value);
        return new Condition(v -> v.contains(value), "Should contain string \"%s\"", new Object[]{value});
    }

    public static <T> Condition<T> equalityCondition(T value) {
        Objects.requireNonNull(value);
        return new Condition(value::equals, "Should be equal to " + String.valueOf(value), new Object[0]);
    }

    public static <T extends Comparable<T>> Condition<T> greaterThan(T value) {
        Objects.requireNonNull(value);
        return new Condition(v -> v.compareTo(value) > 0, "Should be greater than " + String.valueOf(value), new Object[0]);
    }

    public static <T extends Comparable<T>> Condition<T> greaterThanOrEqualTo(T value) {
        Objects.requireNonNull(value);
        return new Condition(v -> v.compareTo(value) >= 0, "Should be greater than or equal to " + String.valueOf(value), new Object[0]);
    }

    public static <T extends Comparable<T>> Condition<T> lessThan(T value) {
        Objects.requireNonNull(value);
        return new Condition(v -> v.compareTo(value) < 0, "Should be less than " + String.valueOf(value), new Object[0]);
    }

    public static <T extends Comparable<T>> Condition<T> lessThanOrEqualTo(T value) {
        Objects.requireNonNull(value);
        return new Condition(v -> v.compareTo(value) <= 0, "Should be less than or equal to " + String.valueOf(value), new Object[0]);
    }

    public static <T> Condition<T> instanceOf(Class<?> type) {
        Objects.requireNonNull(type);
        return new Condition(type::isInstance, "Should be instance of " + type.getName(), new Object[0]);
    }

    public static <T extends Collection<?>> Condition<T> sizeCondition(int expectedSize) {
        return new Condition(v -> v.size() == expectedSize, "Size should be equal to " + expectedSize, new Object[0]);
    }

    public static Condition<? super List<? extends String>> containsAtLeastTheseLines(Pattern ... expectedLinePatterns) {
        return new Condition(lines -> {
            if (expectedLinePatterns.length > lines.size()) {
                return false;
            }
            int e = 0;
            for (int i = 0; i < lines.size(); ++i) {
                String line = (String)lines.get(i);
                while (!expectedLinePatterns[e].matcher(line).matches()) {
                    if (++i >= lines.size()) {
                        return false;
                    }
                    line = (String)lines.get(i);
                }
                ++e;
            }
            return true;
        }, "Expected: " + String.valueOf(Arrays.asList(expectedLinePatterns)), new Object[0]);
    }
}

