/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class Unzip {
    private Unzip() {
    }

    public static Path unzip(Class<?> testClass, String resource, Path targetDirectory) throws IOException {
        return Unzip.unzip(Unzip.getResourceAsStream(testClass, resource), targetDirectory);
    }

    private static InputStream getResourceAsStream(Class<?> testClass, String resource) throws IOException {
        InputStream stream = testClass.getResourceAsStream(resource);
        if (stream != null) {
            return stream;
        }
        Path path = Path.of(resource, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            return Files.newInputStream(path, StandardOpenOption.READ);
        }
        throw new NoSuchFileException("Could not find resource '" + resource + "' to unzip");
    }

    public static Path unzip(InputStream source, Path targetDirectory) throws IOException {
        try (ZipInputStream zipStream = new ZipInputStream(source);){
            ZipEntry entry;
            byte[] scratch = new byte[8096];
            while ((entry = zipStream.getNextEntry()) != null) {
                if (entry.isDirectory()) {
                    Files.createDirectories(targetDirectory.resolve(entry.getName()), new FileAttribute[0]);
                } else {
                    try (BufferedOutputStream file = new BufferedOutputStream(Files.newOutputStream(targetDirectory.resolve(entry.getName()), new OpenOption[0]));){
                        int read;
                        while ((read = zipStream.read(scratch)) != -1) {
                            file.write(scratch, 0, read);
                        }
                    }
                }
                zipStream.closeEntry();
            }
        }
        return targetDirectory;
    }
}

