/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import org.neo4j.util.Preconditions;

public final class ReflectionUtil {
    private ReflectionUtil() {
    }

    public static <T> T callCopyConstructor(T obj) {
        try {
            Class<?> objClass = obj.getClass();
            return (T)objClass.getDeclaredConstructor(objClass).newInstance(obj);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static void verifyMethodExists(Class<?> owner, String methodName) {
        HashSet methods = new HashSet();
        Arrays.stream(owner.getDeclaredMethods()).forEach(method -> methods.add(method.getName()));
        Arrays.stream(owner.getMethods()).forEach(method -> methods.add(method.getName()));
        Preconditions.checkState((boolean)methods.stream().anyMatch(existingMethodName -> existingMethodName.equals(methodName)), (String)"Method '%s' does not exist in class %s", (Object[])new Object[]{methodName, owner});
    }
}

