/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.proxy;

import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.io.IOUtils;
import org.neo4j.proxy.Neo4jProxy;
import org.neo4j.proxy.ProxyConfiguration;
import org.netcrusher.core.reactor.NioReactor;
import org.netcrusher.tcp.TcpCrusher;
import org.netcrusher.tcp.TcpCrusherBuilder;

public class TcpCrusherProxy
implements Neo4jProxy {
    private final Duration WAIT_FOR_OPERATION_TO_APPLY = Duration.ofSeconds(10L);
    private final NioReactor reactor;
    private volatile boolean started = true;
    private final TcpCrusher tcpCrusher;

    private TcpCrusherProxy(ProxyConfiguration proxyConfiguration, NioReactor reactor) {
        this.reactor = reactor;
        this.tcpCrusher = TcpCrusherBuilder.builder().withReactor(reactor).withBindAddress(proxyConfiguration.advertisedAddress().getHostName(), proxyConfiguration.advertisedAddress().getPort()).withConnectAddress(proxyConfiguration.listenAddress().getHostName(), proxyConfiguration.listenAddress().getPort()).buildAndOpen();
        if (reactor == null) {
            throw new IllegalArgumentException("Nio reactor should be set");
        }
    }

    @Override
    public void freezeConnection() {
        this.tcpCrusher.freeze();
        this.waitForOperationToBeApplied(() -> !this.tcpCrusher.isFrozen());
    }

    @Override
    public void unfreezeConnection() {
        this.tcpCrusher.unfreeze();
        this.waitForOperationToBeApplied(() -> ((TcpCrusher)this.tcpCrusher).isFrozen());
    }

    @Override
    public void closeAllConnection() {
        this.tcpCrusher.closeAllPairs();
        this.waitForOperationToBeApplied(() -> !this.tcpCrusher.getClientAddresses().isEmpty());
    }

    @Override
    public void stopAcceptingConnections() {
        this.tcpCrusher.close();
        this.waitForOperationToBeApplied(() -> ((TcpCrusher)this.tcpCrusher).isOpen());
    }

    @Override
    public void startAcceptingConnections() {
        this.tcpCrusher.open();
        this.waitForOperationToBeApplied(() -> !this.tcpCrusher.isOpen());
    }

    @Override
    public ProxyConfiguration getProxyConfig() {
        return new ProxyConfiguration(this.tcpCrusher.getConnectAddress(), this.tcpCrusher.getBindAddress());
    }

    @Override
    public void close() {
        if (!this.started) {
            throw new IllegalStateException("Proxy is already stopped");
        }
        this.started = false;
        IOUtils.closeQuietly((Closeable)this.tcpCrusher);
        IOUtils.closeQuietly((Closeable)this.reactor);
    }

    private void waitForOperationToBeApplied(Supplier<Boolean> function) {
        Instant start = Instant.now();
        while (function.get().booleanValue()) {
            Instant now = Instant.now();
            if (Duration.between(start, now).compareTo(this.WAIT_FOR_OPERATION_TO_APPLY) > 0) {
                throw new IllegalStateException("Operation didn't complete for " + String.valueOf(this.WAIT_FOR_OPERATION_TO_APPLY));
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Optional<ProxyConfiguration> proxyConfiguration = Optional.empty();
        private Optional<NioReactor> reactor = Optional.empty();

        public Builder withProxyConfig(ProxyConfiguration proxyConfiguration) {
            this.proxyConfiguration = Optional.of(proxyConfiguration);
            return this;
        }

        public Neo4jProxy build() {
            ProxyConfiguration proxyConfig = this.proxyConfiguration.orElseThrow(() -> new IllegalStateException("Initialize the proxy configuration"));
            try {
                NioReactor reactor = this.reactor.orElse(new NioReactor());
                return new TcpCrusherProxy(proxyConfig, reactor);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

